/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.test.AllTests;

public class ECAlgorithmsTest
extends TestCase {
    private static final int SCALE = 4;
    private static final SecureRandom RND = new SecureRandom();
    static /* synthetic */ Class class$org$bouncycastle$math$ec$test$ECAlgorithmsTest;

    public void testSumOfMultiplies() {
        X9ECParameters x9 = CustomNamedCurves.getByName((String)"secp256r1");
        Assert.assertNotNull((Object)x9);
        this.doTestSumOfMultiplies(x9);
    }

    public void testSumOfMultipliesComplete() {
        List x9s = this.getTestCurves();
        Iterator it = x9s.iterator();
        while (it.hasNext()) {
            X9ECParameters x9 = (X9ECParameters)it.next();
            this.doTestSumOfMultiplies(x9);
        }
    }

    public void testSumOfTwoMultiplies() {
        X9ECParameters x9 = CustomNamedCurves.getByName((String)"secp256r1");
        Assert.assertNotNull((Object)x9);
        this.doTestSumOfTwoMultiplies(x9);
    }

    public void testSumOfTwoMultipliesComplete() {
        List x9s = this.getTestCurves();
        Iterator it = x9s.iterator();
        while (it.hasNext()) {
            X9ECParameters x9 = (X9ECParameters)it.next();
            this.doTestSumOfTwoMultiplies(x9);
        }
    }

    private void doTestSumOfMultiplies(X9ECParameters x9) {
        ECPoint[] points = new ECPoint[4];
        BigInteger[] scalars = new BigInteger[4];
        int i = 0;
        while (i < 4) {
            points[i] = this.getRandomPoint(x9);
            scalars[i] = this.getRandomScalar(x9);
            ++i;
        }
        ECPoint u = x9.getCurve().getInfinity();
        int i2 = 0;
        while (i2 < 4) {
            u = u.add(points[i2].multiply(scalars[i2]));
            ECPoint v = ECAlgorithms.sumOfMultiplies((ECPoint[])this.copyPoints(points, i2 + 1), (BigInteger[])this.copyScalars(scalars, i2 + 1));
            ECPoint[] results = new ECPoint[]{u, v};
            x9.getCurve().normalizeAll(results);
            this.assertPointsEqual("ECAlgorithms.sumOfMultiplies is incorrect", results[0], results[1]);
            ++i2;
        }
    }

    private void doTestSumOfTwoMultiplies(X9ECParameters x9) {
        ECPoint p = this.getRandomPoint(x9);
        BigInteger a = this.getRandomScalar(x9);
        int i = 0;
        while (i < 4) {
            ECPoint q = this.getRandomPoint(x9);
            BigInteger b = this.getRandomScalar(x9);
            ECPoint u = p.multiply(a).add(q.multiply(b));
            ECPoint v = ECAlgorithms.shamirsTrick((ECPoint)p, (BigInteger)a, (ECPoint)q, (BigInteger)b);
            ECPoint w = ECAlgorithms.sumOfTwoMultiplies((ECPoint)p, (BigInteger)a, (ECPoint)q, (BigInteger)b);
            ECPoint[] results = new ECPoint[]{u, v, w};
            x9.getCurve().normalizeAll(results);
            this.assertPointsEqual("ECAlgorithms.shamirsTrick is incorrect", results[0], results[1]);
            this.assertPointsEqual("ECAlgorithms.sumOfTwoMultiplies is incorrect", results[0], results[2]);
            p = q;
            a = b;
            ++i;
        }
    }

    private void assertPointsEqual(String message, ECPoint a, ECPoint b) {
        Assert.assertEquals((String)message, (Object)a, (Object)b);
    }

    private ECPoint[] copyPoints(ECPoint[] ps, int len) {
        ECPoint[] result = new ECPoint[len];
        System.arraycopy(ps, 0, result, 0, len);
        return result;
    }

    private BigInteger[] copyScalars(BigInteger[] ks, int len) {
        BigInteger[] result = new BigInteger[len];
        System.arraycopy(ks, 0, result, 0, len);
        return result;
    }

    private ECPoint getRandomPoint(X9ECParameters x9) {
        return x9.getG().multiply(this.getRandomScalar(x9));
    }

    private BigInteger getRandomScalar(X9ECParameters x9) {
        return new BigInteger(x9.getN().bitLength(), RND);
    }

    private List getTestCurves() {
        ArrayList x9s = new ArrayList();
        HashSet names = new HashSet(AllTests.enumToList(ECNamedCurveTable.getNames()));
        names.addAll(AllTests.enumToList(CustomNamedCurves.getNames()));
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            X9ECParameters x9 = ECNamedCurveTable.getByName((String)name);
            if (x9 != null) {
                this.addTestCurves(x9s, x9);
            }
            if ((x9 = CustomNamedCurves.getByName((String)name)) == null) continue;
            this.addTestCurves(x9s, x9);
        }
        return x9s;
    }

    private void addTestCurves(List x9s, X9ECParameters x9) {
        ECCurve curve = x9.getCurve();
        int[] coords = ECCurve.getAllCoordinateSystems();
        int i = 0;
        while (i < coords.length) {
            int coord = coords[i];
            if (curve.getCoordinateSystem() == coord) {
                x9s.add(x9);
            } else if (curve.supportsCoordinateSystem(coord)) {
                ECCurve c = curve.configure().setCoordinateSystem(coord).create();
                x9s.add(new X9ECParameters(c, new X9ECPoint(c.importPoint(x9.getG()), false), x9.getN(), x9.getH()));
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$bouncycastle$math$ec$test$ECAlgorithmsTest == null ? (class$org$bouncycastle$math$ec$test$ECAlgorithmsTest = ECAlgorithmsTest.class$("org.bouncycastle.math.ec.test.ECAlgorithmsTest")) : class$org$bouncycastle$math$ec$test$ECAlgorithmsTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

