/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.rfc7748.test;

import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public class X25519Test
extends TestCase {
    private static final SecureRandom RANDOM = new SecureRandom();

    public void setUp() {
        X25519.precompute();
    }

    public void testConsistency() {
        byte[] u = new byte[32];
        u[0] = 9;
        byte[] k = new byte[32];
        byte[] rF = new byte[32];
        byte[] rV = new byte[32];
        int i = 1;
        while (i <= 100) {
            RANDOM.nextBytes(k);
            X25519.scalarMultBase((byte[])k, (int)0, (byte[])rF, (int)0);
            X25519.scalarMult((byte[])k, (int)0, (byte[])u, (int)0, (byte[])rV, (int)0);
            Assert.assertTrue((String)("Consistency #" + i), (boolean)Arrays.areEqual((byte[])rF, (byte[])rV));
            ++i;
        }
    }

    public void testECDH() {
        byte[] kA = new byte[32];
        byte[] kB = new byte[32];
        byte[] qA = new byte[32];
        byte[] qB = new byte[32];
        byte[] sA = new byte[32];
        byte[] sB = new byte[32];
        int i = 1;
        while (i <= 100) {
            X25519.generatePrivateKey((SecureRandom)RANDOM, (byte[])kA);
            X25519.generatePrivateKey((SecureRandom)RANDOM, (byte[])kB);
            X25519.generatePublicKey((byte[])kA, (int)0, (byte[])qA, (int)0);
            X25519.generatePublicKey((byte[])kB, (int)0, (byte[])qB, (int)0);
            boolean rA = X25519.calculateAgreement((byte[])kA, (int)0, (byte[])qB, (int)0, (byte[])sA, (int)0);
            boolean rB = X25519.calculateAgreement((byte[])kB, (int)0, (byte[])qA, (int)0, (byte[])sB, (int)0);
            Assert.assertTrue((String)("ECDH #" + i), (rA == rB && Arrays.areEqual((byte[])sA, (byte[])sB) ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testECDHVector1() {
        X25519Test.checkECDHVector("77076d0a7318a57d3c16c17251b26645df4c2f87ebc0992ab177fba51db92c2a", "8520f0098930a754748b7ddcb43ef75a0dbf3a0d26381af4eba4a98eaa9b4e6a", "5dab087e624a8a4b79e17f8b83800ee66f3bb1292618b6fd1c2f8b27ff88e0eb", "de9edb7d7b7dc1b4d35b61c2ece435373f8343c85b78674dadfc7e146f882b4f", "4a5d9d5ba4ce2de1728e3bf480350f25e07e21c947d19e3376f09b3c1e161742", "ECDH Vector #1");
    }

    public void testX25519Iterated() {
        X25519Test.checkIterated(1000);
    }

    public void testX25519Vector1() {
        X25519Test.checkX25519Vector("a546e36bf0527c9d3b16154b82465edd62144c0ac1fc5a18506a2244ba449ac4", "e6db6867583030db3594c1a424b15f7c726624ec26b3353b10a903a6d0ab1c4c", "c3da55379de9c6908e94ea4df28d084f32eccf03491c71f754b4075577a28552", "Vector #1");
    }

    public void testX25519Vector2() {
        X25519Test.checkX25519Vector("4b66e9d4d1b4673c5ad22691957d6af5c11b6421e0ea01d42ca4169e7918ba0d", "e5210f12786811d3f4b7959d0538ae2c31dbe7106fc03c3efc4cd549c715a493", "95cbde9476e8907d7aade45cb4b873f88b595a68799fa152e6f8f7647aac7957", "Vector #2");
    }

    private static void checkECDHVector(String sA, String sAPub, String sB, String sBPub, String sK, String text) {
        byte[] a = Hex.decode((String)sA);
        Assert.assertEquals((int)32, (int)a.length);
        byte[] b = Hex.decode((String)sB);
        Assert.assertEquals((int)32, (int)b.length);
        byte[] aPub = new byte[32];
        X25519.scalarMultBase((byte[])a, (int)0, (byte[])aPub, (int)0);
        X25519Test.checkValue(aPub, text, sAPub);
        byte[] bPub = new byte[32];
        X25519.scalarMultBase((byte[])b, (int)0, (byte[])bPub, (int)0);
        X25519Test.checkValue(bPub, text, sBPub);
        byte[] aK = new byte[32];
        X25519.scalarMult((byte[])a, (int)0, (byte[])bPub, (int)0, (byte[])aK, (int)0);
        X25519Test.checkValue(aK, text, sK);
        byte[] bK = new byte[32];
        X25519.scalarMult((byte[])b, (int)0, (byte[])aPub, (int)0, (byte[])bK, (int)0);
        X25519Test.checkValue(bK, text, sK);
    }

    private static void checkIterated(int count) {
        Assert.assertEquals((int)32, (int)32);
        byte[] k = new byte[32];
        k[0] = 9;
        byte[] u = new byte[32];
        u[0] = 9;
        byte[] r = new byte[32];
        int iterations = 0;
        while (iterations < count) {
            X25519.scalarMult((byte[])k, (int)0, (byte[])u, (int)0, (byte[])r, (int)0);
            System.arraycopy(k, 0, u, 0, 32);
            System.arraycopy(r, 0, k, 0, 32);
            switch (++iterations) {
                case 1: {
                    X25519Test.checkValue(k, "Iterated @1", "422c8e7a6227d7bca1350b3e2bb7279f7897b87bb6854b783c60e80311ae3079");
                    break;
                }
                case 1000: {
                    X25519Test.checkValue(k, "Iterated @1000", "684cf59ba83309552800ef566f2f4d3c1c3887c49360e3875f2eb94d99532c51");
                    break;
                }
                case 1000000: {
                    X25519Test.checkValue(k, "Iterated @1000000", "7c3911e0ab2586fd864497297e575e6f3bc601c0883c30df5f4dd2d24f665424");
                    break;
                }
            }
        }
    }

    private static void checkValue(byte[] n, String text, String se) {
        byte[] e = Hex.decode((String)se);
        Assert.assertTrue((String)text, (boolean)Arrays.areEqual((byte[])e, (byte[])n));
    }

    private static void checkX25519Vector(String sk, String su, String se, String text) {
        byte[] k = Hex.decode((String)sk);
        Assert.assertEquals((int)32, (int)k.length);
        byte[] u = Hex.decode((String)su);
        Assert.assertEquals((int)32, (int)u.length);
        byte[] r = new byte[32];
        X25519.scalarMult((byte[])k, (int)0, (byte[])u, (int)0, (byte[])r, (int)0);
        X25519Test.checkValue(r, text, se);
    }
}

