/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.raw.Nat;

public class SecP384R1FieldTest
extends TestCase {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final X9ECParameters DP = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)SECObjectIdentifiers.secp384r1);
    private static final BigInteger Q = DP.getCurve().getField().getCharacteristic();

    public void testMultiply1() {
        int COUNT = 1000;
        int i = 0;
        while (i < COUNT) {
            ECFieldElement x = this.generateMultiplyInput_Random();
            ECFieldElement y = this.generateMultiplyInput_Random();
            BigInteger X = x.toBigInteger();
            BigInteger Y = y.toBigInteger();
            BigInteger R = X.multiply(Y).mod(Q);
            ECFieldElement z = x.multiply(y);
            BigInteger Z = z.toBigInteger();
            Assert.assertEquals((Object)R, (Object)Z);
            ++i;
        }
    }

    public void testMultiply2() {
        int COUNT = 100;
        ECFieldElement[] inputs = new ECFieldElement[COUNT];
        BigInteger[] INPUTS = new BigInteger[COUNT];
        int i = 0;
        while (i < inputs.length) {
            inputs[i] = this.generateMultiplyInput_Random();
            INPUTS[i] = inputs[i].toBigInteger();
            ++i;
        }
        int j = 0;
        while (j < inputs.length) {
            int k = 0;
            while (k < inputs.length) {
                BigInteger R = INPUTS[j].multiply(INPUTS[k]).mod(Q);
                ECFieldElement z = inputs[j].multiply(inputs[k]);
                BigInteger Z = z.toBigInteger();
                Assert.assertEquals((Object)R, (Object)Z);
                ++k;
            }
            ++j;
        }
    }

    public void testSquare() {
        int COUNT = 1000;
        int i = 0;
        while (i < COUNT) {
            ECFieldElement x = this.generateMultiplyInput_Random();
            BigInteger X = x.toBigInteger();
            BigInteger R = X.multiply(X).mod(Q);
            ECFieldElement z = x.square();
            BigInteger Z = z.toBigInteger();
            Assert.assertEquals((Object)R, (Object)Z);
            ++i;
        }
    }

    public void testSquare_CarryBug() {
        int COUNT = 100;
        int i = 0;
        while (i < COUNT) {
            ECFieldElement x = this.generateSquareInput_CarryBug();
            BigInteger X = x.toBigInteger();
            BigInteger R = X.multiply(X).mod(Q);
            ECFieldElement z = x.square();
            BigInteger Z = z.toBigInteger();
            Assert.assertEquals((Object)R, (Object)Z);
            ++i;
        }
    }

    public void testSquare_CarryBug_Reported() {
        ECFieldElement x = this.fe(new BigInteger("2fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffd", 16));
        BigInteger X = x.toBigInteger();
        BigInteger R = X.multiply(X).mod(Q);
        ECFieldElement z = x.square();
        BigInteger Z = z.toBigInteger();
        Assert.assertEquals((Object)R, (Object)Z);
    }

    private ECFieldElement fe(BigInteger x) {
        return DP.getCurve().fromBigInteger(x);
    }

    private ECFieldElement generateMultiplyInput_Random() {
        return this.fe(new BigInteger(DP.getCurve().getFieldSize() + 32, RANDOM).mod(Q));
    }

    private ECFieldElement generateSquareInput_CarryBug() {
        int[] x = Nat.create((int)12);
        x[0] = RANDOM.nextInt() >>> 1;
        x[6] = 2;
        x[10] = -65536;
        x[11] = -1;
        return this.fe(Nat.toBigInteger((int)12, (int[])x));
    }
}

