/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Assert;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public class SMIMETestUtil {
    public static final boolean DEBUG = true;

    public static MimeBodyPart makeMimeBodyPart(String msg) throws MessagingException {
        MimeBodyPart _mbp = new MimeBodyPart();
        _mbp.setText(msg);
        return _mbp;
    }

    public static MimeBodyPart makeMimeBodyPart(MimeMultipart mm) throws MessagingException {
        MimeBodyPart _mbp = new MimeBodyPart();
        _mbp.setContent((Object)mm, mm.getContentType());
        return _mbp;
    }

    public static MimeMultipart makeMimeMultipart(String msg1, String msg2) throws MessagingException {
        MimeMultipart _mm = new MimeMultipart();
        _mm.addBodyPart((BodyPart)SMIMETestUtil.makeMimeBodyPart(msg1));
        _mm.addBodyPart((BodyPart)SMIMETestUtil.makeMimeBodyPart(msg2));
        return _mm;
    }

    public static void verifyMessageBytes(MimeBodyPart a, MimeBodyPart b) throws IOException, MessagingException {
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        a.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _msgBytes = _baos.toByteArray();
        _baos = new ByteArrayOutputStream();
        b.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _resBytes = _baos.toByteArray();
        Assert.assertEquals((boolean)true, (boolean)Arrays.areEqual((byte[])_msgBytes, (byte[])_resBytes));
    }

    public static void verifyMessageBytes(MimeMessage a, MimeBodyPart b) throws IOException, MessagingException {
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        a.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _msgBytes = _baos.toByteArray();
        _baos = new ByteArrayOutputStream();
        b.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _resBytes = _baos.toByteArray();
        Assert.assertEquals((boolean)true, (boolean)Arrays.areEqual((byte[])_msgBytes, (byte[])_resBytes));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

