/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.CMSTestUtil;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class SMIMEMiscTest
extends TestCase {
    static MimeBodyPart msg;
    static String signDN;
    static KeyPair signKP;
    static X509Certificate signCert;
    static String origDN;
    static KeyPair origKP;
    static X509Certificate origCert;
    static String reciDN;
    static KeyPair reciKP;
    static X509Certificate reciCert;
    private static final JcaX509CertSelectorConverter selectorConverter;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;
    static /* synthetic */ Class class$org$bouncycastle$mail$smime$test$SMIMEMiscTest;

    public SMIMEMiscTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        TestRunner.run((Class)(class$org$bouncycastle$mail$smime$test$SMIMEMiscTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMEMiscTest = SMIMEMiscTest.class$("org.bouncycastle.mail.smime.test.SMIMEMiscTest")) : class$org$bouncycastle$mail$smime$test$SMIMEMiscTest));
    }

    public void testSHA256WithRSAParserEncryptedWithAES() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMEEnvelopedGenerator encGen = new SMIMEEnvelopedGenerator();
        encGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(origCert).setProvider("BC"));
        MimeBodyPart mp = encGen.generate(msg, new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build());
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA256withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smm = gen.generate(mp);
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), (MimeMultipart)msg.getContent());
        certs = s.getCertificates();
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners((Store)certs, s.getSignerInfos());
        tmpFile.delete();
    }

    public void testSHA256WithRSACompressed() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMECompressedGenerator cGen = new SMIMECompressedGenerator();
        MimeBodyPart mp = cGen.generate(msg, (OutputCompressor)new ZlibCompressor());
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA256withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smm = gen.generate(mp);
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESigned s = new SMIMESigned((MimeMultipart)msg.getContent());
        certs = s.getCertificates();
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners((Store)certs, s.getSignerInfos());
        tmpFile.delete();
    }

    public void testQuotePrintableSigPreservation() throws Exception {
        MimeMessage msg = new MimeMessage((Session)null, ((Object)((Object)this)).getClass().getResourceAsStream("qp-soft-break.eml"));
        SMIMEEnvelopedGenerator encGen = new SMIMEEnvelopedGenerator();
        encGen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(origCert).setProvider("BC"));
        MimeBodyPart mp = encGen.generate(msg, new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).setProvider("BC").build());
        SMIMEEnveloped env = new SMIMEEnveloped(mp);
        RecipientInformation ri = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        FileBackedMimeBodyPart mm = SMIMEUtil.toMimeBodyPart((CMSTypedStream)ri.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(origKP.getPrivate()).setProvider("BC")));
        SMIMESigned s = new SMIMESigned((MimeMultipart)mm.getContent());
        Collection c = s.getSignerInfos().getSigners();
        Iterator it = c.iterator();
        Store certs = s.getCertificates();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert)));
        }
        mm.dispose();
    }

    public void testSHA256WithRSAParserCompressed() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMECompressedGenerator cGen = new SMIMECompressedGenerator();
        MimeBodyPart mp = cGen.generate(msg, (OutputCompressor)new ZlibCompressor());
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA256withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smm = gen.generate(mp);
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build(), (MimeMultipart)msg.getContent());
        certs = s.getCertificates();
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners((Store)certs, s.getSignerInfos());
        tmpFile.delete();
    }

    public void testBrokenEnvelope() throws Exception {
        block2: {
            Session session = Session.getDefaultInstance((Properties)System.getProperties(), null);
            MimeMessage msg = new MimeMessage(session, ((Object)((Object)this)).getClass().getResourceAsStream("brokenEnv.message"));
            try {
                new SMIMEEnveloped(msg);
            }
            catch (CMSException e) {
                if (e.getMessage().equals("Malformed content.")) break block2;
                Assert.fail((String)"wrong exception on bogus envelope");
            }
        }
    }

    private void verifySigners(Store certs, SignerInformationStore signers) throws Exception {
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert)));
        }
    }

    private void verifyMessageBytes(MimeBodyPart a, MimeBodyPart b) throws Exception {
        ByteArrayOutputStream bOut1 = new ByteArrayOutputStream();
        a.writeTo((OutputStream)bOut1);
        bOut1.close();
        ByteArrayOutputStream bOut2 = new ByteArrayOutputStream();
        b.writeTo((OutputStream)bOut2);
        bOut2.close();
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(bOut1.toByteArray(), bOut2.toByteArray()));
    }

    private MimeMessage createMimeMessage(File tmpFile, MimeMultipart smm) throws Exception {
        FileOutputStream fOut = new FileOutputStream(tmpFile);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)fromUser);
        body.setRecipient(Message.RecipientType.TO, (Address)toUser);
        body.setSubject("example signed message");
        body.setContent((Object)smm, smm.getContentType());
        body.saveChanges();
        body.writeTo((OutputStream)fOut);
        fOut.close();
        return new MimeMessage(session, (InputStream)new FileInputStream(tmpFile));
    }

    private ASN1EncodableVector generateSignedAttributes() {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        return signedAttrs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        selectorConverter = new JcaX509CertSelectorConverter();
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            msg = SMIMETestUtil.makeMimeBodyPart("Hello world!\n");
            signDN = "O=Bouncy Castle, C=AU";
            signKP = CMSTestUtil.makeKeyPair();
            signCert = CMSTestUtil.makeCertificate(signKP, signDN, signKP, signDN);
            origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            origKP = CMSTestUtil.makeKeyPair();
            origCert = CMSTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        }
        catch (Exception e) {
            throw new RuntimeException("problem setting up signed test class: " + e);
        }
    }
}

