/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.jcajce.ZlibCompressor;
import org.bouncycastle.cms.jcajce.ZlibExpanderProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMECompressed;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMECompressedParser;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.CMSTestUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class SMIMECompressedTest
extends TestCase {
    private static final String COMPRESSED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7z\"; smime-type=compressed-data";
    private static final JcaX509CertSelectorConverter selectorConverter = new JcaX509CertSelectorConverter();
    private static MimeBodyPart msg;
    private static String signDN;
    private static KeyPair signKP;
    private static X509Certificate signCert;
    private static String origDN;
    private static KeyPair origKP;
    private static X509Certificate origCert;
    static /* synthetic */ Class class$org$bouncycastle$mail$smime$test$SMIMECompressedTest;

    public SMIMECompressedTest(String name) throws Exception {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$mail$smime$test$SMIMECompressedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMECompressedTest = SMIMECompressedTest.class$("org.bouncycastle.mail.smime.test.SMIMECompressedTest")) : class$org$bouncycastle$mail$smime$test$SMIMECompressedTest));
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(class$org$bouncycastle$mail$smime$test$SMIMECompressedTest == null ? (class$org$bouncycastle$mail$smime$test$SMIMECompressedTest = SMIMECompressedTest.class$("org.bouncycastle.mail.smime.test.SMIMECompressedTest")) : class$org$bouncycastle$mail$smime$test$SMIMECompressedTest));
    }

    public void testHeaders() throws Exception {
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        MimeBodyPart cbp = cgen.generate(msg, (OutputCompressor)new ZlibCompressor());
        Assert.assertEquals((String)COMPRESSED_CONTENT_TYPE, (String)cbp.getHeader("Content-Type")[0]);
        Assert.assertEquals((String)"attachment; filename=\"smime.p7z\"", (String)cbp.getHeader("Content-Disposition")[0]);
        Assert.assertEquals((String)"S/MIME Compressed Message", (String)cbp.getHeader("Content-Description")[0]);
    }

    public void testBasic() throws Exception {
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        MimeBodyPart cbp = cgen.generate(msg, (OutputCompressor)new ZlibCompressor());
        SMIMECompressed sc = new SMIMECompressed(cbp);
        msg.writeTo((OutputStream)bOut);
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])bOut.toByteArray(), (byte[])sc.getContent((InputExpanderProvider)new ZlibExpanderProvider())));
    }

    /*
     * WARNING - void declaration
     */
    public void testParser() throws Exception {
        int ch;
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        ByteArrayOutputStream bOut1 = new ByteArrayOutputStream();
        ByteArrayOutputStream bOut2 = new ByteArrayOutputStream();
        MimeBodyPart cbp = cgen.generate(msg, (OutputCompressor)new ZlibCompressor());
        SMIMECompressedParser sc = new SMIMECompressedParser(cbp);
        msg.writeTo((OutputStream)bOut1);
        InputStream in = sc.getContent((InputExpanderProvider)new ZlibExpanderProvider()).getContentStream();
        while ((ch = in.read()) >= 0) {
            void var7_7;
            bOut2.write((int)var7_7);
        }
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])bOut1.toByteArray(), (byte[])bOut2.toByteArray()));
    }

    public void testCompressedSHA1WithRSA() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smp = gen.generate(msg);
        MimeMessage bp2 = new MimeMessage((Session)null);
        bp2.setContent((Multipart)smp);
        bp2.saveChanges();
        SMIMECompressedGenerator cgen = new SMIMECompressedGenerator();
        MimeBodyPart cbp = cgen.generate(bp2, (OutputCompressor)new ZlibCompressor());
        SMIMECompressed cm = new SMIMECompressed(cbp);
        MimeMultipart mm = (MimeMultipart)SMIMEUtil.toMimeBodyPart((byte[])cm.getContent((InputExpanderProvider)new ZlibExpanderProvider())).getContent();
        SMIMESigned s = new SMIMESigned(mm);
        ByteArrayOutputStream _baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _msgBytes = _baos.toByteArray();
        _baos = new ByteArrayOutputStream();
        s.getContent().writeTo((OutputStream)_baos);
        _baos.close();
        byte[] _resBytes = _baos.toByteArray();
        Assert.assertEquals((boolean)true, (boolean)Arrays.areEqual((byte[])_msgBytes, (byte[])_resBytes));
        certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            msg = SMIMETestUtil.makeMimeBodyPart("Hello world!");
            signDN = "O=Bouncy Castle, C=AU";
            signKP = CMSTestUtil.makeKeyPair();
            signCert = CMSTestUtil.makeCertificate(signKP, signDN, signKP, signDN);
            origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            origKP = CMSTestUtil.makeKeyPair();
            origCert = CMSTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        }
        catch (Exception e) {
            throw new RuntimeException("problem setting up signed test class: " + e);
        }
    }
}

