/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.test.CMSTestUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class NewSMIMESignedTest
extends TestCase {
    static MimeBodyPart msg;
    static MimeBodyPart msgR;
    static MimeBodyPart msgRN;
    static String _origDN;
    static KeyPair _origKP;
    static X509Certificate _origCert;
    static String _signDN;
    static KeyPair _signKP;
    static X509Certificate _signCert;
    static String reciDN;
    static KeyPair reciKP;
    static X509Certificate reciCert;
    private static KeyPair _signGostKP;
    private static X509Certificate _signGostCert;
    private static KeyPair _signEcDsaKP;
    private static X509Certificate _signEcDsaCert;
    private static KeyPair _signEcGostKP;
    private static X509Certificate _signEcGostCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;
    private static final String BC = "BC";
    static /* synthetic */ Class class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest;

    public NewSMIMESignedTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest == null ? (class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest = NewSMIMESignedTest.class$("org.bouncycastle.mail.smime.test.NewSMIMESignedTest")) : class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest));
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest == null ? (class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest = NewSMIMESignedTest.class$("org.bouncycastle.mail.smime.test.NewSMIMESignedTest")) : class$org$bouncycastle$mail$smime$test$NewSMIMESignedTest));
    }

    public void testHeaders() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        BodyPart bp = smm.getBodyPart(1);
        Assert.assertEquals((String)"application/pkcs7-signature; name=smime.p7s; smime-type=signed-data", (String)bp.getHeader("Content-Type")[0]);
        Assert.assertEquals((String)"attachment; filename=\"smime.p7s\"", (String)bp.getHeader("Content-Disposition")[0]);
        Assert.assertEquals((String)"S/MIME Cryptographic Signature", (String)bp.getHeader("Content-Description")[0]);
    }

    public void testHeadersEncapsulated() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeBodyPart res = gen.generateEncapsulated(msg);
        Assert.assertEquals((String)"application/pkcs7-mime; name=smime.p7m; smime-type=signed-data", (String)res.getHeader("Content-Type")[0]);
        Assert.assertEquals((String)"attachment; filename=\"smime.p7m\"", (String)res.getHeader("Content-Disposition")[0]);
        Assert.assertEquals((String)"S/MIME Cryptographic Signed Data", (String)res.getHeader("Content-Description")[0]);
    }

    public void testMultipartTextText() throws Exception {
        MimeBodyPart part1 = this.createTemplate("text/html", "7bit");
        MimeBodyPart part2 = this.createTemplate("text/xml", "7bit");
        this.multipartMixedTest(part1, part2);
    }

    public void testMultipartTextBinary() throws Exception {
        MimeBodyPart part1 = this.createTemplate("text/html", "7bit");
        MimeBodyPart part2 = this.createTemplate("text/xml", "binary");
        this.multipartMixedTest(part1, part2);
    }

    public void testMultipartBinaryText() throws Exception {
        MimeBodyPart part1 = this.createTemplate("text/xml", "binary");
        MimeBodyPart part2 = this.createTemplate("text/html", "7bit");
        this.multipartMixedTest(part1, part2);
    }

    public void testMultipartBinaryBinary() throws Exception {
        MimeBodyPart part1 = this.createTemplate("text/xml", "binary");
        MimeBodyPart part2 = this.createTemplate("text/html", "binary");
        this.multipartMixedTest(part1, part2);
    }

    public void testSHA1WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA1", SMIMESignedGenerator.DIGEST_SHA1);
    }

    public void testSHA224WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA224", SMIMESignedGenerator.DIGEST_SHA224);
    }

    public void testSHA256WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA256", SMIMESignedGenerator.DIGEST_SHA256);
    }

    public void testSHA384WithRSAPSS() throws Exception {
        this.rsaPSSTest("SHA384", SMIMESignedGenerator.DIGEST_SHA384);
    }

    public void multipartMixedTest(MimeBodyPart part1, MimeBodyPart part2) throws Exception {
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)part1);
        mp.addBodyPart((BodyPart)part2);
        MimeBodyPart m = new MimeBodyPart();
        m.setContent((Multipart)mp);
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", m, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        AttributeTable attr = ((SignerInformation)s.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute a = attr.get(CMSAttributes.messageDigest);
        byte[] contentDigest = ASN1OctetString.getInstance((Object)a.getAttrValues().getObjectAt(0)).getOctets();
        mp = (MimeMultipart)m.getContent();
        ContentType contentType = new ContentType(mp.getContentType());
        String boundary = "--" + contentType.getParameter("boundary");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        LineOutputStream lOut = new LineOutputStream(bOut);
        Enumeration headers = m.getAllHeaderLines();
        while (headers.hasMoreElements()) {
            lOut.writeln((String)headers.nextElement());
        }
        lOut.writeln();
        lOut.writeln(boundary);
        this.writePart(mp.getBodyPart(0), bOut);
        lOut.writeln();
        lOut.writeln(boundary);
        this.writePart(mp.getBodyPart(1), bOut);
        lOut.writeln();
        lOut.writeln(boundary + "--");
        MessageDigest dig = MessageDigest.getInstance("SHA1", BC);
        Assert.assertTrue((boolean)Arrays.equals(contentDigest, dig.digest(bOut.toByteArray())));
    }

    private void writePart(BodyPart part, ByteArrayOutputStream bOut) throws MessagingException, IOException {
        if (part.getHeader("Content-Transfer-Encoding")[0].equals("binary")) {
            part.writeTo((OutputStream)bOut);
        } else {
            part.writeTo((OutputStream)new CRLFOutputStream((OutputStream)bOut));
        }
    }

    public void testSHA1WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA1WithRSAAddSigners() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates((Store)certs);
        SMIMESigned newS = new SMIMESigned(gen.generate(msg));
        this.verifyMessageBytes(msg, newS.getContent());
        this.verifySigners(newS.getCertificates(), newS.getSignerInfos());
    }

    public void testMD5WithRSAAddSignersSHA1() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", msg, SMIMESignedGenerator.STANDARD_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha-1", (String)this.getMicAlg(smm));
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("MD5withRSA", _signKP.getPrivate(), _signCert));
        gen.addSigners(s.getSignerInfos());
        gen.addCertificates((Store)certs);
        smm = gen.generate(msg);
        SMIMESigned newS = new SMIMESigned(gen.generate(msg));
        this.verifyMessageBytes(msg, newS.getContent());
        this.verifySigners(newS.getCertificates(), newS.getSignerInfos());
        Assert.assertEquals((String)"\"md5,sha-1\"", (String)this.getMicAlg(smm));
    }

    public void testSHA1WithRSACanonicalization() throws Exception {
        Date testTime = new Date();
        MimeMultipart smm = this.generateMultiPartRsa("SHA1withRSA", msg, testTime, SMIMESignedGenerator.RFC3851_MICALGS);
        byte[] sig1 = this.getEncodedStream(smm);
        smm = this.generateMultiPartRsa("SHA1withRSA", msgR, testTime, SMIMESignedGenerator.RFC3851_MICALGS);
        byte[] sig2 = this.getEncodedStream(smm);
        Assert.assertTrue((boolean)Arrays.equals(sig1, sig2));
        smm = this.generateMultiPartRsa("SHA1withRSA", msgRN, testTime, SMIMESignedGenerator.RFC3851_MICALGS);
        byte[] sig3 = this.getEncodedStream(smm);
        Assert.assertTrue((boolean)Arrays.equals(sig1, sig3));
    }

    private byte[] getEncodedStream(MimeMultipart smm) throws IOException, MessagingException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        smm.getBodyPart(1).writeTo((OutputStream)bOut);
        return bOut.toByteArray();
    }

    public void testSHA1WithRSAEncapsulated() throws Exception {
        MimeBodyPart res = this.generateEncapsulatedRsa("SHA1withRSA", msg);
        SMIMESigned s = new SMIMESigned((Part)res);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA1WithRSAEncapsulatedParser() throws Exception {
        MimeBodyPart res = this.generateEncapsulatedRsa("SHA1withRSA", msg);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (Part)res);
        FileBackedMimeBodyPart content = (FileBackedMimeBodyPart)s.getContent();
        this.verifyMessageBytes(msg, (MimeBodyPart)content);
        content.dispose();
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        s.close();
    }

    public void testSHA1WithRSAEncapsulatedParserAndFile() throws Exception {
        File tmp = File.createTempFile("bcTest", ".mime");
        MimeBodyPart res = this.generateEncapsulatedRsa("SHA1withRSA", msg);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (Part)res, tmp);
        FileBackedMimeBodyPart content = (FileBackedMimeBodyPart)s.getContent();
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        Assert.assertTrue((boolean)tmp.exists());
        s.close();
        content.dispose();
        Assert.assertFalse((boolean)tmp.exists());
    }

    public void testMD5WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("MD5withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"md5", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)PKCSObjectIdentifiers.md5.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA224WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA224withRSA", msg, SMIMESignedGenerator.STANDARD_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha-224", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha224.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA224WithRSARfc3851() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA224withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha224", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha224.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA256WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA256withRSA", msg, SMIMESignedGenerator.STANDARD_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha-256", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha256.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA256WithRSARfc3851() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA256withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha256", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha256.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA384WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA384withRSA", msg, SMIMESignedGenerator.STANDARD_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha-384", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha384.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA384WithRSARfc3851() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA384withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha384", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha384.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA512WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA512withRSA", msg, SMIMESignedGenerator.STANDARD_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha-512", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha512.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA512WithRSARfc3851() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA512withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"sha512", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha512.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testRIPEMD160WithRSA() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("RIPEMD160withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"unknown", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)TeleTrusTObjectIdentifiers.ripemd160.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testGOST3411WithGOST3410() throws Exception {
        MimeMultipart smm = this.generateMultiPartGost(msg);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"gostr3411-94", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)CryptoProObjectIdentifiers.gostR3411.getId());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testGOST3411WithECGOST3410() throws Exception {
        MimeMultipart smm = this.generateMultiPartECGost(msg);
        SMIMESigned s = new SMIMESigned(smm);
        Assert.assertEquals((String)"gostr3411-94", (String)this.getMicAlg(smm));
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)CryptoProObjectIdentifiers.gostR3411.getId());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA224WithRSAParser() throws Exception {
        MimeMultipart smm = this.generateMultiPartRsa("SHA224withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), smm);
        Store certs = s.getCertificates();
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha224.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(certs, s.getSignerInfos());
    }

    public void testSHA224WithRSAParserEncryptedWithDES() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs))).build("SHA224withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smm = gen.generate(msg);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), smm);
        certs = s.getCertificates();
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)NISTObjectIdentifiers.id_sha224.toString());
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners((Store)certs, s.getSignerInfos());
    }

    public void testSHA1withDSA() throws Exception {
        this.dsaSignKP = CMSTestUtil.makeDsaKeyPair();
        this.dsaSignCert = CMSTestUtil.makeCertificate(this.dsaSignKP, _origDN, this.dsaSignKP, _origDN);
        this.dsaOrigKP = CMSTestUtil.makeDsaKeyPair();
        this.dsaOrigCert = CMSTestUtil.makeCertificate(this.dsaOrigKP, _signDN, this.dsaSignKP, _origDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.dsaOrigCert);
        certList.add(this.dsaSignCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("SHA1withDSA", this.dsaOrigKP.getPrivate(), this.dsaOrigCert));
        gen.addCertificates((Store)certs);
        MimeMultipart smm = gen.generate(msg);
        SMIMESigned s = new SMIMESigned(smm);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA256WithRSABinary() throws Exception {
        MimeBodyPart msg = this.generateBinaryPart();
        MimeMultipart smm = this.generateMultiPartRsa("SHA256withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESigned s = new SMIMESigned(smm);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testSHA256WithRSABinaryWithParser() throws Exception {
        MimeBodyPart msg = this.generateBinaryPart();
        MimeMultipart smm = this.generateMultiPartRsa("SHA256withRSA", msg, SMIMESignedGenerator.RFC3851_MICALGS);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), smm);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testWithAttributeCertificate() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs))).build("SHA256withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        X509AttributeCertificateHolder attrCert = CMSTestUtil.getAttributeCertificate();
        ArrayList<X509AttributeCertificateHolder> attrCertList = new ArrayList<X509AttributeCertificateHolder>();
        attrCertList.add(attrCert);
        CollectionStore store = new CollectionStore(attrCertList);
        gen.addAttributeCertificates((Store)store);
        SMIMESigned s = new SMIMESigned((Part)gen.generateEncapsulated(msg));
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        Store attrCerts = s.getAttributeCertificates();
        Assert.assertTrue((boolean)attrCerts.getMatches(null).contains(attrCert));
    }

    private void rsaPSSTest(String digest, String digestOID) throws Exception {
        MimeMultipart smm = this.generateMultiPartRsaPSS(digest, msg, null);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), smm);
        Store certs = s.getCertificates();
        Assert.assertEquals((String)this.getDigestOid(s.getSignerInfos()), (String)digestOID);
        this.verifyMessageBytes(msg, s.getContent());
        this.verifySigners(certs, s.getSignerInfos());
    }

    private MimeBodyPart generateBinaryPart() throws MessagingException {
        byte[] content = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 10, 11, 12, 13, 14, 10, 10, 15, 16};
        InternetHeaders ih = new InternetHeaders();
        ih.setHeader("Content-Transfer-Encoding", "binary");
        return new MimeBodyPart(ih, content);
    }

    private MimeMultipart generateMultiPartRsa(String algorithm, MimeBodyPart msg, Date signingTime, Map micalgs) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        if (signingTime != null) {
            signedAttrs.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signingTime))));
        }
        SMIMESignedGenerator gen = new SMIMESignedGenerator(micalgs);
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs))).build(algorithm, _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        return gen.generate(msg);
    }

    private MimeMultipart generateMultiPartRsaPSS(String digest, MimeBodyPart msg, Date signingTime) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        if (signingTime != null) {
            signedAttrs.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(signingTime))));
        }
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build(digest + "withRSAandMGF1", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        return gen.generate(msg);
    }

    private MimeMultipart generateMultiPartGost(MimeBodyPart msg) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_signGostCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("GOST3411withGOST3410", _signGostKP.getPrivate(), _signGostCert));
        gen.addCertificates((Store)certs);
        return gen.generate(msg);
    }

    private MimeMultipart generateMultiPartECGost(MimeBodyPart msg) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_signEcGostCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).build("GOST3411withECGOST3410", _signEcGostKP.getPrivate(), _signEcGostCert));
        gen.addCertificates((Store)certs);
        return gen.generate(msg);
    }

    private MimeMultipart generateMultiPartRsa(String algorithm, MimeBodyPart msg, Map micalgs) throws Exception {
        return this.generateMultiPartRsa(algorithm, msg, null, micalgs);
    }

    private MimeBodyPart generateEncapsulatedRsa(String sigAlg, MimeBodyPart msg) throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build(sigAlg, _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        return gen.generateEncapsulated(msg);
    }

    public void testCertificateManagement() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addCertificates((Store)certs);
        MimeBodyPart smm = gen.generateCertificateManagement();
        SMIMESigned s = new SMIMESigned((Part)smm);
        certs = s.getCertificates();
        Assert.assertEquals((int)2, (int)certs.getMatches(null).size());
    }

    public void testMimeMultipart() throws Exception {
        MimeBodyPart m = this.createMultipartMessage();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator("binary");
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart mm = gen.generate(m);
        SMIMESigned s = new SMIMESigned(mm);
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        byte[] contentDigest = (byte[])gen.getGeneratedDigests().get(SMIMESignedGenerator.DIGEST_SHA1);
        AttributeTable table = ((SignerInformation)s.getSignerInfos().getSigners().iterator().next()).getSignedAttributes();
        Attribute hash = table.get(CMSAttributes.messageDigest);
        Assert.assertTrue((boolean)MessageDigest.isEqual(contentDigest, ((ASN1OctetString)hash.getAttrValues().getObjectAt(0)).getOctets()));
    }

    public void testMimeMultipartBinaryReader() throws Exception {
        MimeBodyPart m = this.createMultipartMessage();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator("binary");
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart mm = gen.generate(m);
        SMIMESigned s = new SMIMESigned(mm, "binary");
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testMimeMultipartBinaryParser() throws Exception {
        MimeBodyPart m = this.createMultipartMessage();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator("binary");
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart mm = gen.generate(m);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), mm, "binary");
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testMimeMultipartBinaryParserGetMimeContent() throws Exception {
        MimeBodyPart m = this.createMultipartMessage();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator("binary");
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart mm = gen.generate(m);
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), mm, "binary");
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        MimeMessage bp = s.getContentAsMimeMessage(Session.getDefaultInstance((Properties)new Properties()));
    }

    private MimeBodyPart createMultipartMessage() throws MessagingException {
        MimeBodyPart msg1 = new MimeBodyPart();
        msg1.setText("Hello part 1!\n");
        MimeBodyPart msg2 = new MimeBodyPart();
        msg2.setText("Hello part 2!\n");
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)msg1);
        mp.addBodyPart((BodyPart)msg2);
        MimeBodyPart m = new MimeBodyPart();
        m.setContent((Multipart)mp);
        return m;
    }

    public void testQuotable() throws Exception {
        MimeMessage message = this.loadMessage("quotable.message");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testQuotableParser() throws Exception {
        MimeMessage message = this.loadMessage("quotable.message");
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testEmbeddedMulti() throws Exception {
        MimeMessage message = this.loadMessage("embeddedmulti.message");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testEmbeddedMultiParser() throws Exception {
        MimeMessage message = this.loadMessage("embeddedmulti.message");
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testPSSVariantSalt() throws Exception {
        boolean skip = false;
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("java.security.spec.PSSParameterSpec");
        }
        catch (Exception e) {
            skip = true;
        }
        if (!skip) {
            MimeMessage message = this.loadMessage("openssl-signed-sha256-non-default-salt-length.eml");
            SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
            this.verifySigners(s.getCertificates(), s.getSignerInfos());
        }
    }

    public void testMultiAlternative() throws Exception {
        MimeMessage message = this.loadMessage("multi-alternative.eml");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testExtraNlInPostamble() throws Exception {
        MimeMessage message = this.loadMessage("extra-nl.eml");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testDoubleNlCanonical() throws Exception {
        MimeMessage message = this.loadMessage("3nnn_smime.eml");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        Collection c = s.getSignerInfos().getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = s.getCertificates().getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            Assert.assertFalse((boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(certHolder)));
        }
    }

    public void testSignAttachmentOnly() throws Exception {
        MimeMessage m = this.loadMessage("attachonly.eml");
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(_signCert);
        certList.add(_origCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator("binary");
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider(BC).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", _signKP.getPrivate(), _signCert));
        gen.addCertificates((Store)certs);
        MimeMultipart mm = gen.generate(m);
        SMIMESigned s = new SMIMESigned(mm);
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
        SMIMESignedParser sp = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), mm);
        this.verifySigners(sp.getCertificates(), sp.getSignerInfos());
    }

    public void testMultiAlternativeParser() throws Exception {
        MimeMessage message = this.loadMessage("multi-alternative.eml");
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testBasicAS2() throws Exception {
        MimeMessage message = this.loadMessage("basicAS2.message");
        SMIMESigned s = new SMIMESigned((MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testBasicAS2Parser() throws Exception {
        MimeMessage message = this.loadMessage("basicAS2.message");
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    public void testRawAS2Parser() throws Exception {
        MimeMessage message = this.loadMessage("rawAS2.message");
        SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(BC).build(), (MimeMultipart)message.getContent());
        this.verifySigners(s.getCertificates(), s.getSignerInfos());
    }

    private String getDigestOid(SignerInformationStore s) {
        return ((SignerInformation)s.getSigners().iterator().next()).getDigestAlgOID();
    }

    private void verifySigners(Store certs, SignerInformationStore signers) throws Exception {
        Collection c = signers.getSigners();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection certCollection = certs.getMatches((Selector)signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509CertificateHolder certHolder = (X509CertificateHolder)certIt.next();
            Assert.assertEquals((boolean)true, (boolean)signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(certHolder)));
        }
    }

    private void verifyMessageBytes(MimeBodyPart a, MimeBodyPart b) throws Exception {
        ByteArrayOutputStream bOut1 = new ByteArrayOutputStream();
        a.writeTo((OutputStream)bOut1);
        bOut1.close();
        ByteArrayOutputStream bOut2 = new ByteArrayOutputStream();
        b.writeTo((OutputStream)bOut2);
        bOut2.close();
        Assert.assertEquals((boolean)true, (boolean)Arrays.equals(bOut1.toByteArray(), bOut2.toByteArray()));
    }

    private ASN1EncodableVector generateSignedAttributes() {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        return signedAttrs;
    }

    private MimeMessage loadMessage(String name) throws MessagingException, FileNotFoundException {
        Session session = Session.getDefaultInstance((Properties)System.getProperties(), null);
        return new MimeMessage(session, ((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    private MimeBodyPart createTemplate(String contentType, String contentTransferEncoding) throws UnsupportedEncodingException, MessagingException {
        byte[] content = "<?xml version=\"1.0\"?>\n \n   \n</CONTENT_FRAME>\n</INVOICE_CENTER>\n".getBytes("US-ASCII");
        InternetHeaders ih = new InternetHeaders();
        ih.setHeader("Content-Type", contentType);
        ih.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
        return new MimeBodyPart(ih, content);
    }

    private String getMicAlg(MimeMultipart mm) {
        String contentType = mm.getContentType();
        String micAlg = contentType.substring(contentType.indexOf("micalg=") + 7);
        return micAlg.substring(0, micAlg.indexOf(59));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            if (Security.getProvider(BC) == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            msg = SMIMETestUtil.makeMimeBodyPart("Hello world!\n");
            msgR = SMIMETestUtil.makeMimeBodyPart("Hello world!\r");
            msgRN = SMIMETestUtil.makeMimeBodyPart("Hello world!\r\n");
            _origDN = "O=Bouncy Castle, C=AU";
            _origKP = CMSTestUtil.makeKeyPair();
            _origCert = CMSTestUtil.makeCertificate(_origKP, _origDN, _origKP, _origDN);
            _signDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            _signKP = CMSTestUtil.makeKeyPair();
            _signCert = CMSTestUtil.makeCertificate(_signKP, _signDN, _origKP, _origDN);
            _signGostKP = CMSTestUtil.makeGostKeyPair();
            _signGostCert = CMSTestUtil.makeCertificate(_signGostKP, _signDN, _origKP, _origDN);
            _signEcDsaKP = CMSTestUtil.makeEcDsaKeyPair();
            _signEcDsaCert = CMSTestUtil.makeCertificate(_signEcDsaKP, _signDN, _origKP, _origDN);
            _signEcGostKP = CMSTestUtil.makeEcGostKeyPair();
            _signEcGostCert = CMSTestUtil.makeCertificate(_signEcGostKP, _signDN, _origKP, _origDN);
        }
        catch (Exception e) {
            throw new RuntimeException("problem setting up signed test class: " + e);
        }
    }

    private static class LineOutputStream
    extends FilterOutputStream {
        private static byte[] newline = new byte[2];

        public LineOutputStream(OutputStream outputstream) {
            super(outputstream);
        }

        public void writeln(String s) throws MessagingException {
            try {
                byte[] abyte0 = LineOutputStream.getBytes(s);
                this.out.write(abyte0);
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        public void writeln() throws MessagingException {
            try {
                this.out.write(newline);
            }
            catch (Exception exception) {
                throw new MessagingException("IOException", exception);
            }
        }

        private static byte[] getBytes(String s) {
            char[] ac = s.toCharArray();
            int i = ac.length;
            byte[] abyte0 = new byte[i];
            int j = 0;
            while (j < i) {
                abyte0[j] = (byte)ac[j++];
            }
            return abyte0;
        }

        static {
            LineOutputStream.newline[0] = 13;
            LineOutputStream.newline[1] = 10;
        }
    }
}

