/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestResult;

public class ZucTest
extends SimpleTest {
    private static final String KEY128_1 = "00000000000000000000000000000000";
    private static final String KEY128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String KEY256_1 = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String KEY256_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV128_1 = "00000000000000000000000000000000";
    private static final String IV128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV200_1 = "00000000000000000000000000000000000000000000000000";
    private static final String IV200_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F";
    private final TestCase ZUC128_TEST1 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "27bede74018082da87d4e5b69f18bf6632070e0f39b7b692b4673edc3184a48e27636f4414510d62cc15cfe194ec4f6d4b8c8fcc630648badf41b6f9d16a36ca");
    private final TestCase ZUC128_TEST2 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "0657cfa07096398b734b6cb4883eedf4257a76eb97595208d884adcdb1cbffb8e0f9d15846a0eed015328503351138f740d079af17296c232c4f022d6e4acac6");
    private final TestCase ZUC256_TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "58d03ad62e032ce2dafc683a39bdcb0352a2bc67f1b7de74163ce3a101ef55589639d75b95fa681b7f090df756391ccc903b7612744d544c17bc3fad8b163b08");
    private final TestCase ZUC256_TEST2 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "3356cbaed1a1c18b6baa4ffe343f777c9e15128f251ab65b949f7b26ef7157f296dd2fa9df95e3ee7a5be02ec32ba585505af316c2f9ded27cdbd935e441ce11");
    private final TestCase MAC128_TEST1 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "508dd5ff");
    private final TestCase MAC128_TEST2 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "fbed4c12");
    private final TestCase MAC256_TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "d85e54bbcb9600967084c952a1654b26");
    private final TestCase MAC256_TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "df1e8307b31cc62beca1ac6f8190c22f");
    private final TestCase MAC256_64_TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "673e54990034d38c");
    private final TestCase MAC256_64_TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "130dc225e72240cc");
    private final TestCase MAC256_32_TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "9b972a74");
    private final TestCase MAC256_32_TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "8754f5cf");

    public String getName() {
        return "Zuc";
    }

    void testCipher(Cipher pCipher, TestCase pTestCase) throws Exception {
        byte[] myExpected = Hex.decode((String)pTestCase.theExpected);
        byte[] myOutput = new byte[myExpected.length];
        byte[] myData = pTestCase.thePlainText != null ? Hex.decode((String)pTestCase.thePlainText) : new byte[myExpected.length];
        SecretKeySpec myKey = new SecretKeySpec(Hex.decode((String)pTestCase.theKey), pCipher.getAlgorithm());
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        pCipher.init(1, (Key)myKey, new IvParameterSpec(myIV));
        pCipher.doFinal(myData, 0, myData.length, myOutput, 0);
        this.isTrue("Encryption mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
        AlgorithmParameters algParams = AlgorithmParameters.getInstance(pCipher.getAlgorithm(), "BC");
        algParams.init(new IvParameterSpec(myIV));
        pCipher.init(2, (Key)myKey, algParams);
        pCipher.doFinal(myData, 0, myData.length, myOutput, 0);
    }

    void testMac(Mac pMac, boolean pOnes, TestCase pTestCase) throws Exception {
        byte[] myOutput;
        byte[] myExpected = Hex.decode((String)pTestCase.theExpected);
        this.isTrue("Mac length mismatch", myExpected.length == (myOutput = new byte[pMac.getMacLength()]).length);
        byte[] myData = new byte[(pOnes ? 4000 : 400) / 8];
        Arrays.fill((byte[])myData, (byte)(pOnes ? (byte)17 : 0));
        SecretKeySpec myKey = new SecretKeySpec(Hex.decode((String)pTestCase.theKey), pMac.getAlgorithm());
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        pMac.init(myKey, new IvParameterSpec(myIV));
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("DoFinal Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
        pMac.update(myData, 0, myData.length);
        pMac.reset();
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("Reset Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
    }

    private void simpleTest(Cipher zuc) throws Exception {
        KeyGenerator kGen = KeyGenerator.getInstance(zuc.getAlgorithm(), "BC");
        byte[] msg = Strings.toByteArray((String)"Hello, world!");
        SecretKey k = kGen.generateKey();
        zuc.init(1, k);
        byte[] enc = zuc.doFinal(msg);
        byte[] iv = zuc.getIV();
        AlgorithmParameters algParam = zuc.getParameters();
        zuc.init(2, (Key)k, new IvParameterSpec(iv));
        byte[] dec = zuc.doFinal(enc);
        this.areEqual(msg, dec);
        zuc.init(2, (Key)k, algParam);
        dec = zuc.doFinal(enc);
        this.areEqual(msg, dec);
    }

    public void performTest() throws Exception {
        Cipher zuc128 = Cipher.getInstance("Zuc-128", "BC");
        this.testCipher(zuc128, this.ZUC128_TEST1);
        this.testCipher(zuc128, this.ZUC128_TEST2);
        this.simpleTest(zuc128);
        Cipher zuc256 = Cipher.getInstance("Zuc-256", "BC");
        this.testCipher(zuc256, this.ZUC256_TEST1);
        this.testCipher(zuc256, this.ZUC256_TEST2);
        this.simpleTest(zuc256);
        Mac mac128 = Mac.getInstance("Zuc-128", "BC");
        mac128.reset();
        this.testMac(mac128, false, this.MAC128_TEST1);
        this.testMac(mac128, true, this.MAC128_TEST2);
        Mac mac256 = Mac.getInstance("Zuc-256", "BC");
        mac256.reset();
        this.testMac(mac256, false, this.MAC256_TEST1);
        this.testMac(mac256, true, this.MAC256_TEST2);
        Mac mac256_128 = Mac.getInstance("Zuc-256-128", "BC");
        this.testMac(mac256_128, false, this.MAC256_TEST1);
        this.testMac(mac256_128, true, this.MAC256_TEST2);
        Mac mac256_64 = Mac.getInstance("Zuc-256-64", "BC");
        this.testMac(mac256_64, false, this.MAC256_64_TEST1);
        this.testMac(mac256_64, true, this.MAC256_64_TEST2);
        Mac mac256_32 = Mac.getInstance("Zuc-256-32", "BC");
        this.testMac(mac256_32, false, this.MAC256_32_TEST1);
        this.testMac(mac256_32, true, this.MAC256_32_TEST2);
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ZucTest test = new ZucTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
        if (result.getException() != null) {
            result.getException().printStackTrace();
        }
    }

    private static class TestCase {
        private final String theKey;
        private final String theIV;
        private final String thePlainText;
        private final String theExpected;

        TestCase(String pKey, String pIV, String pExpected) {
            this(pKey, pIV, null, pExpected);
        }

        TestCase(String pKey, String pIV, String pPlain, String pExpected) {
            this.theKey = pKey;
            this.theIV = pIV;
            this.thePlainText = pPlain;
            this.theExpected = pExpected;
        }
    }
}

