/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class XIESTest
extends SimpleTest {
    private static final String[] streamCiphers = new String[]{"XIES", "XIESwithSHA1", "XIESwithSHA256", "XIESwithSHA384", "XIESwithSHA512"};
    private static final String[] aesCiphers = new String[]{"XIESwithAES-CBC", "XIESwithSHA1andAES-CBC", "XIESwithSHA256andAES-CBC", "XIESwithSHA384andAES-CBC", "XIESwithSHA512andAES-CBC"};

    XIESTest() {
    }

    public String getName() {
        return "XIES";
    }

    public void performTest() throws Exception {
        byte[] derivation = Hex.decode((String)"202122232425262728292a2b2c2d2e2f");
        byte[] encoding = Hex.decode((String)"303132333435363738393a3b3c3d3e3f");
        KeyPairGenerator g25519 = KeyPairGenerator.getInstance("X25519", "BC");
        KeyPairGenerator g448 = KeyPairGenerator.getInstance("X448", "BC");
        int i = 0;
        while (i != streamCiphers.length) {
            String cipher = streamCiphers[i];
            IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128);
            this.doTest(cipher + " with X25519", g25519, cipher, params);
            params = new IESParameterSpec(derivation, encoding, 128);
            this.doTest(cipher + " with X448", g448, cipher, params);
            ++i;
        }
        int i2 = 0;
        while (i2 != aesCiphers.length) {
            block10: {
                String cipher = aesCiphers[i2];
                IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode((String)"000102030405060708090a0b0c0d0e0f"));
                this.doTest(cipher + " with X25519", g25519, cipher, params);
                params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode((String)"000102030405060708090a0b0c0d0e0f"));
                this.doTest(cipher + " with X448", g448, cipher, params);
                try {
                    params = new IESParameterSpec(derivation, encoding, 128, 128, new byte[10]);
                    this.doTest(cipher + " with X25519", g25519, cipher, params);
                    this.fail("AES no exception!");
                }
                catch (InvalidAlgorithmParameterException e) {
                    if (e.getMessage().equals("NONCE in IES Parameters needs to be 16 bytes long")) break block10;
                    this.fail("AES wrong message!");
                }
            }
            KeyPair keyPair = g25519.generateKeyPair();
            PublicKey pub = keyPair.getPublic();
            PrivateKey priv = keyPair.getPrivate();
            Cipher c = Cipher.getInstance("XIESwithAES-CBC", "BC");
            try {
                c.init(1, (Key)pub, (AlgorithmParameterSpec)new IESParameterSpec(derivation, encoding, 128, 128, null));
                this.fail("no exception");
            }
            catch (InvalidAlgorithmParameterException e) {
                this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
            }
            try {
                c.init(2, priv);
                this.fail("no exception");
            }
            catch (IllegalArgumentException e) {
                this.isTrue("message ", "cannot handle supplied parameter spec: must be passed IES parameters".equals(e.getMessage()));
            }
            try {
                c.init(2, (Key)priv, (AlgorithmParameterSpec)new IESParameterSpec(derivation, encoding, 128, 128, null));
                this.fail("no exception");
            }
            catch (InvalidAlgorithmParameterException e) {
                this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
            }
            ++i2;
        }
        this.sealedObjectTest();
    }

    private void sealedObjectTest() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("X25519", "BC");
        KeyPair keyPair = kpg.generateKeyPair();
        byte[] derivation = Hex.decode((String)"202122232425262728292a2b2c2d2e2f");
        byte[] encoding = Hex.decode((String)"303132333435363738393a3b3c3d3e3f");
        IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128);
        Cipher cipher = Cipher.getInstance("XIES", "BC");
        cipher.init(1, (Key)keyPair.getPublic(), (AlgorithmParameterSpec)params);
        String toEncrypt = "Hello";
        cipher.doFinal(toEncrypt.getBytes());
        SealedObject sealedObject = new SealedObject((Serializable)((Object)toEncrypt), cipher);
        cipher.init(2, (Key)keyPair.getPrivate(), (AlgorithmParameterSpec)params);
        String result = (String)sealedObject.getObject(cipher);
        this.isTrue("result wrong", result.equals(toEncrypt));
        result = (String)sealedObject.getObject(keyPair.getPrivate());
        this.isTrue("result wrong", result.equals(toEncrypt));
    }

    public void doTest(String testname, KeyPairGenerator g, String cipher, IESParameterSpec p) throws Exception {
        byte[] message = Hex.decode((String)"0102030405060708090a0b0c0d0e0f10111213141516");
        KeyPair KeyPair2 = g.generateKeyPair();
        PublicKey Pub = KeyPair2.getPublic();
        PrivateKey Priv = KeyPair2.getPrivate();
        Cipher c1 = Cipher.getInstance(cipher);
        Cipher c2 = Cipher.getInstance(cipher);
        c1.init(1, (Key)Pub, (AlgorithmParameterSpec)p, new SecureRandom());
        c2.init(2, (Key)Priv, (AlgorithmParameterSpec)p);
        byte[] out1 = c1.doFinal(message, 0, message.length);
        byte[] out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode false.");
        }
        int offset = out1.length - (message.length + 8);
        byte[] tmp = new byte[out1.length];
        int i = offset;
        while (i != out1.length) {
            System.arraycopy(out1, 0, tmp, 0, tmp.length);
            tmp[i] = ~tmp[i];
            try {
                c2.doFinal(tmp, 0, tmp.length);
                this.fail("decrypted corrupted data");
            }
            catch (BadPaddingException e) {
                this.isTrue("wrong message: " + e.getMessage(), "unable to process block".equals(e.getMessage()));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new XIESTest());
    }
}

