/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.internal.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.jce.provider.test.ContentInfo;
import org.bouncycastle.jce.provider.test.PEMData;
import org.bouncycastle.jce.provider.test.SignedData;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CertificatePair;
import org.bouncycastle.x509.X509StreamParser;

public class X509StreamParserTest
extends SimpleTest {
    byte[] attrCert = Base64.decode((String)"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");

    public void performTest() throws Exception {
        X509StreamParser parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init((InputStream)new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate rootCert = (X509Certificate)parser.read();
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init((InputStream)new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL rootCrl = (X509CRL)parser.read();
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init((InputStream)new ByteArrayInputStream(this.attrCert));
        X509AttributeCertificate aCert = (X509AttributeCertificate)parser.read();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bOut.write(CertPathTest.rootCertBin);
        bOut.write(CertPathTest.interCertBin);
        bOut.write(CertPathTest.finalCertBin);
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(bOut.toByteArray());
        Collection res = parser.readAll();
        if (res.size() != 3) {
            this.fail("wrong number of certificates found");
        }
        bOut = new ByteArrayOutputStream();
        bOut.write(CertPathTest.rootCrlBin);
        bOut.write(CertPathTest.interCrlBin);
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(bOut.toByteArray());
        res = parser.readAll();
        if (res.size() != 2) {
            this.fail("wrong number of CRLs found");
        }
        bOut = new ByteArrayOutputStream();
        bOut.write(this.attrCert);
        bOut.write(this.attrCert);
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(bOut.toByteArray());
        res = parser.readAll();
        if (res.size() != 2) {
            this.fail("wrong number of Attribute Certificates found");
        }
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.CERTIFICATE_1));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Certificates found");
        }
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.CERTIFICATE_2));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Certificates found");
        }
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.CRL_1));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of CRLs found");
        }
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.CRL_2));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of CRLs found");
        }
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.ATTRIBUTE_CERTIFICATE_1));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Attribute Certificates found");
        }
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(Strings.toByteArray((String)PEMData.ATTRIBUTE_CERTIFICATE_2));
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Attribute Certificates found");
        }
        ASN1EncodableVector certs = new ASN1EncodableVector();
        certs.add((ASN1Encodable)new ASN1InputStream(CertPathTest.rootCertBin).readObject());
        certs.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)new ASN1InputStream(this.attrCert).readObject()));
        ASN1EncodableVector crls = new ASN1EncodableVector();
        crls.add((ASN1Encodable)new ASN1InputStream(CertPathTest.rootCrlBin).readObject());
        parser = X509StreamParser.getInstance((String)"CertificatePair", (String)"BC");
        parser.init(new X509CertificatePair(rootCert, rootCert).getEncoded());
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of CertificatePairs found");
        }
        SignedData sigData = new SignedData((ASN1Set)new DERSet(), new ContentInfo(CMSObjectIdentifiers.data, null), (ASN1Set)new DERSet(certs), (ASN1Set)new DERSet(crls), (ASN1Set)new DERSet());
        ContentInfo info = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sigData);
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Certificates found");
        }
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of CRLs found");
        }
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 1) {
            this.fail("wrong number of Attribute Certificates found");
        }
        sigData = new SignedData((ASN1Set)new DERSet(), new ContentInfo(CMSObjectIdentifiers.data, null), (ASN1Set)new DERSet(), (ASN1Set)new DERSet(), (ASN1Set)new DERSet());
        info = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sigData);
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of Certificates found - expected 0");
        }
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of CRLs found - expected 0");
        }
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of Attribute Certificates found - expected 0");
        }
        sigData = new SignedData((ASN1Set)new DERSet(), new ContentInfo(CMSObjectIdentifiers.data, null), null, null, (ASN1Set)new DERSet());
        info = new ContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sigData);
        parser = X509StreamParser.getInstance((String)"Certificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of Certificates found - expected 0");
        }
        parser = X509StreamParser.getInstance((String)"CRL", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of CRLs found - expected 0");
        }
        parser = X509StreamParser.getInstance((String)"AttributeCertificate", (String)"BC");
        parser.init(info.getEncoded());
        res = parser.readAll();
        if (res.size() != 0) {
            this.fail("wrong number of Attribute Certificates found - expected 0");
        }
    }

    public String getName() {
        return "X509StreamParser";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new X509StreamParserTest());
    }
}

