/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SignatureTest
extends SimpleTest {
    private static final byte[] DATA = Hex.decode((String)"00000000deadbeefbeefdeadffffffff00000000");

    private void checkSig(KeyPair kp, String name) throws Exception {
        Signature sig = Signature.getInstance(name, "BC");
        sig.initSign(kp.getPrivate());
        sig.update(DATA);
        byte[] signature1 = sig.sign();
        sig.update(DATA);
        byte[] signature2 = sig.sign();
        sig.initVerify(kp.getPublic());
        sig.update(DATA);
        if (!sig.verify(signature1)) {
            this.fail("did not verify: " + name);
        }
        sig.update(DATA);
        if (!sig.verify(signature1)) {
            this.fail("second verify failed: " + name);
        }
        sig.update(DATA);
        if (!sig.verify(signature2)) {
            this.fail("second verify failed (2): " + name);
        }
    }

    public void performTest() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(2048);
        KeyPair kp = kpGen.generateKeyPair();
        this.checkSig(kp, "SHA1withRSA");
        this.checkSig(kp, "SHA224withRSA");
        this.checkSig(kp, "SHA256withRSA");
        this.checkSig(kp, "SHA384withRSA");
        this.checkSig(kp, "SHA512withRSA");
        this.checkSig(kp, "SHA3-224withRSA");
        this.checkSig(kp, "SHA3-256withRSA");
        this.checkSig(kp, "SHA3-384withRSA");
        this.checkSig(kp, "SHA3-512withRSA");
        this.checkSig(kp, "MD2withRSA");
        this.checkSig(kp, "MD4withRSA");
        this.checkSig(kp, "MD5withRSA");
        this.checkSig(kp, "RIPEMD160withRSA");
        this.checkSig(kp, "RIPEMD128withRSA");
        this.checkSig(kp, "RIPEMD256withRSA");
        this.checkSig(kp, "SHA1withRSAandMGF1");
        this.checkSig(kp, "SHA1withRSAandMGF1");
        this.checkSig(kp, "SHA224withRSAandMGF1");
        this.checkSig(kp, "SHA256withRSAandMGF1");
        this.checkSig(kp, "SHA384withRSAandMGF1");
        this.checkSig(kp, "SHA512withRSAandMGF1");
        this.checkSig(kp, "SHA1withRSAandSHAKE128");
        this.checkSig(kp, "SHA1withRSAandSHAKE128");
        this.checkSig(kp, "SHA224withRSAandSHAKE128");
        this.checkSig(kp, "SHA256withRSAandSHAKE128");
        this.checkSig(kp, "SHA384withRSAandSHAKE128");
        this.checkSig(kp, "SHA512withRSAandSHAKE128");
        this.checkSig(kp, "SHA1withRSAandSHAKE256");
        this.checkSig(kp, "SHA1withRSAandSHAKE256");
        this.checkSig(kp, "SHA224withRSAandSHAKE256");
        this.checkSig(kp, "SHA256withRSAandSHAKE256");
        this.checkSig(kp, "SHA384withRSAandSHAKE256");
        this.checkSig(kp, "SHA512withRSAandSHAKE256");
        this.checkSig(kp, "SHAKE128withRSAPSS");
        this.checkSig(kp, "SHAKE256withRSAPSS");
        this.checkSig(kp, "SHA1withRSA/ISO9796-2");
        this.checkSig(kp, "MD5withRSA/ISO9796-2");
        this.checkSig(kp, "RIPEMD160withRSA/ISO9796-2");
        this.checkSig(kp, "RIPEMD128withRSA/X9.31");
        this.checkSig(kp, "RIPEMD160withRSA/X9.31");
        this.checkSig(kp, "SHA1withRSA/X9.31");
        this.checkSig(kp, "SHA224withRSA/X9.31");
        this.checkSig(kp, "SHA256withRSA/X9.31");
        this.checkSig(kp, "SHA384withRSA/X9.31");
        this.checkSig(kp, "SHA512withRSA/X9.31");
        this.checkSig(kp, "WhirlpoolwithRSA/X9.31");
        kpGen = KeyPairGenerator.getInstance("DSA", "BC");
        kpGen.initialize(2048);
        kp = kpGen.generateKeyPair();
        this.checkSig(kp, "SHA1withDSA");
        this.checkSig(kp, "SHA224withDSA");
        this.checkSig(kp, "SHA256withDSA");
        this.checkSig(kp, "SHA384withDSA");
        this.checkSig(kp, "SHA512withDSA");
        this.checkSig(kp, "NONEwithDSA");
        kpGen = KeyPairGenerator.getInstance("EC", "BC");
        kpGen.initialize(256);
        kp = kpGen.generateKeyPair();
        this.checkSig(kp, "SHA1withECDSA");
        this.checkSig(kp, "SHA224withECDSA");
        this.checkSig(kp, "SHA256withECDSA");
        this.checkSig(kp, "SHA384withECDSA");
        this.checkSig(kp, "SHA512withECDSA");
        this.checkSig(kp, "RIPEMD160withECDSA");
        this.checkSig(kp, "SHAKE128withECDSA");
        this.checkSig(kp, "SHAKE256withECDSA");
        kpGen = KeyPairGenerator.getInstance("EC", "BC");
        kpGen.initialize(521);
        kp = kpGen.generateKeyPair();
        this.checkSig(kp, "SHA1withECNR");
        this.checkSig(kp, "SHA224withECNR");
        this.checkSig(kp, "SHA256withECNR");
        this.checkSig(kp, "SHA384withECNR");
        this.checkSig(kp, "SHA512withECNR");
        kpGen = KeyPairGenerator.getInstance("ECGOST3410", "BC");
        kpGen.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("GostR3410-2001-CryptoPro-A"), new SecureRandom());
        kp = kpGen.generateKeyPair();
        this.checkSig(kp, "GOST3411withECGOST3410");
        kpGen = KeyPairGenerator.getInstance("GOST3410", "BC");
        GOST3410ParameterSpec gost3410P = new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId());
        kpGen.initialize((AlgorithmParameterSpec)gost3410P);
        kp = kpGen.generateKeyPair();
        this.checkSig(kp, "GOST3411withGOST3410");
    }

    public String getName() {
        return "SigNameTest";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new SignatureTest());
    }
}

