/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.test.SimpleTest;

public class OpenSSHSpecTests
extends SimpleTest {
    private static final SecureRandom secureRandom = new SecureRandom();
    static /* synthetic */ Class class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec;
    static /* synthetic */ Class class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec;

    public void testEncodingRSA() throws Exception {
        byte[] rawPub = Base64.decode((String)"AAAAB3NzaC1yc2EAAAADAQABAAAAgQDvh2BophdIp8ojwGZQR0FQ/awowXnV24nAPm+/na8MOUrdySNhOnlek4LAZl82/+Eu2t21XD6hQUiHKAj6XaNFBthTuss7Cz/tA348DLEMHD9wUtT0FXVmsxqN4BfusunbcULxxVWG2z8FvqeaGgc/Unkp9y7/kyf54pPUCBcClw==");
        byte[] rawPriv = new PemReader((Reader)new StringReader("-----BEGIN RSA PRIVATE KEY-----\nMIICXgIBAAKBgQDvh2BophdIp8ojwGZQR0FQ/awowXnV24nAPm+/na8MOUrdySNh\nOnlek4LAZl82/+Eu2t21XD6hQUiHKAj6XaNFBthTuss7Cz/tA348DLEMHD9wUtT0\nFXVmsxqN4BfusunbcULxxVWG2z8FvqeaGgc/Unkp9y7/kyf54pPUCBcClwIDAQAB\nAoGBAOMXYEoXHgAeREE9CkOWKtDUkEJbnF0rNSB0kZIDt5BJSTeYmNh3jdYi2FX9\nOMx2MFIx4v0tJZvQvyiUxl5IJJ9ZJsYUWF+6VbcTVwYYfdVzZzP2TNyGmF9/ADZW\nwBehqP04uRlYjt94kqb4HoOKF3gJ3LC4uW9xcEltTBeHWCfhAkEA/2biF5St9/Ya\n540E4zu/FKPsxLSaT8LWCo9+X7IqIzlBQCB4GjM+nZeTm7eZOkfAFZoxwfiNde/9\nqleXXf6B2QJBAPAW+jDBC3QF4/g8n9cDxm/A3ICmcOFSychLSrydk9ZyRPbTRyQC\nYlC2mf/pCrO/yO7h189BXyQ3PXOEhnujce8CQQD7gDy0K90EiH0F94AQpA0OLj5B\nlfc/BAXycEtpwPBtrzvqAg9C/aNzXIgmly10jqNAoo7NDA2BTcrlq0uLa8xBAkBl\n7Hs+I1XnZXDIO4Rn1VRysN9rRj15ipnbDAuoUwUl7tDUMBFteg2e0kZCW/6NHIgC\n0aG6fLgVOdY+qi4lYtfFAkEAqqiBgEgSrDmnJLTm6j/Pv1mBA6b9bJbjOqomrDtr\nAWTXe+/kSCv/jYYdpNA/tDgAwEmtkWWEie6+SwJB5cXXqg==\n-----END RSA PRIVATE KEY-----\n")).readPemObject().getContent();
        OpenSSHPublicKeySpec pubSpec = new OpenSSHPublicKeySpec(rawPub);
        OpenSSHPrivateKeySpec privSpec = new OpenSSHPrivateKeySpec(rawPriv);
        this.isEquals("Pk type", pubSpec.getType(), "ssh-rsa");
        this.isEquals("Spec Type", privSpec.getFormat(), "ASN.1");
        byte[] originalMessage = new byte[10];
        secureRandom.nextBytes(originalMessage);
        originalMessage[0] = (byte)(originalMessage[0] | 1);
        KeyFactory kpf = KeyFactory.getInstance("RSA", "BC");
        PublicKey pk = kpf.generatePublic((KeySpec)pubSpec);
        PrivateKey prk = kpf.generatePrivate((KeySpec)privSpec);
        OpenSSHPublicKeySpec rcPublicKeySpec = (OpenSSHPublicKeySpec)kpf.getKeySpec(pk, class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec);
        OpenSSHPrivateKeySpec rcPrivateSpec = (OpenSSHPrivateKeySpec)kpf.getKeySpec(prk, class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec);
        this.isEquals("Pk type", rcPublicKeySpec.getType(), "ssh-rsa");
        this.isEquals("Spec Type", rcPrivateSpec.getFormat(), "ASN.1");
        this.isTrue("RSAPublic key not same", Arrays.areEqual((byte[])rawPub, (byte[])rcPublicKeySpec.getEncoded()));
        this.isTrue("RSAPrivate key not same", Arrays.areEqual((byte[])rawPriv, (byte[])rcPrivateSpec.getEncoded()));
        String rsa2048Key = "-----BEGIN OPENSSH PRIVATE KEY-----\nb3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAABFwAAAAdzc2gtcn\nNhAAAAAwEAAQAAAQEArxWa1zW+Uf0lUrYoL1yqgTYUT1TfUkfojrhguPB1s/1AEMj8sueu\nYDtLozZW/GB+KwO+nzC48CmqsCbCEOqalmdRIQCCQIBs776c0KLnhqzHCmj0Q+6gM0KvUG\nz8elzJ8LZuTj5xGRDvFxli4yl2M119X7K2JMci18N95rszioxDECSWg2Arvd25kMKBK5MA\nqJjosvxr46soRmxiAHeGzinoLXgpLh9axwySpJ0WVGPl079ZtaYs/XpSoh9HXqCgwnsVy9\nJscWbmtaAktjMw2zTfOvmFs9PVJXtXQRzP4nvtT6myK/7v8tPeg8yLnAot9erklHcUOEyb\n1LsOrk68+QAAA8j/Xs/E/17PxAAAAAdzc2gtcnNhAAABAQCvFZrXNb5R/SVStigvXKqBNh\nRPVN9SR+iOuGC48HWz/UAQyPyy565gO0ujNlb8YH4rA76fMLjwKaqwJsIQ6pqWZ1EhAIJA\ngGzvvpzQoueGrMcKaPRD7qAzQq9QbPx6XMnwtm5OPnEZEO8XGWLjKXYzXX1fsrYkxyLXw3\n3muzOKjEMQJJaDYCu93bmQwoErkwComOiy/GvjqyhGbGIAd4bOKegteCkuH1rHDJKknRZU\nY+XTv1m1piz9elKiH0deoKDCexXL0mxxZua1oCS2MzDbNN86+YWz09Ule1dBHM/ie+1Pqb\nIr/u/y096DzIucCi316uSUdxQ4TJvUuw6uTrz5AAAAAwEAAQAAAQBPpNBO3Y+51CHKQjp9\ncPXO2T7b54u+7h8H7S9ycU/ZlHY0LHlnGKTl+ZMqp2liXLKH9qgb2hoGha2ze64D6/RuPo\nlVLdoSZVkopdjHv5L6XFYekierTz1olAkT2L/xGYxzB0meJiFkeaOJKm8lTpMKQpjpk23v\nxPZAmBkJgFatyueHaVWGYp0KzUDpdMcS97R6CWCGrYlAUP3F1meC9+Sb3d94qxeqLZsgEn\nPYJs1Q7fyL4jYBYm9/pA9O5RLKMQwqY7Qln7l2XTyhavZCIxTmAa6lEf32yB3+EoQR+YEz\neCXXSClbMcnnx83jYyV5uNxN27VJAlgeN7J2ZyJTLlKRAAAAgAUnKuxYaYezMWyBShwR4N\neVAW8vT3CBxsMR/v3u6XmLTzjq4r0gKCxofnnj972uK0LvyTZ21/00MSl0KaAjJySl2hLj\nBNQA3TcDXnLEc5KcsKZdDhuWkHGmaoajDp/okfQd6CxuKaBKG/OFdbYqVgOOVeACUUWxT4\nNN4e3CxTWQAAAAgQDV3vzDCQanGAXMKZSxfHUU63Tmh+2NcB1I6Sb0/CwpBgLH1y0CTB9r\nc8TLSs6HoHx1lfzOp6Yj7BQ9CWHS94Mi+RYBF+SpaMLoZKqCU4Q3UWiHiOyPnMaohAdvRE\ngJkaY2OAkFaaCI31rwBrs6b5U/ErtRTUZNJEI7OCi6wDBfBwAAAIEA0ZKyuUW5+VFcTyuR\n1G0ky5uihtJryFCjA2fzu7tgobm0gsIgSDClp9TdMh5CDyJo0R9fQnH8Lki0Ku+jgc4X+a\n/XMw47d1iL7Hdu9NAJsplezKD5Unso4xJRXhLnXUT5FT8lSgwE+9xUBuILKUmZQa20ejKM\n20U6szOxEEclA/8AAAAObWFya0BiYXJuYWNsZXMBAgMEBQ==\n-----END OPENSSH PRIVATE KEY-----\n";
        rcPrivateSpec = new OpenSSHPrivateKeySpec(new PemReader((Reader)new StringReader(rsa2048Key)).readPemObject().getContent());
        this.isEquals("Spec Type", rcPrivateSpec.getFormat(), "OpenSSH");
        prk = kpf.generatePrivate((KeySpec)rcPrivateSpec);
        this.isEquals("pub exponent", ((RSAPrivateCrtKey)prk).getPublicExponent(), new BigInteger("10001", 16));
    }

    public void testEncodingDSA() throws Exception {
        byte[] rawPub = Base64.decode((String)"AAAAB3NzaC1kc3MAAACBAJBB5+S4kZZYZLswaQ/zm3GM7YWmHsumwo/Xxu+z6Cg2l5PUoiBBZ4ET9EhhQuL2ja/zrCMCi0ZwiSRuSp36ayPrHLbNJb3VdOuJg8xExRa6F3YfVZfcTPUEKh6FU72fI31HrQmi4rpyHnWxL/iDX496ZG2Hdq6UkPISQpQwj4TtAAAAFQCP9TXcVahR/2rpfEhvdXR0PfhbRwAAAIBdXzAVqoOtb9zog6lNF1cGS1S06W9W/clvuwq2xF1s3bkoI/xUbFSc0IAPsGl2kcB61PAZqcop50lgpvYzt8cq/tbqz3ypq1dCQ0xdmJHj975QsRFax+w6xQ0kgpBhwcS2EOizKb+C+tRzndGpcDSoSMuVXp9i4wn5pJSTZxAYFQAAAIEAhQZc687zYxrEDR/1q6m4hw5GFxuVvLsC+bSHtMF0c11Qy4IPg7mBeP7K5Kq4WyJPtmZhuc5Bb12bJQR6qgd1uLn692fe1UK2kM6eWXBzhlzZ54BslfSKHGNN4qH+ln3Zaf/4rpKE7fvoinkrgkOZmj0PMx9D6wlpHKkXMUxeXtc=");
        byte[] rawPriv = new PemReader((Reader)new StringReader("-----BEGIN DSA PRIVATE KEY-----\nMIIBuwIBAAKBgQCQQefkuJGWWGS7MGkP85txjO2Fph7LpsKP18bvs+goNpeT1KIg\nQWeBE/RIYULi9o2v86wjAotGcIkkbkqd+msj6xy2zSW91XTriYPMRMUWuhd2H1WX\n3Ez1BCoehVO9nyN9R60JouK6ch51sS/4g1+PemRth3aulJDyEkKUMI+E7QIVAI/1\nNdxVqFH/aul8SG91dHQ9+FtHAoGAXV8wFaqDrW/c6IOpTRdXBktUtOlvVv3Jb7sK\ntsRdbN25KCP8VGxUnNCAD7BpdpHAetTwGanKKedJYKb2M7fHKv7W6s98qatXQkNM\nXZiR4/e+ULERWsfsOsUNJIKQYcHEthDosym/gvrUc53RqXA0qEjLlV6fYuMJ+aSU\nk2cQGBUCgYEAhQZc687zYxrEDR/1q6m4hw5GFxuVvLsC+bSHtMF0c11Qy4IPg7mB\neP7K5Kq4WyJPtmZhuc5Bb12bJQR6qgd1uLn692fe1UK2kM6eWXBzhlzZ54BslfSK\nHGNN4qH+ln3Zaf/4rpKE7fvoinkrgkOZmj0PMx9D6wlpHKkXMUxeXtcCFELnLOJ8\nD0akSCUFY/iDLo/KnOIH\n-----END DSA PRIVATE KEY-----\n")).readPemObject().getContent();
        OpenSSHPublicKeySpec pubSpec = new OpenSSHPublicKeySpec(rawPub);
        OpenSSHPrivateKeySpec privSpec = new OpenSSHPrivateKeySpec(rawPriv);
        this.isEquals("Pk type", pubSpec.getType(), "ssh-dss");
        this.isEquals("Spec Type", privSpec.getFormat(), "ASN.1");
        byte[] originalMessage = new byte[10];
        secureRandom.nextBytes(originalMessage);
        originalMessage[0] = (byte)(originalMessage[0] | 1);
        KeyFactory kpf = KeyFactory.getInstance("DSA", "BC");
        PublicKey pk = kpf.generatePublic((KeySpec)pubSpec);
        PrivateKey prk = kpf.generatePrivate((KeySpec)privSpec);
        OpenSSHPublicKeySpec dsaPublicKeySpec = (OpenSSHPublicKeySpec)kpf.getKeySpec(pk, class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec);
        OpenSSHPrivateKeySpec dsaPrivateSpec = (OpenSSHPrivateKeySpec)kpf.getKeySpec(prk, class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec);
        this.isEquals("Pk type", dsaPublicKeySpec.getType(), "ssh-dss");
        this.isEquals("Spec Type", dsaPrivateSpec.getFormat(), "ASN.1");
        this.isTrue("DSA Public key not same", Arrays.areEqual((byte[])rawPub, (byte[])dsaPublicKeySpec.getEncoded()));
        this.isTrue("DSA Private key not same", Arrays.areEqual((byte[])rawPriv, (byte[])dsaPrivateSpec.getEncoded()));
    }

    private void testEncodingECDSA() throws Exception {
        byte[] rawPub = Base64.decode((String)"AAAAE2VjZHNhLXNoYTItbmlzdHAyNTYAAAAIbmlzdHAyNTYAAABBBHq5qxGqnh93Gpbj2w1Avx1UwBl6z5bZC3Viog1yNHDZYcV6Da4YQ3i0/hN7xY7sUy9dNF6g16tJSYXQQ4tvO3g=");
        byte[] rawPriv = new PemReader((Reader)new StringReader("-----BEGIN EC PRIVATE KEY-----\nMHcCAQEEIHeg/+m02j6nr4bO8ubfbzhs0fqOjiuIoWbvGnVg+FmpoAoGCCqGSM49\nAwEHoUQDQgAEermrEaqeH3caluPbDUC/HVTAGXrPltkLdWKiDXI0cNlhxXoNrhhD\neLT+E3vFjuxTL100XqDXq0lJhdBDi287eA==\n-----END EC PRIVATE KEY-----\n")).readPemObject().getContent();
        OpenSSHPublicKeySpec pubSpec = new OpenSSHPublicKeySpec(rawPub);
        OpenSSHPrivateKeySpec privSpec = new OpenSSHPrivateKeySpec(rawPriv);
        this.isEquals("ecdsa-sha2-nistp256", pubSpec.getType());
        this.isEquals("Spec Type", privSpec.getFormat(), "ASN.1");
        KeyFactory kpf = KeyFactory.getInstance("EC", "BC");
        PublicKey pk = kpf.generatePublic((KeySpec)pubSpec);
        PrivateKey prk = kpf.generatePrivate((KeySpec)privSpec);
        OpenSSHPublicKeySpec ecdsaPublicKeySpec = (OpenSSHPublicKeySpec)kpf.getKeySpec(pk, class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec);
        OpenSSHPrivateKeySpec ecdsaPrivateSpec = (OpenSSHPrivateKeySpec)kpf.getKeySpec(prk, class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec);
        this.isEquals("Spec Type", ecdsaPrivateSpec.getFormat(), "ASN.1");
        this.isTrue("ECPublic key not same", Arrays.areEqual((byte[])rawPub, (byte[])ecdsaPublicKeySpec.getEncoded()));
        this.isTrue("ECPrivate key not same", Arrays.areEqual((byte[])rawPriv, (byte[])ecdsaPrivateSpec.getEncoded()));
        this.isEquals("ecdsa-sha2-nistp256", ecdsaPublicKeySpec.getType());
    }

    public void testED25519() throws Exception {
        byte[] rawPub = Base64.decode((String)"AAAAC3NzaC1lZDI1NTE5AAAAIM4CaV7WQcy0lht0hclgXf4Olyvzvv2fnUvQ3J8IYsWF");
        byte[] rawPriv = new PemReader((Reader)new StringReader("-----BEGIN OPENSSH PRIVATE KEY-----\nb3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtzc2gtZW\nQyNTUxOQAAACDOAmle1kHMtJYbdIXJYF3+Dpcr8779n51L0NyfCGLFhQAAAKBTr4PvU6+D\n7wAAAAtzc2gtZWQyNTUxOQAAACDOAmle1kHMtJYbdIXJYF3+Dpcr8779n51L0NyfCGLFhQ\nAAAED4BTHeR3YD7CFQqusztfL5K+YSD4mRGLBwb7jHiXxIJM4CaV7WQcy0lht0hclgXf4O\nlyvzvv2fnUvQ3J8IYsWFAAAAG21lZ2Fud29vZHNAdHljaGUtMzI2NS5sb2NhbAEC\n-----END OPENSSH PRIVATE KEY-----\n")).readPemObject().getContent();
        OpenSSHPublicKeySpec pubSpec = new OpenSSHPublicKeySpec(rawPub);
        OpenSSHPrivateKeySpec privSpec = new OpenSSHPrivateKeySpec(rawPriv);
        this.isEquals("Pk type", pubSpec.getType(), "ssh-ed25519");
        this.isEquals("Spec Type", privSpec.getFormat(), "OpenSSH");
        KeyFactory kpf = KeyFactory.getInstance("ED25519", "BC");
        PublicKey pk = kpf.generatePublic((KeySpec)pubSpec);
        PrivateKey prk = kpf.generatePrivate((KeySpec)privSpec);
        OpenSSHPublicKeySpec edDsaPublicKeySpec = (OpenSSHPublicKeySpec)kpf.getKeySpec(pk, class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPublicKeySpec);
        OpenSSHPrivateKeySpec edDsaPrivateKeySpec = (OpenSSHPrivateKeySpec)kpf.getKeySpec(prk, class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec == null ? (class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec = OpenSSHSpecTests.class$("org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec")) : class$org$bouncycastle$jcajce$spec$OpenSSHPrivateKeySpec);
        this.isEquals("Pk type", edDsaPublicKeySpec.getType(), "ssh-ed25519");
        this.isEquals("Spec Type", edDsaPrivateKeySpec.getFormat(), "OpenSSH");
        this.isTrue("EDPublic key not same", Arrays.areEqual((byte[])rawPub, (byte[])edDsaPublicKeySpec.getEncoded()));
        byte[] enc = edDsaPrivateKeySpec.getEncoded();
        byte[] base = Hex.decode((String)"6f70656e7373682d6b65792d763100000000046e6f6e65000000046e6f6e650000000000000001000000330000000b7373682d6564323535313900000020ce02695ed641ccb4961b7485c9605dfe0e972bf3befd9f9d4bd0dc9f0862c58500000088");
        byte[] tail = Hex.decode((String)"0000000b7373682d6564323535313900000020ce02695ed641ccb4961b7485c9605dfe0e972bf3befd9f9d4bd0dc9f0862c58500000040f80531de477603ec2150aaeb33b5f2f92be6120f899118b0706fb8c7897c4824ce02695ed641ccb4961b7485c9605dfe0e972bf3befd9f9d4bd0dc9f0862c585000000000102030405");
        this.isTrue("EDPrivate key base not same", Arrays.areEqual((byte[])base, (byte[])Arrays.copyOfRange((byte[])enc, (int)0, (int)base.length)));
        this.isTrue("EDPrivate key tail not same", Arrays.areEqual((byte[])tail, (byte[])Arrays.copyOfRange((byte[])enc, (int)(base.length + 8), (int)enc.length)));
        this.isEquals("ssh-ed25519", edDsaPublicKeySpec.getType());
    }

    public String getName() {
        return "OpenSSHSpec";
    }

    public void performTest() throws Exception {
        this.testEncodingDSA();
        this.testEncodingRSA();
        this.testEncodingECDSA();
        this.testED25519();
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new OpenSSHSpecTests());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

