/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class NamedCurveTest
implements Test {
    private String name;

    NamedCurveTest() {
        this("prime192v1");
    }

    NamedCurveTest(String name) {
        this.name = name;
    }

    public TestResult perform() {
        try {
            X509EncodedKeySpec pubX509;
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)this.name);
            if (ecSpec == null) {
                return new SimpleTestResult(false, this.getName() + " no curve for " + this.name + " found.");
            }
            KeyPairGenerator g = KeyPairGenerator.getInstance("ECDH", "BC");
            g.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
            KeyPair aKeyPair = g.generateKeyPair();
            KeyAgreement aKeyAgree = KeyAgreement.getInstance("ECDHC", "BC");
            aKeyAgree.init(aKeyPair.getPrivate());
            KeyPair bKeyPair = g.generateKeyPair();
            KeyAgreement bKeyAgree = KeyAgreement.getInstance("ECDHC", "BC");
            bKeyAgree.init(bKeyPair.getPrivate());
            aKeyAgree.doPhase(bKeyPair.getPublic(), true);
            bKeyAgree.doPhase(aKeyPair.getPublic(), true);
            BigInteger k1 = new BigInteger(aKeyAgree.generateSecret());
            BigInteger k2 = new BigInteger(bKeyAgree.generateSecret());
            if (!k1.equals(k2)) {
                return new SimpleTestResult(false, this.getName() + " 2-way test failed");
            }
            byte[] pubEnc = aKeyPair.getPublic().getEncoded();
            KeyFactory keyFac = KeyFactory.getInstance("ECDH", "BC");
            ECPublicKey pubKey = (ECPublicKey)keyFac.generatePublic(pubX509 = new X509EncodedKeySpec(pubEnc));
            if (!pubKey.getQ().equals(((ECPublicKey)aKeyPair.getPublic()).getQ())) {
                return new SimpleTestResult(false, this.getName() + ": public key encoding (Q test) failed");
            }
            if (!(pubKey.getParameters() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, this.getName() + ": public key encoding not named curve");
            }
            byte[] privEnc = aKeyPair.getPrivate().getEncoded();
            PKCS8EncodedKeySpec privPKCS8 = new PKCS8EncodedKeySpec(privEnc);
            ECPrivateKey privKey = (ECPrivateKey)keyFac.generatePrivate(privPKCS8);
            if (!privKey.getD().equals(((ECPrivateKey)aKeyPair.getPrivate()).getD())) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding (D test) failed");
            }
            if (!(privKey.getParameters() instanceof ECNamedCurveParameterSpec)) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding not named curve");
            }
            if (!((ECNamedCurveParameterSpec)privKey.getParameters()).getName().equals(this.name)) {
                return new SimpleTestResult(false, this.getName() + ": private key encoding wrong named curve");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + e.toString());
        }
    }

    public String getName() {
        return "NamedCurve";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        NamedCurveTest test = args.length == 0 ? new NamedCurveTest() : new NamedCurveTest(args[0]);
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

