/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.MultiCertStoreParameters;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTest;

public class MultiCertStoreTest
extends SimpleTest {
    public void performTest() throws Exception {
        this.basicTest();
    }

    private void basicTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        list.add(rootCrl);
        list.add(interCrl);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store1 = CertStore.getInstance((String)"Collection", (CertStoreParameters)ccsp, (String)"BC");
        CertStore store2 = CertStore.getInstance((String)"Collection", (CertStoreParameters)ccsp, (String)"BC");
        ArrayList<CertStore> storeList = new ArrayList<CertStore>();
        storeList.add(store1);
        storeList.add(store2);
        CertStore store = CertStore.getInstance((String)"Multi", (CertStoreParameters)new MultiCertStoreParameters(storeList));
        X509CertSelector targetConstraints = new X509CertSelector();
        targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal((X509Certificate)rootCert).getName());
        Collection certs = store.getCertificates((CertSelector)targetConstraints);
        if (certs.size() != 2 || !certs.contains(rootCert)) {
            this.fail("2 rootCerts not found by subjectDN");
        }
        if ((certs = (store = CertStore.getInstance((String)"Multi", (CertStoreParameters)new MultiCertStoreParameters(storeList, false))).getCertificates((CertSelector)targetConstraints)).size() != 1 || !certs.contains(rootCert)) {
            this.fail("1 rootCert not found by subjectDN");
        }
    }

    public String getName() {
        return "MultiCertStore";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new MultiCertStoreTest());
    }
}

