/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode((String)"0123456789abcdef");
    static byte[] ivBytes = Hex.decode((String)"1234567890abcdef");
    static byte[] input = Hex.decode((String)"37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode((String)"f1d30f68");
    static byte[] output2 = Hex.decode((String)"58d2e77e");
    static byte[] output3 = Hex.decode((String)"cd647403");
    static byte[] keyBytesISO9797 = Hex.decode((String)"7CA110454A1A6E570131D9619DC1376E");
    static byte[] inputISO9797 = "Hello World !!!!".getBytes();
    static byte[] outputISO9797 = Hex.decode((String)"F09B856213BAB83B");
    static byte[] inputDesEDE64 = "Hello World !!!!".getBytes();
    static byte[] outputDesEDE64 = Hex.decode((String)"862304d33af01096");

    private void aliasTest(SecretKey key, String primary, String[] aliases) throws Exception {
        Mac mac = Mac.getInstance(primary, "BC");
        mac.init(key);
        mac.update(input, 0, input.length);
        byte[] ref = mac.doFinal();
        int i = 0;
        while (i != aliases.length) {
            mac = Mac.getInstance(aliases[i], "BC");
            mac.init(key);
            mac.update(input, 0, input.length);
            byte[] out = mac.doFinal();
            if (!this.areEqual(out, ref)) {
                this.fail("Failed - expected " + new String(Hex.encode((byte[])ref)) + " got " + new String(Hex.encode((byte[])out)));
            }
            ++i;
        }
    }

    public void performTest() throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
        Mac mac = Mac.getInstance("DESMac", "BC");
        mac.init(key);
        mac.update(input, 0, input.length);
        byte[] out = mac.doFinal();
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac.init(key, new IvParameterSpec(ivBytes));
        mac.update(input, 0, input.length);
        out = mac.doFinal();
        if (!this.areEqual(out, output2)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output2)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac = Mac.getInstance("DESMac/CFB8", "BC");
        mac.init(key, new IvParameterSpec(ivBytes));
        mac.update(input, 0, input.length);
        out = mac.doFinal();
        if (!this.areEqual(out, output3)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output3)) + " got " + new String(Hex.encode((byte[])out)));
        }
        key = new SecretKeySpec(keyBytesISO9797, "DESEDE");
        mac = Mac.getInstance("ISO9797ALG3", "BC");
        mac.init(key);
        mac.update(inputISO9797, 0, inputISO9797.length);
        out = mac.doFinal();
        if (!this.areEqual(out, outputISO9797)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])outputISO9797)) + " got " + new String(Hex.encode((byte[])out)));
        }
        key = new SecretKeySpec(keyBytesISO9797, "DESEDE");
        mac = Mac.getInstance("DESEDE64", "BC");
        mac.init(key);
        mac.update(inputDesEDE64, 0, inputDesEDE64.length);
        out = mac.doFinal();
        if (!this.areEqual(out, outputDesEDE64)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])outputDesEDE64)) + " got " + new String(Hex.encode((byte[])out)));
        }
        this.aliasTest(new SecretKeySpec(keyBytesISO9797, "DESede"), "DESedeMac64withISO7816-4Padding", new String[]{"DESEDE64WITHISO7816-4PADDING", "DESEDEISO9797ALG1MACWITHISO7816-4PADDING", "DESEDEISO9797ALG1WITHISO7816-4PADDING"});
        this.aliasTest(new SecretKeySpec(keyBytesISO9797, "DESede"), "ISO9797ALG3WITHISO7816-4PADDING", new String[]{"ISO9797ALG3MACWITHISO7816-4PADDING"});
        this.aliasTest(new SecretKeySpec(keyBytes, "DES"), "DES64", new String[]{"DESMAC64"});
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new MacTest());
    }
}

