/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class IESTest
extends SimpleTest {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$IESParameterSpec;

    IESTest() {
    }

    public String getName() {
        return "IES";
    }

    public void performTest() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECIES", "BC");
        X9ECParameters x9 = ECNamedCurveTable.getByName((String)"prime239v1");
        ECParameterSpec ecSpec = new ECParameterSpec(x9.getCurve(), x9.getG(), x9.getN(), x9.getH());
        g.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        Cipher c1 = Cipher.getInstance("ECIES", "BC");
        Cipher c2 = Cipher.getInstance("ECIES", "BC");
        this.doTest(g, c1, c2);
        g = KeyPairGenerator.getInstance("ECIES", "BC");
        g.initialize(192, new SecureRandom());
        this.doTest(g, c1, c2);
        g = KeyPairGenerator.getInstance("ECIES", "BC");
        g.initialize(239, new SecureRandom());
        this.doTest(g, c1, c2);
        g = KeyPairGenerator.getInstance("ECIES", "BC");
        g.initialize(256, new SecureRandom());
        this.doTest(g, c1, c2);
        this.doDefTest(g, c1, c2);
        DHParameterSpec dhParams = new DHParameterSpec(this.p512, this.g512);
        c1 = Cipher.getInstance("IES", "BC");
        c2 = Cipher.getInstance("IES", "BC");
        g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(dhParams);
        this.doTest(g, c1, c2);
        this.doDefTest(g, c1, c2);
        this.doOutputSizeTest();
        this.doAlgorithmParameterTest();
    }

    private void doOutputSizeTest() throws Exception {
        byte[] data = "Block of data to be encrypted".getBytes();
        KeyPairGenerator generator = KeyPairGenerator.getInstance("ECIES", "BC");
        KeyPair keyPair = generator.generateKeyPair();
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[16];
        random.nextBytes(nonce);
        Cipher encryptCipher = Cipher.getInstance("ECIESWITHAES-CBC", "BC");
        IESParameterSpec spec = new IESParameterSpec(null, null, 128, 128, nonce);
        encryptCipher.init(1, (Key)new IEKeySpec(keyPair.getPrivate(), keyPair.getPublic()), (AlgorithmParameterSpec)spec);
        int onlyFinalExpectedSize = encryptCipher.getOutputSize(data.length);
        encryptCipher.update(data);
        int updateAndFinalExpectedSize = encryptCipher.getOutputSize(0);
        this.isTrue(updateAndFinalExpectedSize == onlyFinalExpectedSize);
        byte[] encrypted = new byte[updateAndFinalExpectedSize];
        int actualEncryptedSize = encryptCipher.doFinal(encrypted, 0);
        Cipher decryptCipher = Cipher.getInstance("ECIESWITHAES-CBC", "BC");
        decryptCipher.init(2, (Key)new IEKeySpec(keyPair.getPrivate(), keyPair.getPublic()), (AlgorithmParameterSpec)spec);
        onlyFinalExpectedSize = decryptCipher.getOutputSize(actualEncryptedSize);
        decryptCipher.update(encrypted, 0, actualEncryptedSize);
        updateAndFinalExpectedSize = decryptCipher.getOutputSize(0);
        this.isTrue(updateAndFinalExpectedSize == onlyFinalExpectedSize);
        byte[] decrypted = new byte[updateAndFinalExpectedSize];
        int actualDecryptedSize = decryptCipher.doFinal(decrypted, 0);
        this.isTrue(this.areEqual(data, 0, data.length, decrypted, 0, actualDecryptedSize));
    }

    private void doAlgorithmParameterTest() throws Exception {
        this.trySpec(new IESParameterSpec(null, null, 128, 128, Hex.decode((String)"deafbeef")));
        this.trySpec(new IESParameterSpec(Hex.decode((String)"ffff"), Hex.decode((String)"aaaa"), 256, 128, Hex.decode((String)"deafbeef")));
        this.trySpec(new IESParameterSpec(Hex.decode((String)"ffff"), Hex.decode((String)"aaaa"), 256, 128, Hex.decode((String)"deafbeef"), true));
        this.trySpec(new IESParameterSpec(Hex.decode((String)"ffffcc"), Hex.decode((String)"aaaabb"), 256));
    }

    private void trySpec(IESParameterSpec spec) throws Exception {
        AlgorithmParameters alg1 = AlgorithmParameters.getInstance("IES", "BC");
        AlgorithmParameters alg2 = AlgorithmParameters.getInstance("IES", "BC");
        alg1.init((AlgorithmParameterSpec)spec);
        alg2.init(alg1.getEncoded());
        IESParameterSpec iesSpec = (IESParameterSpec)alg2.getParameterSpec(class$org$bouncycastle$jce$spec$IESParameterSpec == null ? (class$org$bouncycastle$jce$spec$IESParameterSpec = IESTest.class$("org.bouncycastle.jce.spec.IESParameterSpec")) : class$org$bouncycastle$jce$spec$IESParameterSpec);
        this.isTrue(iesSpec.getPointCompression() == spec.getPointCompression());
        this.isTrue(Arrays.areEqual((byte[])iesSpec.getNonce(), (byte[])spec.getNonce()));
        this.isTrue(Arrays.areEqual((byte[])iesSpec.getDerivationV(), (byte[])spec.getDerivationV()));
        this.isTrue(Arrays.areEqual((byte[])iesSpec.getEncodingV(), (byte[])spec.getEncodingV()));
        this.isTrue(iesSpec.getMacKeySize() == spec.getMacKeySize());
        this.isTrue(iesSpec.getCipherKeySize() == spec.getCipherKeySize());
    }

    public void doTest(KeyPairGenerator g, Cipher c1, Cipher c2) throws Exception {
        byte[] out2;
        int estLen2;
        KeyPair aKeyPair = g.generateKeyPair();
        PublicKey aPub = aKeyPair.getPublic();
        PrivateKey aPriv = aKeyPair.getPrivate();
        KeyPair bKeyPair = g.generateKeyPair();
        PublicKey bPub = bKeyPair.getPublic();
        PrivateKey bPriv = bKeyPair.getPrivate();
        IEKeySpec c1Key = new IEKeySpec(aPriv, bPub);
        IEKeySpec c2Key = new IEKeySpec(bPriv, aPub);
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameterSpec param = new IESParameterSpec(d, e, 128);
        c1.init(1, (Key)c1Key, (AlgorithmParameterSpec)param);
        c2.init(2, (Key)c2Key, (AlgorithmParameterSpec)param);
        byte[] message = Hex.decode((String)"1234567890abcdef");
        int estLen1 = c1.getOutputSize(message.length);
        byte[] out1 = c1.doFinal(message, 0, message.length);
        if (estLen1 < out1.length) {
            this.fail("output size incorrect");
        }
        if ((estLen2 = c2.getOutputSize(out1.length)) < (out2 = c2.doFinal(out1, 0, out1.length)).length) {
            this.fail("output size incorrect");
        }
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
    }

    public void doDefTest(KeyPairGenerator g, Cipher c1, Cipher c2) throws Exception {
        int len2;
        int len1;
        byte[] out2;
        int estLen2;
        KeyPair aKeyPair = g.generateKeyPair();
        PublicKey aPub = aKeyPair.getPublic();
        PrivateKey aPriv = aKeyPair.getPrivate();
        KeyPair bKeyPair = g.generateKeyPair();
        PublicKey bPub = bKeyPair.getPublic();
        PrivateKey bPriv = bKeyPair.getPrivate();
        IEKeySpec c1Key = new IEKeySpec(aPriv, bPub);
        IEKeySpec c2Key = new IEKeySpec(bPriv, aPub);
        byte[] d = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] e = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        IESParameterSpec param = new IESParameterSpec(d, e, 128);
        c1.init(1, (Key)c1Key, (AlgorithmParameterSpec)param);
        c2.init(2, (Key)c2Key, (AlgorithmParameterSpec)param);
        byte[] message = Hex.decode((String)"1234567890abcdef");
        int estLen1 = c1.getOutputSize(message.length);
        byte[] out1 = c1.doFinal(message, 0, message.length);
        if (estLen1 < out1.length) {
            this.fail("output size incorrect");
        }
        if ((estLen2 = c2.getOutputSize(out1.length)) < (out2 = c2.doFinal(out1, 0, out1.length)).length) {
            this.fail("output size incorrect");
        }
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
        if ((len1 = c1.doFinal(message, 0, message.length, out1, 0)) != out1.length) {
            this.fail("encryption length wrong");
        }
        if ((len2 = c2.doFinal(out1, 0, out1.length, out2, 0)) != out2.length) {
            this.fail("decryption length wrong");
        }
        if (!this.areEqual(out2, message)) {
            this.fail("stream cipher test failed");
        }
        len1 = c1.update(message, 0, 2, out1, 0);
        if ((len1 += c1.doFinal(message, 2, message.length - 2, out1, len1)) != out1.length) {
            this.fail("update encryption length wrong");
        }
        len2 = c2.update(out1, 0, 2, out2, 0);
        if ((len2 += c2.doFinal(out1, 2, out1.length - 2, out2, len2)) != out2.length) {
            this.fail("update decryption length wrong");
        }
        if (!this.areEqual(out2, message)) {
            this.fail("update stream cipher test failed");
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new IESTest());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

