/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Iterator;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.spec.XDHParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class EdECTest
extends SimpleTest {
    private static final byte[] pubEnc = Base64.decode((String)"MCowBQYDK2VwAyEAGb9ECWmEzf6FQbrBZ9w7lshQhqowtrbLDFw4rXAxZuE=");
    private static final byte[] privEnc = Base64.decode((String)"MC4CAQAwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhC");
    private static final byte[] privWithPubEnc = Base64.decode((String)"MHICAQEwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhCoB8wHQYKKoZIhvcNAQkJFDEPDA1DdXJkbGUgQ2hhaXJzgSEAGb9ECWmEzf6FQbrBZ9w7lshQhqowtrbLDFw4rXAxZuE=");
    public static final byte[] x25519Cert = Base64.decode((String)"MIIBLDCB36ADAgECAghWAUdKKo3DMDAFBgMrZXAwGTEXMBUGA1UEAwwOSUVURiBUZXN0IERlbW8wHhcNMTYwODAxMTIxOTI0WhcNNDAxMjMxMjM1OTU5WjAZMRcwFQYDVQQDDA5JRVRGIFRlc3QgRGVtbzAqMAUGAytlbgMhAIUg8AmJMKdUdIt93LQ+91oNvzoNJjga9OukqY6qm05qo0UwQzAPBgNVHRMBAf8EBTADAQEAMA4GA1UdDwEBAAQEAwIDCDAgBgNVHQ4BAQAEFgQUmx9e7e0EM4Xk97xiPFl1uQvIuzswBQYDK2VwA0EAryMB/t3J5v/BzKc9dNZIpDmAgs3babFOTQbs+BolzlDUwsPrdGxO3YNGhW7Ibz3OGhhlxXrCe1Cgw1AH9efZBw==");

    public String getName() {
        return "EdEC";
    }

    public void performTest() throws Exception {
        KeyFactory kFact = KeyFactory.getInstance("EdDSA", "BC");
        PublicKey pub = kFact.generatePublic(new X509EncodedKeySpec(pubEnc));
        this.isTrue("pub failed", this.areEqual(pubEnc, pub.getEncoded()));
        this.serializationTest("ref pub", pub);
        PrivateKey priv = kFact.generatePrivate(new PKCS8EncodedKeySpec(privEnc));
        this.isTrue("priv failed", this.areEqual(privEnc, priv.getEncoded()));
        priv = kFact.generatePrivate(new PKCS8EncodedKeySpec(privWithPubEnc));
        this.isTrue("priv with pub failed", this.areEqual(privWithPubEnc, priv.getEncoded()));
        this.serializationTest("ref priv", priv);
        Signature sig = Signature.getInstance("EDDSA", "BC");
        ASN1Sequence x25519Seq = ASN1Sequence.getInstance((Object)x25519Cert);
        Certificate x25519Cert = Certificate.getInstance((Object)x25519Seq);
        sig.initVerify(pub);
        sig.update(x25519Seq.getObjectAt(0).toASN1Primitive().getEncoded("DL"));
        this.isTrue(sig.verify(x25519Cert.getSignature().getBytes()));
        CertificateFactory certFact = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate c = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(EdECTest.x25519Cert));
        this.isTrue("Ed25519".equals(c.getSigAlgName()));
        certFact = CertificateFactory.getInstance("X.509", "SUN");
        c = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(EdECTest.x25519Cert));
        this.x448AgreementTest();
        this.x25519AgreementTest();
        this.ed448SignatureTest();
        this.ed25519SignatureTest();
        this.x448withCKDFTest();
        this.x25519withCKDFTest();
        this.x448withKDFTest();
        this.x25519withKDFTest();
        this.x448UwithKDFTest();
        this.x25519UwithKDFTest();
        this.xdhGeneratorTest();
        this.eddsaGeneratorTest();
        this.keyTest("X448");
        this.keyTest("X25519");
        this.keyTest("Ed448");
        this.keyTest("Ed25519");
        this.keyFactoryTest("X448", EdECObjectIdentifiers.id_X448);
        this.keyFactoryTest("X25519", EdECObjectIdentifiers.id_X25519);
        this.keyFactoryTest("Ed448", EdECObjectIdentifiers.id_Ed448);
        this.keyFactoryTest("Ed25519", EdECObjectIdentifiers.id_Ed25519);
    }

    private void keyFactoryTest(String algorithm, ASN1ObjectIdentifier algOid) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm, "BC");
        KeyFactory kFact = KeyFactory.getInstance(algorithm.startsWith("X") ? "XDH" : "EdDSA", "BC");
        KeyPair kp = kpGen.generateKeyPair();
        HashSet<String> alts = new HashSet<String>();
        alts.add("X448");
        alts.add("X25519");
        alts.add("Ed448");
        alts.add("Ed25519");
        alts.remove(algorithm);
        PrivateKey k1 = kFact.generatePrivate(new PKCS8EncodedKeySpec(kp.getPrivate().getEncoded()));
        this.checkEquals(algorithm, kp.getPrivate(), k1);
        PublicKey k2 = kFact.generatePublic(new X509EncodedKeySpec(kp.getPublic().getEncoded()));
        this.checkEquals(algorithm, kp.getPublic(), k2);
        Iterator it = alts.iterator();
        while (it.hasNext()) {
            String altAlg = (String)it.next();
            kFact = KeyFactory.getInstance(altAlg, "BC");
            try {
                k1 = kFact.generatePrivate(new PKCS8EncodedKeySpec(kp.getPrivate().getEncoded()));
                this.fail("no exception");
            }
            catch (InvalidKeySpecException e) {
                this.isEquals("encoded key spec not recognized: algorithm identifier " + algOid.getId() + " in key not recognized", e.getMessage());
            }
            try {
                k2 = kFact.generatePublic(new X509EncodedKeySpec(kp.getPublic().getEncoded()));
                this.fail("no exception");
            }
            catch (InvalidKeySpecException e) {
                this.isEquals("encoded key spec not recognized: algorithm identifier " + algOid.getId() + " in key not recognized", e.getMessage());
            }
        }
    }

    private void keyTest(String algorithm) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm, "BC");
        KeyFactory kFact = KeyFactory.getInstance(algorithm, "BC");
        KeyPair kp = kpGen.generateKeyPair();
        PrivateKey k1 = kFact.generatePrivate(new PKCS8EncodedKeySpec(kp.getPrivate().getEncoded()));
        this.checkEquals(algorithm, kp.getPrivate(), k1);
        PublicKey k2 = kFact.generatePublic(new X509EncodedKeySpec(kp.getPublic().getEncoded()));
        this.checkEquals(algorithm, kp.getPublic(), k2);
        this.serializationTest(algorithm, kp.getPublic());
        this.serializationTest(algorithm, kp.getPrivate());
        String pubString = kp.getPublic().toString();
        String privString = kp.getPrivate().toString();
        this.isTrue(pubString.startsWith(algorithm + " Public Key ["));
        this.isTrue(privString.startsWith(algorithm + " Private Key ["));
        this.isTrue(privString.substring((algorithm + " Private Key [").length()).equals(pubString.substring((algorithm + " Public Key [").length())));
    }

    private void xdhGeneratorTest() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("XDH", "BC");
        kpGen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X448"));
        KeyPair kp = kpGen.generateKeyPair();
        this.isTrue("X448".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(448);
        kp = kpGen.generateKeyPair();
        this.isTrue("X448".equals(kp.getPublic().getAlgorithm()));
        kpGen = KeyPairGenerator.getInstance("XDH", "BC");
        kpGen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X25519"));
        kp = kpGen.generateKeyPair();
        this.isTrue("X25519".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(256);
        kp = kpGen.generateKeyPair();
        this.isTrue("X25519".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(255);
        kp = kpGen.generateKeyPair();
        this.isTrue("X25519".equals(kp.getPublic().getAlgorithm()));
        kpGen = KeyPairGenerator.getInstance("XDH", "BC");
        try {
            kpGen.generateKeyPair();
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("generator not correctly initialized", e.getMessage());
        }
        try {
            kpGen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed448"));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isEquals("parameterSpec for wrong curve type", e.getMessage());
        }
        try {
            kpGen.initialize(1024);
            this.fail("no exception");
        }
        catch (InvalidParameterException e) {
            this.isEquals("unknown key size", e.getMessage());
        }
        try {
            kpGen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed448"));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isEquals("parameterSpec for wrong curve type", e.getMessage());
        }
        try {
            new XDHParameterSpec("Ed448");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("unrecognized curve name: Ed448", e.getMessage());
        }
    }

    private void eddsaGeneratorTest() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EdDSA", "BC");
        kpGen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed448"));
        KeyPair kp = kpGen.generateKeyPair();
        this.isTrue("Ed448".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed448"));
        kp = kpGen.generateKeyPair();
        this.isTrue("Ed448".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(448);
        kp = kpGen.generateKeyPair();
        this.isTrue("Ed448".equals(kp.getPublic().getAlgorithm()));
        kpGen = KeyPairGenerator.getInstance("EdDSA", "BC");
        kpGen.initialize((AlgorithmParameterSpec)new EdDSAParameterSpec("Ed25519"));
        kp = kpGen.generateKeyPair();
        this.isTrue("Ed25519".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(256);
        kp = kpGen.generateKeyPair();
        this.isTrue("Ed25519".equals(kp.getPublic().getAlgorithm()));
        kpGen.initialize(255);
        kp = kpGen.generateKeyPair();
        this.isTrue("Ed25519".equals(kp.getPublic().getAlgorithm()));
        kpGen = KeyPairGenerator.getInstance("EdDSA", "BC");
        try {
            kpGen.generateKeyPair();
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("generator not correctly initialized", e.getMessage());
        }
        try {
            kpGen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X448"));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isEquals("parameterSpec for wrong curve type", e.getMessage());
        }
        try {
            kpGen.initialize((AlgorithmParameterSpec)new XDHParameterSpec("X25519"));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isEquals("parameterSpec for wrong curve type", e.getMessage());
        }
        try {
            kpGen.initialize(1024);
            this.fail("no exception");
        }
        catch (InvalidParameterException e) {
            this.isEquals("unknown key size", e.getMessage());
        }
        try {
            new EdDSAParameterSpec("X448");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("unrecognized curve name: X448", e.getMessage());
        }
    }

    private void checkEquals(String algorithm, Key ka, Key kb) {
        this.isEquals(algorithm + " check equals", ka, kb);
        this.isEquals(algorithm + " check hashCode", ka.hashCode(), kb.hashCode());
    }

    private void serializationTest(String algorithm, Key key) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(key);
        oOut.close();
        ObjectInputStream oIn = new ObjectInputStream(new ByteArrayInputStream(bOut.toByteArray()));
        Key rk = (Key)oIn.readObject();
        this.checkEquals(algorithm, key, rk);
    }

    private void x448AgreementTest() throws Exception {
        this.agreementTest("X448");
    }

    private void x25519AgreementTest() throws Exception {
        this.agreementTest("X25519");
    }

    private void x448withCKDFTest() throws Exception {
        this.agreementTest("X448withSHA256CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
        this.agreementTest("X448withSHA384CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
        this.agreementTest("X448withSHA512CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
    }

    private void x25519withCKDFTest() throws Exception {
        this.agreementTest("X25519withSHA256CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
        this.agreementTest("X25519withSHA384CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
        this.agreementTest("X25519withSHA512CKDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
    }

    private void x448withKDFTest() throws Exception {
        this.agreementTest("X448withSHA512KDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
    }

    private void x25519withKDFTest() throws Exception {
        this.agreementTest("X25519withSHA256KDF", (AlgorithmParameterSpec)new UserKeyingMaterialSpec(Hex.decode((String)"beeffeed")));
    }

    private void ed448SignatureTest() throws Exception {
        this.signatureTest("Ed448");
    }

    private void ed25519SignatureTest() throws Exception {
        this.signatureTest("Ed25519");
    }

    private void agreementTest(String algorithm) throws Exception {
        this.agreementTest(algorithm, null);
    }

    private void agreementTest(String algorithm, AlgorithmParameterSpec spec) throws Exception {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(algorithm, "BC");
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm.startsWith("X448") ? "X448" : "X25519", "BC");
        KeyPair kp1 = kpGen.generateKeyPair();
        KeyPair kp2 = kpGen.generateKeyPair();
        keyAgreement.init(kp1.getPrivate());
        keyAgreement.doPhase(kp2.getPublic(), true);
        byte[] sec1 = keyAgreement.generateSecret();
        keyAgreement.init(kp2.getPrivate());
        keyAgreement.doPhase(kp1.getPublic(), true);
        byte[] sec2 = keyAgreement.generateSecret();
        this.isTrue(this.areEqual(sec1, sec2));
        if (spec != null) {
            keyAgreement.init((Key)kp1.getPrivate(), spec);
            keyAgreement.doPhase(kp2.getPublic(), true);
            byte[] sec3 = keyAgreement.generateSecret();
            keyAgreement.init((Key)kp2.getPrivate(), spec);
            keyAgreement.doPhase(kp1.getPublic(), true);
            byte[] sec4 = keyAgreement.generateSecret();
            this.isTrue(this.areEqual(sec3, sec4));
            this.isTrue(!this.areEqual(sec1, sec4));
        }
    }

    private void x448UwithKDFTest() throws Exception {
        this.unifiedAgreementTest("X448UwithSHA512KDF");
    }

    private void x25519UwithKDFTest() throws Exception {
        this.unifiedAgreementTest("X25519UwithSHA256KDF");
    }

    private void unifiedAgreementTest(String algorithm) throws Exception {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(algorithm, "BC");
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm.startsWith("X448") ? "X448" : "X25519", "BC");
        KeyPair aKp1 = kpGen.generateKeyPair();
        KeyPair aKp2 = kpGen.generateKeyPair();
        KeyPair bKp1 = kpGen.generateKeyPair();
        KeyPair bKp2 = kpGen.generateKeyPair();
        keyAgreement.init((Key)aKp1.getPrivate(), (AlgorithmParameterSpec)new DHUParameterSpec(aKp2, bKp2.getPublic(), Hex.decode((String)"beeffeed")));
        keyAgreement.doPhase(bKp1.getPublic(), true);
        byte[] sec1 = keyAgreement.generateSecret();
        keyAgreement.init((Key)bKp1.getPrivate(), (AlgorithmParameterSpec)new DHUParameterSpec(aKp2, bKp2.getPublic(), Hex.decode((String)"beeffeed")));
        keyAgreement.doPhase(aKp1.getPublic(), true);
        byte[] sec2 = keyAgreement.generateSecret();
        this.isTrue(this.areEqual(sec1, sec2));
        keyAgreement.init((Key)bKp1.getPrivate(), (AlgorithmParameterSpec)new DHUParameterSpec(aKp2, bKp2.getPublic(), Hex.decode((String)"feed")));
        keyAgreement.doPhase(aKp1.getPublic(), true);
        byte[] sec3 = keyAgreement.generateSecret();
        this.isTrue(!this.areEqual(sec1, sec3));
    }

    private void signatureTest(String algorithm) throws Exception {
        byte[] msg = Strings.toByteArray((String)"Hello, world!");
        Signature signature = Signature.getInstance(algorithm, "BC");
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance(algorithm, "BC");
        KeyPair kp = kpGen.generateKeyPair();
        signature.initSign(kp.getPrivate());
        signature.update(msg);
        byte[] sig = signature.sign();
        signature.initVerify(kp.getPublic());
        signature.update(msg);
        this.isTrue(signature.verify(sig));
        signature.initSign(kp.getPrivate(), new SecureRandom());
        signature.update(msg);
        sig = signature.sign();
        signature.initVerify(kp.getPublic());
        signature.update(msg);
        this.isTrue(signature.verify(sig));
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new EdECTest());
    }
}

