/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.jcajce.provider.asymmetric.dh.IESCipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class DHIESTest
extends SimpleTest {
    BigInteger p1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    BigInteger g1024 = new BigInteger("2", 16);
    BigInteger p2048 = new BigInteger("95475cf5d93e596c3fcd1d902add02f427f5f3c7210313bb45fb4d5bb2e5fe1cbd678cd4bbdd84c9836be1f31c0777725aeb6c2fc38b85f48076fa76bcd8146cc89a6fb2f706dd719898c2083dc8d896f84062e2c9c94d137b054a8d8096adb8d51952398eeca852a0af12df83e475aa65d4ec0c38a9560d5661186ff98b9fc9eb60eee8b030376b236bc73be3acdbd74fd61c1d2475fa3077b8f080467881ff7e1ca56fee066d79506ade51edbb5443a563927dbc4ba520086746175c8885925ebc64c6147906773496990cb714ec667304e261faee33b3cbdf008e0c3fa90650d97d3909c9275bf4ac86ffcb3d03e6dfc8ada5934242dd6d3bcca2a406cb0b", 16);
    BigInteger g2048 = new BigInteger("42debb9da5b3d88cc956e08787ec3f3a09bba5f48b889a74aaf53174aa0fbe7e3c5b8fcd7a53bef563b0e98560328960a9517f4014d3325fc7962bf1e049370d76d1314a76137e792f3f0db859d095e4a5b932024f079ecf2ef09c797452b0770e1350782ed57ddf794979dcef23cb96f183061965c4ebc93c9c71c56b925955a75f94cccf1449ac43d586d0beee43251b0b2287349d68de0d144403f13e802f4146d882e057af19b6f6275c6676c8fa0e3ca2713a3257fd1b27d0639f695e347d8d1cf9ac819a26ca9b04cb0eb9b7b035988d15bbac65212a55239cfc7e58fae38d7250ab9991ffbc97134025fe8ce04c4399ad96569be91a546f4978693c7a", 16);
    DHParameterSpec param1024 = new DHParameterSpec(this.p1024, this.g1024);
    DHParameterSpec param2048 = new DHParameterSpec(this.p2048, this.g2048);

    DHIESTest() {
    }

    public String getName() {
        return "DHIES";
    }

    public void performTest() throws Exception {
        byte[] derivation = Hex.decode((String)"202122232425262728292a2b2c2d2e2f");
        byte[] encoding = Hex.decode((String)"303132333435363738393a3b3c3d3e3f");
        IESCipher.IES c1 = new IESCipher.IES();
        IESCipher.IES c2 = new IESCipher.IES();
        IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128);
        KeyPairGenerator g = KeyPairGenerator.getInstance("DH", "BC");
        KeyPairGenerator g512 = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(this.param1024);
        this.doTest("DHIES with default", g, "DHIES", params);
        g512.initialize(512, new SecureRandom());
        this.doTest("DHIES with 512-bit", g512, "DHIES", params);
        g.initialize(this.param1024, new SecureRandom());
        this.doTest("DHIES with 1024-bit", g, "DHIES", params);
        c1 = new IESCipher(new IESEngine((BasicAgreement)new DHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)new DESEngine())));
        c2 = new IESCipher(new IESEngine((BasicAgreement)new DHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new SHA1Digest()), (Mac)new HMac((Digest)new SHA1Digest()), (BufferedBlockCipher)new PaddedBufferedBlockCipher((BlockCipher)new DESEngine())));
        params = new IESParameterSpec(derivation, encoding, 128, 192, Hex.decode((String)"0001020304050607"));
        g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(this.param2048, new SecureRandom());
        this.doTest("DHIESwithDES default", g, "DHIESwithDESEDE-CBC", params);
        this.doTest("DHIESwithDES 512-bit", g512, "DHIESwithDESEDE-CBC", params);
        g.initialize(this.param1024, new SecureRandom());
        this.doTest("DHIESwithDES 1024-bit", g, "DHIESwithDESEDE-CBC", params);
        g = KeyPairGenerator.getInstance("DH", "BC");
        g.initialize(this.param1024);
        c1 = new IESCipher.IESwithAESCBC();
        c2 = new IESCipher.IESwithAESCBC();
        params = new IESParameterSpec(derivation, encoding, 128, 128, Hex.decode((String)"00010203040506070001020304050607"));
        this.doTest("DHIESwithAES default", g, "DHIESwithAES-CBC", params);
        this.doTest("DHIESwithAES 512-bit", g512, "DHIESwithAES-CBC", params);
        g.initialize(this.param1024, new SecureRandom());
        this.doTest("DHIESwithAES 1024-bit", g, "DHIESwithAES-CBC", params);
        KeyPair keyPair = g.generateKeyPair();
        DHPublicKey pub = (DHPublicKey)keyPair.getPublic();
        DHPrivateKey priv = (DHPrivateKey)keyPair.getPrivate();
        Cipher c = Cipher.getInstance("DHIESwithAES-CBC", "BC");
        try {
            c.init(1, (Key)pub, (AlgorithmParameterSpec)new IESParameterSpec(derivation, encoding, 128, 128, null));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
        }
        try {
            c.init(2, priv);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isTrue("message ", "cannot handle supplied parameter spec: must be passed IES parameters".equals(e.getMessage()));
        }
        try {
            c.init(2, (Key)priv, (AlgorithmParameterSpec)new IESParameterSpec(derivation, encoding, 128, 128, null));
            this.fail("no exception");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("message ", "NONCE in IES Parameters needs to be 16 bytes long".equals(e.getMessage()));
        }
    }

    public void doTest(String testname, KeyPairGenerator g, String cipher, IESParameterSpec p) throws Exception {
        byte[] message = Hex.decode((String)"0102030405060708090a0b0c0d0e0f10111213141516");
        Cipher c1 = Cipher.getInstance(cipher, "BC");
        Cipher c2 = Cipher.getInstance(cipher, "BC");
        KeyPair keyPair = g.generateKeyPair();
        DHPublicKey pub = (DHPublicKey)keyPair.getPublic();
        DHPrivateKey priv = (DHPrivateKey)keyPair.getPrivate();
        c1.init(1, (Key)pub, (AlgorithmParameterSpec)p, new SecureRandom());
        c2.init(2, (Key)priv, (AlgorithmParameterSpec)p);
        byte[] out1 = c1.doFinal(message, 0, message.length);
        byte[] out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode false.");
        }
        c1 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c2 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c1.init(1, (Key)pub, (AlgorithmParameterSpec)p, new SecureRandom());
        c2.init(2, (Key)priv, (AlgorithmParameterSpec)p, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode true.");
        }
        byte[] tmp = new byte[out1.length];
        int i = 0;
        while (i != out1.length) {
            System.arraycopy(out1, 0, tmp, 0, tmp.length);
            tmp[i] = ~tmp[i];
            try {
                c2.doFinal(tmp, 0, tmp.length);
                this.fail("decrypted corrupted data");
            }
            catch (BadPaddingException e) {
                this.isTrue("wrong message: " + e.getMessage(), "unable to process block".equals(e.getMessage()));
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new DHIESTest());
    }
}

