/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.io.InvalidCipherTextIOException;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.test.SimpleTest;

public class CipherStreamTest2
extends SimpleTest {
    private int streamSize;

    public String getName() {
        return "CipherStreamTest2";
    }

    private void testModes(String algo, String[] transforms, boolean authenticated) throws Exception {
        Key key = CipherStreamTest2.generateKey(algo);
        int i = 0;
        while (i != transforms.length) {
            boolean cts;
            String transform = transforms[i];
            String cipherName = algo + transform;
            boolean bl = cts = transform.indexOf("CTS") > -1;
            if (!cts || this.streamSize >= Cipher.getInstance(cipherName, "BC").getBlockSize()) {
                this.testWriteRead(cipherName, key, authenticated, true, false);
                this.testWriteRead(cipherName, key, authenticated, true, true);
                this.testWriteRead(cipherName, key, authenticated, false, false);
                this.testWriteRead(cipherName, key, authenticated, false, true);
                this.testReadWrite(cipherName, key, authenticated, true, false);
                this.testReadWrite(cipherName, key, authenticated, true, true);
                this.testReadWrite(cipherName, key, authenticated, false, false);
                this.testReadWrite(cipherName, key, authenticated, false, true);
                if (!cts) {
                    this.testWriteReadEmpty(cipherName, key, authenticated, true, false);
                    this.testWriteReadEmpty(cipherName, key, authenticated, true, true);
                    this.testWriteReadEmpty(cipherName, key, authenticated, false, false);
                    this.testWriteReadEmpty(cipherName, key, authenticated, false, true);
                }
                if (authenticated) {
                    boolean aeadAvailable = false;
                    try {
                        this.getClass().getClassLoader().loadClass("javax.crypto.spec.GCMParameterSpec");
                        aeadAvailable = true;
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    this.testTamperedRead(cipherName, key, true, true);
                    this.testTruncatedRead(cipherName, key, true, true);
                    this.testTamperedWrite(cipherName, key, true, true);
                    if (aeadAvailable) {
                        this.testTamperedRead(cipherName, key, true, false);
                        this.testTruncatedRead(cipherName, key, true, false);
                        this.testTamperedWrite(cipherName, key, true, false);
                    }
                }
            }
            ++i;
        }
    }

    private InputStream createInputStream(byte[] data, Cipher cipher, boolean useBc) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(data);
        return useBc ? new CipherInputStream((InputStream)bytes, cipher) : new javax.crypto.CipherInputStream(bytes, cipher);
    }

    private OutputStream createOutputStream(ByteArrayOutputStream bytes, Cipher cipher, boolean useBc) {
        return useBc ? new CipherOutputStream((OutputStream)bytes, cipher) : new javax.crypto.CipherOutputStream(bytes, cipher);
    }

    private void testTamperedRead(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        Cipher encrypt = Cipher.getInstance(name, "BC");
        Cipher decrypt = Cipher.getInstance(name, "BC");
        encrypt.init(1, key);
        if (encrypt.getIV() != null) {
            decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
        } else {
            decrypt.init(2, key);
        }
        byte[] ciphertext = encrypt.doFinal(new byte[this.streamSize]);
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        InputStream input = this.createInputStream(ciphertext, decrypt, useBc);
        try {
            while (input.read() >= 0) {
            }
            this.fail("Expected invalid ciphertext after tamper and read : " + name, authenticated, useBc);
        }
        catch (InvalidCipherTextIOException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception : " + name, e, authenticated, useBc);
        }
    }

    private void testTruncatedRead(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        InputStream input;
        block9: {
            int read;
            Cipher encrypt = Cipher.getInstance(name, "BC");
            Cipher decrypt = Cipher.getInstance(name, "BC");
            encrypt.init(1, key);
            if (encrypt.getIV() != null) {
                decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
            } else {
                decrypt.init(2, key);
            }
            byte[] ciphertext = encrypt.doFinal(new byte[this.streamSize]);
            byte[] truncated = new byte[ciphertext.length - this.streamSize - 1];
            System.arraycopy(ciphertext, 0, truncated, 0, truncated.length);
            ciphertext[0] = (byte)(ciphertext[0] + 1);
            input = this.createInputStream(truncated, decrypt, useBc);
            do {
                read = 0;
                try {
                    read = input.read();
                }
                catch (InvalidCipherTextIOException e) {
                    break block9;
                }
                catch (IOException e) {
                    break block9;
                }
                catch (Exception e) {
                    this.fail("Unexpected exception : " + name, e, authenticated, useBc);
                    break block9;
                }
            } while (read >= 0);
            this.fail("Expected invalid ciphertext after truncate and read : " + name, authenticated, useBc);
        }
        try {
            input.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception : " + name, e, authenticated, useBc);
        }
    }

    private void testTamperedWrite(String name, Key key, boolean authenticated, boolean useBc) throws Exception {
        Cipher encrypt = Cipher.getInstance(name, "BC");
        Cipher decrypt = Cipher.getInstance(name, "BC");
        encrypt.init(1, key);
        if (encrypt.getIV() != null) {
            decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
        } else {
            decrypt.init(2, key);
        }
        byte[] ciphertext = encrypt.doFinal(new byte[this.streamSize]);
        ciphertext[0] = (byte)(ciphertext[0] + 1);
        ByteArrayOutputStream plaintext = new ByteArrayOutputStream();
        OutputStream output = this.createOutputStream(plaintext, decrypt, useBc);
        int i = 0;
        while (i < ciphertext.length) {
            output.write(ciphertext[i]);
            ++i;
        }
        try {
            output.close();
            this.fail("Expected invalid ciphertext after tamper and write : " + name, authenticated, useBc);
        }
        catch (InvalidCipherTextIOException e) {
            // empty catch block
        }
    }

    private void testWriteRead(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        byte[] data = new byte[this.streamSize];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)(i % 255);
            ++i;
        }
        this.testWriteRead(name, key, authenticated, useBc, blocks, data);
    }

    private void testWriteReadEmpty(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        byte[] data = new byte[]{};
        this.testWriteRead(name, key, authenticated, useBc, blocks, data);
    }

    /*
     * Unable to fully structure code
     */
    private void testWriteRead(String name, Key key, boolean authenticated, boolean useBc, boolean blocks, byte[] data) {
        bOut = new ByteArrayOutputStream();
        try {
            block11: {
                encrypt = Cipher.getInstance(name, "BC");
                decrypt = Cipher.getInstance(name, "BC");
                encrypt.init(1, key);
                if (encrypt.getIV() != null) {
                    decrypt.init(2, key, new IvParameterSpec(encrypt.getIV()));
                } else {
                    decrypt.init(2, key);
                }
                cOut = this.createOutputStream(bOut, encrypt, useBc);
                if (blocks) {
                    chunkSize = Math.max(1, data.length / 8);
                    i = 0;
                    while (i < data.length) {
                        cOut.write(data, i, Math.min(chunkSize, data.length - i));
                        i += chunkSize;
                    }
                } else {
                    i = 0;
                    while (i < data.length) {
                        cOut.write(data[i]);
                        ++i;
                    }
                }
                cOut.close();
                cipherText = bOut.toByteArray();
                bOut.reset();
                cIn = this.createInputStream(cipherText, decrypt, useBc);
                if (!blocks) ** GOTO lbl35
                block = new byte[encrypt.getBlockSize() + 1];
                while ((c = cIn.read(block)) >= 0) {
                    bOut.write(block, 0, (int)var14_18);
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    bOut.write((int)block);
lbl35:
                    // 2 sources

                    ** while ((c = cIn.read()) >= 0)
                }
            }
            cIn.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + name, e, authenticated, useBc);
        }
        decrypted = bOut.toByteArray();
        if (!Arrays.areEqual((byte[])data, (byte[])decrypted)) {
            this.fail("Failed - decrypted data doesn't match: " + name, authenticated, useBc);
        }
    }

    protected void fail(String message, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message);
        }
    }

    protected void fail(String message, Throwable throwable, boolean authenticated, boolean bc) {
        if (bc || !authenticated) {
            super.fail(message, throwable);
        } else {
            throwable.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testReadWrite(String name, Key key, boolean authenticated, boolean useBc, boolean blocks) throws Exception {
        lCode = "ABCDEFGHIJKLMNOPQRSTU";
        bOut = new ByteArrayOutputStream();
        try {
            block7: {
                in = Cipher.getInstance(name, "BC");
                out = Cipher.getInstance(name, "BC");
                in.init(1, key);
                if (in.getIV() != null) {
                    out.init(2, key, new IvParameterSpec(in.getIV()));
                } else {
                    out.init(2, key);
                }
                cIn = this.createInputStream(lCode.getBytes(), in, useBc);
                cOut = this.createOutputStream(bOut, out, useBc);
                if (!blocks) ** GOTO lbl20
                block = new byte[in.getBlockSize() + 1];
                while ((c = cIn.read(block)) >= 0) {
                    cOut.write(block, 0, (int)var13_15);
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    cOut.write((int)block);
lbl20:
                    // 2 sources

                    ** while ((c = cIn.read()) >= 0)
                }
            }
            cIn.close();
            cOut.flush();
            cOut.close();
        }
        catch (Exception e) {
            this.fail("Unexpected exception " + name, e, authenticated, useBc);
        }
        res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed - decrypted data doesn't match: " + name, authenticated, useBc);
        }
    }

    private static Key generateKey(String name) throws Exception {
        KeyGenerator kGen = name.indexOf(47) < 0 ? KeyGenerator.getInstance(name, "BC") : KeyGenerator.getInstance(name.substring(0, name.indexOf(47)), "BC");
        return kGen.generateKey();
    }

    public void performTest() throws Exception {
        int[] testSizes = new int[]{0, 1, 7, 8, 9, 15, 16, 17, 1023, 1024, 1025, 2047, 2048, 2049, 4095, 4096, 4097};
        int i = 0;
        while (i < testSizes.length) {
            this.streamSize = testSizes[i];
            this.performTests();
            ++i;
        }
    }

    private void performTests() throws Exception {
        String[] blockCiphers64 = new String[]{"BLOWFISH", "DES", "DESEDE", "TEA", "CAST5", "RC2", "XTEA"};
        int i = 0;
        while (i != blockCiphers64.length) {
            this.testModes(blockCiphers64[i], new String[]{"/ECB/PKCS5Padding", "/CBC/PKCS5Padding", "/OFB/NoPadding", "/CFB/NoPadding", "/CTS/NoPadding"}, false);
            this.testModes(blockCiphers64[i], new String[]{"/EAX/NoPadding"}, true);
            ++i;
        }
        String[] blockCiphers128 = new String[]{"AES", "NOEKEON", "Twofish", "CAST6", "SEED", "Serpent", "RC6", "CAMELLIA"};
        int i2 = 0;
        while (i2 != blockCiphers128.length) {
            this.testModes(blockCiphers128[i2], new String[]{"/ECB/PKCS5Padding", "/CBC/PKCS5Padding", "/OFB/NoPadding", "/CFB/NoPadding", "/CTS/NoPadding", "/CTR/NoPadding", "/SIC/NoPadding"}, false);
            String jvm = System.getProperty("java.version");
            if (jvm.length() > 2 && (jvm.charAt(2) == '5' || jvm.charAt(2) == '6')) {
                this.testModes(blockCiphers128[i2], new String[]{"/CCM/NoPadding", "/EAX/NoPadding", "/OCB/NoPadding"}, true);
            } else {
                this.testModes(blockCiphers128[i2], new String[]{"/CCM/NoPadding", "/EAX/NoPadding", "/GCM/NoPadding", "/OCB/NoPadding"}, true);
            }
            ++i2;
        }
        String[] streamCiphers = new String[]{"ARC4", "SALSA20", "XSalsa20", "ChaCha", "ChaCha7539", "Grainv1", "Grain128", "HC128", "HC256"};
        int i3 = 0;
        while (i3 != streamCiphers.length) {
            this.testModes(streamCiphers[i3], new String[]{""}, false);
            ++i3;
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new CipherStreamTest2());
    }
}

