/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestFailedException;

public class CipherStreamTest
extends SimpleTest {
    private static byte[] RK = Hex.decode((String)"0123456789ABCDEF");
    private static byte[] RIN = Hex.decode((String)"4e6f772069732074");
    private static byte[] ROUT = Hex.decode((String)"3afbb5c77938280d");
    private static byte[] SIN = Hex.decode((String)"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] SK = Hex.decode((String)"80000000000000000000000000000000");
    private static final byte[] SIV = Hex.decode((String)"0000000000000000");
    private static final byte[] SOUT = Hex.decode((String)"4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA");
    private static final byte[] XSK = Hex.decode((String)"d5c7f6797b7e7e9c1d7fd2610b2abf2bc5a7885fb3ff78092fb3abe8986d35e2");
    private static final byte[] XSIV = Hex.decode((String)"744e17312b27969d826444640e9c4a378ae334f185369c95");
    private static final byte[] XSIN = Hex.decode((String)"7758298c628eb3a4b6963c5445ef66971222be5d1a4ad839715d1188071739b77cc6e05d5410f963a64167629757");
    private static final byte[] XSOUT = Hex.decode((String)"27b8cfe81416a76301fd1eec6a4d99675069b2da2776c360db1bdfea7c0aa613913e10f7a60fec04d11e65f2d64e");
    private static final byte[] CHAK = Hex.decode((String)"80000000000000000000000000000000");
    private static final byte[] CHAIV = Hex.decode((String)"0000000000000000");
    private static final byte[] CHAIN = Hex.decode((String)"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] CHAOUT = Hex.decode((String)"FBB87FBB8395E05DAA3B1D683C422046F913985C2AD9B23CFC06C1D8D04FF213D44A7A7CDB84929F915420A8A3DC58BF0F7ECB4B1F167BB1A5E6153FDAF4493D");
    private static final byte[] CHA7539K = Hex.decode((String)"8000000000000000000000000000000080000000000000000000000000000000");
    private static final byte[] CHA7539IV = Hex.decode((String)"000000000000000000000000");
    private static final byte[] CHA7539IN = Hex.decode((String)"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    private static final byte[] CHA7539OUT = Hex.decode((String)"aef50e541e12a65dc21e90ebb4c03987971c540f78eb536df692ff89fc47561ed17eb23b63eb714c09d0c50af703e01485926c140e994b3edff9df635a91d268");
    private static final byte[] HCIN = new byte[64];
    private static final byte[] HC128IV = new byte[16];
    private static final byte[] HC256IV = new byte[32];
    private static final byte[] HCK256A = new byte[32];
    private static final byte[] HC256A = Hex.decode((String)"5B078985D8F6F30D42C5C02FA6B6795153F06534801F89F24E74248B720B4818CD9227ECEBCF4DBF8DBF6977E4AE14FAE8504C7BC8A9F3EA6C0106F5327E6981");
    private static final byte[] HCK128A = new byte[16];
    private static final byte[] HC128A = Hex.decode((String)"82001573A003FD3B7FD72FFB0EAF63AAC62F12DEB629DCA72785A66268EC758B1EDB36900560898178E0AD009ABF1F491330DC1C246E3D6CB264F6900271D59C");
    private static final byte[] GRAIN_V1 = Hex.decode((String)"0123456789abcdef1234");
    private static final byte[] GRAIN_V1_IV = Hex.decode((String)"0123456789abcdef");
    private static final byte[] GRAIN_V1_IN = new byte[10];
    private static final byte[] GRAIN_V1_OUT = Hex.decode((String)"7f362bd3f7abae203664");
    private static final byte[] GRAIN_128 = Hex.decode((String)"0123456789abcdef123456789abcdef0");
    private static final byte[] GRAIN_128_IV = Hex.decode((String)"0123456789abcdef12345678");
    private static final byte[] GRAIN_128_IN = new byte[16];
    private static final byte[] GRAIN_128_OUT = Hex.decode((String)"afb5babfa8de896b4b9c6acaf7c4fbfd");
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    /*
     * WARNING - void declaration
     */
    private void runTest(String name) throws Exception {
        int c;
        String lCode = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        KeyGenerator kGen = name.indexOf(47) < 0 ? KeyGenerator.getInstance(name, "BC") : KeyGenerator.getInstance(name.substring(0, name.indexOf(47)), "BC");
        byte[] data = lCode.getBytes();
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        SecretKey key = kGen.generateKey();
        ByteArrayInputStream bIn = new ByteArrayInputStream(data);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        in.init(1, key);
        if (in.getIV() != null) {
            out.init(2, (Key)key, new IvParameterSpec(in.getIV()));
        } else {
            out.init(2, key);
        }
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        while ((c = cIn.read()) >= 0) {
            void var12_12;
            cOut.write((int)var12_12);
        }
        cIn.close();
        cOut.flush();
        cOut.close();
        String res = new String(bOut.toByteArray());
        if (!res.equals(lCode)) {
            this.fail("Failed - decrypted data doesn't match.");
        }
        try {
            byte[] enc = in.doFinal(data);
            byte[] out1 = new byte[enc.length / 2];
            try {
                out.doFinal(enc, 0, enc.length, out1, 0);
                this.fail("ShortBufferException not triggered");
            }
            catch (ShortBufferException e) {
                byte[] out2 = new byte[in.getOutputSize(enc.length)];
                int count = out.doFinal(enc, 0, enc.length, out2, 0);
                if (!this.areEqual(out2, count, data)) {
                    this.fail("" + name + " failed decryption - expected " + new String(Hex.encode((byte[])data)) + " got " + new String(Hex.encode((byte[])out2)));
                }
            }
        }
        catch (TestFailedException e) {
            throw e;
        }
        catch (Exception e) {
            this.fail("" + name + " failed short buffer decryption - " + e.toString());
        }
        if (name.indexOf(47) < 0) {
            Cipher.getInstance(name + "/NONE/NoPadding");
            Cipher.getInstance(name + "/ECB/NoPadding");
        }
    }

    private boolean areEqual(byte[] a, int aLen, byte[] b) {
        if (b.length != aLen) {
            return false;
        }
        int i = 0;
        while (i != aLen) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void testAlgorithm(String name, byte[] keyBytes, byte[] iv, byte[] plainText, byte[] cipherText) throws Exception {
        byte[] dec;
        byte[] enc;
        SecretKeySpec key = new SecretKeySpec(keyBytes, name);
        Cipher in = Cipher.getInstance(name, "BC");
        Cipher out = Cipher.getInstance(name, "BC");
        if (iv != null) {
            in.init(1, (Key)key, new IvParameterSpec(iv));
            out.init(2, (Key)key, new IvParameterSpec(iv));
        } else {
            in.init(1, key);
            out.init(2, key);
        }
        if (iv != null) {
            this.isTrue(Arrays.areEqual((byte[])iv, (byte[])in.getIV()));
            this.isTrue(Arrays.areEqual((byte[])iv, (byte[])out.getIV()));
            AlgorithmParameters algParams = in.getParameters();
            this.isTrue(Arrays.areEqual((byte[])iv, (byte[])((IvParameterSpec)algParams.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = CipherStreamTest.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)).getIV()));
            algParams = out.getParameters();
            this.isTrue(Arrays.areEqual((byte[])iv, (byte[])((IvParameterSpec)algParams.getParameterSpec(class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = CipherStreamTest.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)).getIV()));
        }
        if (!this.areEqual(enc = in.doFinal(plainText), cipherText)) {
            this.fail(name + ": cipher text doesn't match got " + new String(Hex.encode((byte[])enc)));
        }
        if (!this.areEqual(dec = out.doFinal(enc), plainText)) {
            this.fail(name + ": plain text doesn't match");
        }
    }

    private void testException(String name) {
        try {
            Key k;
            Cipher c;
            byte[] key128 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] key256 = new byte[]{-128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113, -128, -125, -123, -122, -119, -118, -116, -113};
            byte[] keyBytes = name.equals("HC256") || name.equals("XSalsa20") || name.equals("ChaCha7539") || name.equals("ChaCha20") ? key256 : key128;
            SecretKeySpec cipherKey = new SecretKeySpec(keyBytes, name);
            Cipher ecipher = Cipher.getInstance(name, "BC");
            ecipher.init(1, cipherKey);
            byte[] cipherText = new byte[]{};
            try {
                ecipher.update(new byte[20], 0, 20, cipherText);
                this.fail("failed exception test - no ShortBufferException thrown");
            }
            catch (ShortBufferException e) {
                // empty catch block
            }
            try {
                c = Cipher.getInstance(name, "BC");
                k = new PublicKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c.init(1, k);
                this.fail("failed exception test - no InvalidKeyException thrown for public key");
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
            try {
                c = Cipher.getInstance(name, "BC");
                k = new PrivateKey(){

                    public String getAlgorithm() {
                        return "STUB";
                    }

                    public String getFormat() {
                        return null;
                    }

                    public byte[] getEncoded() {
                        return null;
                    }
                };
                c.init(2, k);
                this.fail("failed exception test - no InvalidKeyException thrown for private key");
            }
            catch (InvalidKeyException e) {}
        }
        catch (Exception e) {
            this.fail("unexpected exception.", e);
        }
    }

    public void performTest() throws Exception {
        this.runTest("RC4");
        this.testException("RC4");
        this.testAlgorithm("RC4", RK, null, RIN, ROUT);
        this.runTest("Salsa20");
        this.testException("Salsa20");
        this.testAlgorithm("Salsa20", SK, SIV, SIN, SOUT);
        this.runTest("XSalsa20");
        this.testException("XSalsa20");
        this.testAlgorithm("XSalsa20", XSK, XSIV, XSIN, XSOUT);
        this.runTest("ChaCha");
        this.testException("ChaCha");
        this.testAlgorithm("ChaCha", CHAK, CHAIV, CHAIN, CHAOUT);
        this.runTest("ChaCha7539");
        this.testException("ChaCha7539");
        this.testAlgorithm("ChaCha7539", CHA7539K, CHA7539IV, CHA7539IN, CHA7539OUT);
        this.runTest("ChaCha20");
        this.testException("ChaCha20");
        this.testAlgorithm("ChaCha20", CHA7539K, CHA7539IV, CHA7539IN, CHA7539OUT);
        this.runTest("HC128");
        this.testException("HC128");
        this.testAlgorithm("HC128", HCK128A, HC128IV, HCIN, HC128A);
        this.runTest("HC256");
        this.testException("HC256");
        this.testAlgorithm("HC256", HCK256A, HC256IV, HCIN, HC256A);
        this.runTest("VMPC");
        this.testException("VMPC");
        this.runTest("VMPC-KSA3");
        this.testException("VMPC-KSA3");
        this.testAlgorithm("Grainv1", GRAIN_V1, GRAIN_V1_IV, GRAIN_V1_IN, GRAIN_V1_OUT);
        this.testAlgorithm("Grain128", GRAIN_128, GRAIN_128_IV, GRAIN_128_IN, GRAIN_128_OUT);
        this.runTest("DES/ECB/PKCS7Padding");
        this.runTest("DES/CFB8/NoPadding");
    }

    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new CipherStreamTest());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

