/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.cert.CRLSelector;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertStoreTest
implements Test {
    public TestResult perform() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> list = new ArrayList<X509Extension>();
            list.add(rootCert);
            list.add(interCert);
            list.add(finalCert);
            list.add(rootCrl);
            list.add(interCrl);
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
            CertStore store = CertStore.getInstance((String)"Collection", (CertStoreParameters)ccsp, (String)"BC");
            X509CertSelector targetConstraints = new X509CertSelector();
            targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal((X509Certificate)rootCert).getName());
            Collection certs = store.getCertificates((CertSelector)targetConstraints);
            if (certs.size() != 1 || !certs.contains(rootCert)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by subjectDN");
            }
            targetConstraints = new X509CertSelector();
            targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal((X509Certificate)rootCert).getEncoded());
            certs = store.getCertificates((CertSelector)targetConstraints);
            if (certs.size() != 1 || !certs.contains(rootCert)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by encoded subjectDN");
            }
            targetConstraints = new X509CertSelector();
            targetConstraints.setSubjectPublicKey(rootCert.getPublicKey().getEncoded());
            certs = store.getCertificates((CertSelector)targetConstraints);
            if (certs.size() != 1 || !certs.contains(rootCert)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found by encoded public key");
            }
            targetConstraints = new X509CertSelector();
            targetConstraints.setIssuer(PrincipalUtil.getSubjectX509Principal((X509Certificate)rootCert).getEncoded());
            certs = store.getCertificates((CertSelector)targetConstraints);
            if (certs.size() != 2) {
                return new SimpleTestResult(false, this.getName() + ": did not found 2 certs");
            }
            if (!certs.contains(rootCert)) {
                return new SimpleTestResult(false, this.getName() + ": rootCert not found");
            }
            if (!certs.contains(interCert)) {
                return new SimpleTestResult(false, this.getName() + ": interCert not found");
            }
            X509CRLSelector targetConstraintsCRL = new X509CRLSelector();
            targetConstraintsCRL.addIssuerName(PrincipalUtil.getIssuerX509Principal((X509CRL)rootCrl).getEncoded());
            Collection crls = store.getCRLs((CRLSelector)targetConstraintsCRL);
            if (crls.size() != 1 || !crls.contains(rootCrl)) {
                return new SimpleTestResult(false, this.getName() + ": rootCrl not found");
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "CertStore";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertStoreTest test = new CertStoreTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

