/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathBuilder;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreParameters;
import org.bouncycastle.jce.cert.CertificateFactory;
import org.bouncycastle.jce.cert.CollectionCertStoreParameters;
import org.bouncycastle.jce.cert.PKIXBuilderParameters;
import org.bouncycastle.jce.cert.PKIXCertPathBuilderResult;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.jce.provider.test.TestCertificateGen;
import org.bouncycastle.jce.provider.test.TestUtils;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class CertPathBuilderTest
implements Test {
    public TestResult baseTest() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance((String)"X.509", (String)"BC");
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.rootCertBin));
            X509Certificate interCert = (X509Certificate)cf.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.interCertBin));
            X509Certificate finalCert = (X509Certificate)cf.generateCertificate((InputStream)new ByteArrayInputStream(CertPathTest.finalCertBin));
            X509CRL rootCrl = (X509CRL)cf.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.rootCrlBin));
            X509CRL interCrl = (X509CRL)cf.generateCRL((InputStream)new ByteArrayInputStream(CertPathTest.interCrlBin));
            ArrayList<X509Extension> list = new ArrayList<X509Extension>();
            list.add(rootCert);
            list.add(interCert);
            list.add(finalCert);
            list.add(rootCrl);
            list.add(interCrl);
            CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
            CertStore store = CertStore.getInstance((String)"Collection", (CertStoreParameters)ccsp, (String)"BC");
            Calendar validDate = Calendar.getInstance();
            validDate.set(2002, 2, 21, 2, 21, 10);
            HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
            trust.add(new TrustAnchor(rootCert, null));
            CertPathBuilder cpb = CertPathBuilder.getInstance((String)"PKIX", (String)"BC");
            X509CertSelector targetConstraints = new X509CertSelector();
            targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal((X509Certificate)finalCert).getEncoded());
            PKIXBuilderParameters params = new PKIXBuilderParameters(trust, (CertSelector)targetConstraints);
            params.addCertStore(store);
            params.setDate(validDate.getTime());
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)cpb.build((CertPathParameters)params);
            CertPath path = result.getCertPath();
            if (path.getCertificates().size() != 2) {
                return new SimpleTestResult(false, this.getName() + ": wrong number of certs in baseTest path");
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult v0Test() {
        try {
            KeyPair rootPair = TestUtils.generateRSAKeyPair();
            KeyPair interPair = TestUtils.generateRSAKeyPair();
            KeyPair endPair = TestUtils.generateRSAKeyPair();
            X509Certificate rootCert = TestUtils.generateRootCert(rootPair);
            X509Certificate interCert = TestUtils.generateIntermediateCert(interPair.getPublic(), rootPair.getPrivate(), rootCert);
            X509Certificate endCert = TestUtils.generateEndEntityCert(endPair.getPublic(), interPair.getPrivate(), interCert);
            BigInteger revokedSerialNumber = BigInteger.valueOf(2L);
            X509CRL rootCRL = TestCertificateGen.createCRL(rootCert, rootPair.getPrivate(), revokedSerialNumber);
            X509CRL interCRL = TestCertificateGen.createCRL(interCert, interPair.getPrivate(), revokedSerialNumber);
            ArrayList<X509Extension> list = new ArrayList<X509Extension>();
            list.add(rootCert);
            list.add(interCert);
            list.add(endCert);
            list.add(rootCRL);
            list.add(interCRL);
            CollectionCertStoreParameters params = new CollectionCertStoreParameters(list);
            CertStore store = CertStore.getInstance((String)"Collection", (CertStoreParameters)params);
            CertPathBuilder builder = CertPathBuilder.getInstance((String)"PKIX", (String)"BC");
            X509CertSelector pathConstraints = new X509CertSelector();
            pathConstraints.setSubject(PrincipalUtil.getSubjectX509Principal((X509Certificate)endCert).getEncoded());
            PKIXBuilderParameters buildParams = new PKIXBuilderParameters(Collections.singleton(new TrustAnchor(rootCert, null)), (CertSelector)pathConstraints);
            buildParams.addCertStore(store);
            buildParams.setDate(new Date());
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build((CertPathParameters)buildParams);
            CertPath path = result.getCertPath();
            if (path.getCertificates().size() != 2) {
                return new SimpleTestResult(false, this.getName() + ": wrong number of certs in v0Test path");
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        TestResult res = this.baseTest();
        if (!res.isSuccessful()) {
            return res;
        }
        return this.v0Test();
    }

    public String getName() {
        return "CertPathBuilder";
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertPathBuilderTest test = new CertPathBuilderTest();
        TestResult result = test.perform();
        System.out.println(result.toString());
    }
}

