/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.BaseBlockCipherTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestRandomData;

public class AESTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "69c4e0d86a7b0430d8cdb78070b4c55a", "192", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "dda97ca4864cdfe06eaf70a0ec0d7191", "256", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "8ea2b7ca516745bfeafc49904b496089"};

    public AESTest() {
        super("AES");
    }

    private void test(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher in = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("AES failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("AES failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("AES failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("AES failed encryption - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("AES failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("AES failed decryption - expected " + new String(Hex.encode((byte[])input)) + " got " + new String(Hex.encode((byte[])bytes)));
        }
    }

    private void eaxTest() throws Exception {
        byte[] K = Hex.decode((String)"233952DEE4D5ED5F9B9C6D6FF80FF478");
        byte[] N = Hex.decode((String)"62EC67F9C3A4A407FCB2A8C49031A8B3");
        byte[] P = Hex.decode((String)"68656c6c6f20776f726c642121");
        byte[] C = Hex.decode((String)"2f9f76cb7659c70e4be11670a3e193ae1bc6b5762a");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        Cipher in = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C)) {
            this.fail("ciphertext doesn't match in EAX");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in EAX");
        }
        try {
            in = Cipher.getInstance("AES/EAX/PKCS5Padding", "BC");
            this.fail("bad padding missed in EAX");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void ccmTest() throws Exception {
        byte[] K = Hex.decode((String)"404142434445464748494a4b4c4d4e4f");
        byte[] N = Hex.decode((String)"10111213141516");
        byte[] P = Hex.decode((String)"68656c6c6f20776f726c642121");
        byte[] C = Hex.decode((String)"39264f148b54c456035de0a531c8344f46db12b388");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        Cipher in = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C)) {
            this.fail("ciphertext doesn't match in CCM");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in CCM");
        }
        try {
            in = Cipher.getInstance("AES/CCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in CCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void gcmTest() throws Exception {
        byte[] K = Hex.decode((String)"feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308");
        byte[] P = Hex.decode((String)"d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255");
        byte[] N = Hex.decode((String)"cafebabefacedbaddecaf888");
        String T = "b094dac5d93471bdec1a502270e3cc6c";
        byte[] C = Hex.decode((String)("522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662898015ad" + T));
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        Cipher in = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C)) {
            this.fail("ciphertext doesn't match in GCM");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in GCM");
        }
        try {
            in = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in GCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
        in = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        enc = in.doFinal(P);
        try {
            in.doFinal(P);
            this.fail("no exception on reuse");
        }
        catch (IllegalStateException e) {
            this.isTrue("wrong message", e.getMessage().equals("GCM cipher cannot be reused for encryption"));
        }
        try {
            in.init(1, (Key)key, new IvParameterSpec(N));
            this.fail("no exception on reuse");
        }
        catch (InvalidAlgorithmParameterException e) {
            this.isTrue("wrong message", e.getMessage().equals("cannot reuse nonce for GCM encryption"));
        }
        key = new SecretKeySpec(Hex.decode((String)"01000000000000000000000000000000"), "AES");
        N = Hex.decode((String)"030000000000000000000000");
        P = Hex.decode((String)"01000000000000000000000000000000020000000000000000000000000000000300000000000000000000000000000004000000000000000000000000000000");
        C = Hex.decode((String)"2433668f1058190f6d43e360f4f35cd8e475127cfca7028ea8ab5c20f7ab2af02516a2bdcbc08d521be37ff28c152bba36697f25b4cd169c6590d1dd39566d3f8a263dd317aa88d56bdf3936dba75bb8");
        in = Cipher.getInstance("AES/GCM-SIV/NoPadding", "BC");
        out = Cipher.getInstance("AES/GCM-SIV/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        enc = in.doFinal(P);
        if (!this.areEqual(enc, C)) {
            this.fail("ciphertext doesn't match in GCM-SIV");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        dec = out.doFinal(C);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in GCM-SIV");
        }
        try {
            in = Cipher.getInstance("AES/GCM-SIV/PKCS5Padding", "BC");
            this.fail("bad padding missed in GCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void gcmTestWithRandom() throws Exception {
        byte[] K = Hex.decode((String)"feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308");
        byte[] P = Hex.decode((String)"d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255");
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        Cipher in = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        in.init(1, (Key)key, (SecureRandom)new TestRandomData("d0effdb2ec15369ff27a02bff3f800ef"));
        byte[] enc = in.doFinal(P);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"d0effdb2ec15369ff27a02bf"), (byte[])in.getIV()));
        this.isEquals(12, in.getIV().length);
        out.init(2, (Key)key, new IvParameterSpec(in.getIV()));
        byte[] dec = out.doFinal(enc);
        this.isTrue("plaintext doesn't match in GCM", Arrays.areEqual((byte[])P, (byte[])dec));
        try {
            in = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in GCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void ocbTest() throws Exception {
        byte[] K = Hex.decode((String)"000102030405060708090A0B0C0D0E0F");
        byte[] P = Hex.decode((String)"000102030405060708090A0B0C0D0E0F");
        byte[] N = Hex.decode((String)"000102030405060708090A0B");
        String T = "4CBB3E4BD6B456AF";
        byte[] C = Hex.decode((String)("BEA5E8798DBE7110031C144DA0B2612213CC8B747807121A" + T));
        SecretKeySpec key = new SecretKeySpec(K, "AES");
        Cipher in = Cipher.getInstance("AES/OCB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/OCB/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C)) {
            this.fail("ciphertext doesn't match in OCB");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in OCB");
        }
        try {
            in = Cipher.getInstance("AES/OCB/PKCS5Padding", "BC");
            this.fail("bad padding missed in OCB");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    public void performTest() throws Exception {
        int i = 0;
        while (i != cipherTests.length) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode((String)cipherTests[i + 1]), Hex.decode((String)cipherTests[i + 2]), Hex.decode((String)cipherTests[i + 3]));
            i += 4;
        }
        byte[] kek1 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        byte[] in1 = Hex.decode((String)"00112233445566778899aabbccddeeff");
        byte[] out1 = Hex.decode((String)"1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5");
        this.wrapTest(1, "AESWrap", kek1, in1, out1);
        byte[] kek2 = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        byte[] in2 = Hex.decode((String)"00112233445566778899aabbccddeeff");
        byte[] out2 = Hex.decode((String)"7c8798dfc802553b3f00bb4315e3a087322725c92398b9c112c74d0925c63b61");
        this.wrapTest(2, "AESRFC3211WRAP", kek2, kek2, (SecureRandom)new FixedSecureRandom(Hex.decode((String)"9688df2af1b7b1ac9688df2a")), in2, out2);
        byte[] kek3 = Hex.decode((String)"5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] in3 = Hex.decode((String)"c37b7e6492584340bed12207808941155068f738");
        byte[] out3 = Hex.decode((String)"138bdeaa9b8fa7fc61f97742e72248ee5ae6ae5360d1ae6a5f54f373fa543b6a");
        this.wrapTest(3, "AESRFC5649WRAP", kek3, in3, out3);
        String[] oids = new String[]{NISTObjectIdentifiers.id_aes128_ECB.getId(), NISTObjectIdentifiers.id_aes128_CBC.getId(), NISTObjectIdentifiers.id_aes128_OFB.getId(), NISTObjectIdentifiers.id_aes128_CFB.getId(), NISTObjectIdentifiers.id_aes192_ECB.getId(), NISTObjectIdentifiers.id_aes192_CBC.getId(), NISTObjectIdentifiers.id_aes192_OFB.getId(), NISTObjectIdentifiers.id_aes192_CFB.getId(), NISTObjectIdentifiers.id_aes256_ECB.getId(), NISTObjectIdentifiers.id_aes256_CBC.getId(), NISTObjectIdentifiers.id_aes256_OFB.getId(), NISTObjectIdentifiers.id_aes256_CFB.getId()};
        String[] names = new String[]{"AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/NoPadding", "AES/CFB/NoPadding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/NoPadding", "AES/CFB/NoPadding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/NoPadding", "AES/CFB/NoPadding"};
        this.oidTest(oids, names, 4);
        String[] wrapOids = new String[]{NISTObjectIdentifiers.id_aes128_wrap.getId(), NISTObjectIdentifiers.id_aes192_wrap.getId(), NISTObjectIdentifiers.id_aes256_wrap.getId()};
        this.wrapOidTest(wrapOids, "AESWrap");
        wrapOids = new String[]{NISTObjectIdentifiers.id_aes128_wrap_pad.getId(), NISTObjectIdentifiers.id_aes192_wrap_pad.getId(), NISTObjectIdentifiers.id_aes256_wrap_pad.getId()};
        this.wrapOidTest(wrapOids, "AESWrapPad");
        this.eaxTest();
        this.ccmTest();
        this.gcmTest();
        this.gcmTestWithRandom();
        this.ocbTest();
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest(new AESTest());
    }
}

