/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.eac.test;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import org.bouncycastle.asn1.eac.CertificateHolderReference;
import org.bouncycastle.asn1.eac.CertificationAuthorityReference;
import org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import org.bouncycastle.asn1.eac.PackedDate;
import org.bouncycastle.eac.EACCertificateBuilder;
import org.bouncycastle.eac.EACCertificateHolder;
import org.bouncycastle.eac.EACCertificateRequestHolder;
import org.bouncycastle.eac.jcajce.JcaPublicKeyConverter;
import org.bouncycastle.eac.operator.EACSignatureVerifier;
import org.bouncycastle.eac.operator.EACSigner;
import org.bouncycastle.eac.operator.jcajce.JcaEACSignatureVerifierBuilder;
import org.bouncycastle.eac.operator.jcajce.JcaEACSignerBuilder;
import org.bouncycastle.eac.test.EACTestSetup;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.test.PrintTestResult;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class AllTests
extends TestCase {
    private static final String BC = "BC";
    static /* synthetic */ Class class$org$bouncycastle$eac$test$AllTests;

    public void setUp() {
        if (Security.getProvider(BC) != null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void testLoadCertificate() throws Exception {
        EACCertificateHolder certHolder = new EACCertificateHolder(this.getInput("Belgique CVCA-02032010.7816.cvcert"));
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        EACSignatureVerifier verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            Assert.fail((String)"signature test failed");
        }
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    public void testLoadInvalidRequest() throws Exception {
        EACCertificateRequestHolder requestHolder = new EACCertificateRequestHolder(this.getInput("REQ_18102010.csr"));
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(requestHolder.getPublicKeyDataObject());
        EACSignatureVerifier verifier = new JcaEACSignatureVerifierBuilder().build(requestHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (requestHolder.isInnerSignatureValid(verifier)) {
            Assert.fail((String)"signature test failed");
        }
    }

    public void testLoadCSR() throws Exception {
        byte[] input = this.getInput("UTIS00100072.csr");
        EACCertificateRequestHolder requestHolder = new EACCertificateRequestHolder(input);
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(requestHolder.getPublicKeyDataObject());
        EACSignatureVerifier verifier = new JcaEACSignatureVerifierBuilder().build(requestHolder.getPublicKeyDataObject().getUsage(), pubKey);
        Assert.assertTrue((String)"signature test failed", (boolean)requestHolder.isInnerSignatureValid(verifier));
        Assert.assertTrue((String)"comparison failed", (boolean)Arrays.areEqual((byte[])input, (byte[])requestHolder.toASN1Structure().getEncoded()));
    }

    public void testLoadRefCert() throws Exception {
        EACCertificateHolder eACCertificateHolder = new EACCertificateHolder(this.getInput("at_cert_19a.cvcert"));
    }

    public void testGenerateEC() throws Exception {
        EACSignatureVerifier verifier;
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPair kp = this.generateECKeyPair((ECParameterSpec)ecSpec);
        JcaEACSignerBuilder signerBuilder = new JcaEACSignerBuilder().setProvider(BC);
        EACSigner signer = signerBuilder.build("SHA256withECDSA", kp.getPrivate());
        int role = 192;
        int rights = 3;
        EACCertificateBuilder certBuilder = new EACCertificateBuilder(new CertificationAuthorityReference("AU", "BC TEST", "12345"), new JcaPublicKeyConverter().getPublicKeyDataObject(signer.getUsageIdentifier(), kp.getPublic()), new CertificateHolderReference("AU", "BC TEST", "12345"), new CertificateHolderAuthorization(EACObjectIdentifiers.id_EAC_ePassport, role | rights), new PackedDate("110101"), new PackedDate("120101"));
        EACCertificateHolder certHolder = certBuilder.build(signer);
        if (!certHolder.isSignatureValid(verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), kp.getPublic()))) {
            Assert.fail((String)"first signature test failed");
        }
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            Assert.fail((String)"second signature test failed");
        }
    }

    public void testGenerateRSA() throws Exception {
        EACSignatureVerifier verifier;
        KeyPair kp = this.generateRSAKeyPair();
        JcaEACSignerBuilder signerBuilder = new JcaEACSignerBuilder().setProvider(BC);
        EACSigner signer = signerBuilder.build("SHA256withRSA", kp.getPrivate());
        int role = 192;
        int rights = 3;
        EACCertificateBuilder certBuilder = new EACCertificateBuilder(new CertificationAuthorityReference("AU", "BC TEST", "12345"), new JcaPublicKeyConverter().getPublicKeyDataObject(signer.getUsageIdentifier(), kp.getPublic()), new CertificateHolderReference("AU", "BC TEST", "12345"), new CertificateHolderAuthorization(EACObjectIdentifiers.id_EAC_ePassport, role | rights), new PackedDate("110101"), new PackedDate("120101"));
        EACCertificateHolder certHolder = certBuilder.build(signer);
        if (!certHolder.isSignatureValid(verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), kp.getPublic()))) {
            Assert.fail((String)"first signature test failed");
        }
        PublicKey pubKey = new JcaPublicKeyConverter().setProvider(BC).getKey(certHolder.getPublicKeyDataObject());
        verifier = new JcaEACSignatureVerifierBuilder().build(certHolder.getPublicKeyDataObject().getUsage(), pubKey);
        if (!certHolder.isSignatureValid(verifier)) {
            Assert.fail((String)"second signature test failed");
        }
    }

    private KeyPair generateECKeyPair(ECParameterSpec spec) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("ECDSA", BC);
        gen.initialize((AlgorithmParameterSpec)spec, new SecureRandom());
        KeyPair generatedKeyPair = gen.generateKeyPair();
        return generatedKeyPair;
    }

    private KeyPair generateRSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", BC);
        gen.initialize(1024, new SecureRandom());
        KeyPair generatedKeyPair = gen.generateKeyPair();
        return generatedKeyPair;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrintTestResult.printResult(TestRunner.run((Test)AllTests.suite()));
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("EAC tests");
        suite.addTestSuite(class$org$bouncycastle$eac$test$AllTests == null ? (class$org$bouncycastle$eac$test$AllTests = AllTests.class$("org.bouncycastle.eac.test.AllTests")) : class$org$bouncycastle$eac$test$AllTests);
        return new EACTestSetup((Test)suite);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

