/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.dvcs.test;

import java.io.IOException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.dvcs.CertEtcToken;
import org.bouncycastle.asn1.dvcs.TargetEtcChain;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SignerInformationVerifierProvider;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.dvcs.CCPDRequestBuilder;
import org.bouncycastle.dvcs.CCPDRequestData;
import org.bouncycastle.dvcs.CPDRequestBuilder;
import org.bouncycastle.dvcs.CPDRequestData;
import org.bouncycastle.dvcs.DVCSException;
import org.bouncycastle.dvcs.DVCSMessage;
import org.bouncycastle.dvcs.DVCSRequest;
import org.bouncycastle.dvcs.MessageImprint;
import org.bouncycastle.dvcs.MessageImprintBuilder;
import org.bouncycastle.dvcs.SignedDVCSMessageGenerator;
import org.bouncycastle.dvcs.TargetChain;
import org.bouncycastle.dvcs.VPKCRequestBuilder;
import org.bouncycastle.dvcs.VPKCRequestData;
import org.bouncycastle.dvcs.VSDRequestBuilder;
import org.bouncycastle.dvcs.VSDRequestData;
import org.bouncycastle.dvcs.test.DVCSTestSetup;
import org.bouncycastle.dvcs.test.SHA1DigestCalculator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.test.PrintTestResult;
import org.bouncycastle.util.Arrays;

public class AllTests
extends TestCase {
    private static final String BC = "BC";
    private static boolean initialised = false;
    private static String origDN;
    private static KeyPair origKP;
    private static X509Certificate origCert;
    private static String signDN;
    private static KeyPair signKP;
    private static X509Certificate signCert;
    static /* synthetic */ Class class$org$bouncycastle$dvcs$test$AllTests;
    static /* synthetic */ Class class$org$bouncycastle$dvcs$test$DVCSParseTest;

    private static void init() throws Exception {
        if (!initialised) {
            initialised = true;
            if (Security.getProvider(BC) == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            origDN = "O=Bouncy Castle, C=AU";
            origKP = CMSTestUtil.makeKeyPair();
            origCert = CMSTestUtil.makeCertificate(origKP, origDN, origKP, origDN);
            signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            signKP = CMSTestUtil.makeKeyPair();
            signCert = CMSTestUtil.makeCertificate(signKP, signDN, origKP, origDN);
        }
    }

    public void setUp() throws Exception {
        AllTests.init();
    }

    public void testCCPDRequest() throws Exception {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        CCPDRequestBuilder reqBuilder = new CCPDRequestBuilder();
        MessageImprintBuilder imprintBuilder = new MessageImprintBuilder((DigestCalculator)new SHA1DigestCalculator());
        MessageImprint messageImprint = imprintBuilder.build(new byte[100]);
        CMSSignedData reqMsg = gen.build((DVCSMessage)reqBuilder.build(messageImprint));
        Assert.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        CCPDRequestData reqData = (CCPDRequestData)request.getData();
        Assert.assertEquals((Object)messageImprint, (Object)reqData.getMessageImprint());
    }

    private CMSSignedData getWrappedCPDRequest() throws OperatorCreationException, CertificateEncodingException, DVCSException, IOException {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        CPDRequestBuilder reqBuilder = new CPDRequestBuilder();
        return gen.build((DVCSMessage)reqBuilder.build(new byte[100]));
    }

    public void testCPDRequest() throws Exception {
        CMSSignedData reqMsg = this.getWrappedCPDRequest();
        Assert.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        CPDRequestData reqData = (CPDRequestData)request.getData();
        Assert.assertTrue((boolean)Arrays.areEqual((byte[])new byte[100], (byte[])reqData.getMessage()));
    }

    public void testVPKCRequest() throws Exception {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        VPKCRequestBuilder reqBuilder = new VPKCRequestBuilder();
        reqBuilder.addTargetChain((X509CertificateHolder)new JcaX509CertificateHolder(signCert));
        CMSSignedData reqMsg = gen.build((DVCSMessage)reqBuilder.build());
        Assert.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        VPKCRequestData reqData = (VPKCRequestData)request.getData();
        Assert.assertEquals((Object)new TargetEtcChain(new CertEtcToken(0, (ASN1Encodable)new JcaX509CertificateHolder(signCert).toASN1Structure())), (Object)((TargetChain)reqData.getCerts().get(0)).toASN1Structure());
    }

    public void testVSDRequest() throws Exception {
        CMSSignedData message = this.getWrappedCPDRequest();
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        VSDRequestBuilder reqBuilder = new VSDRequestBuilder();
        CMSSignedData reqMsg = gen.build((DVCSMessage)reqBuilder.build(message));
        Assert.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        VSDRequestData reqData = (VSDRequestData)request.getData();
        Assert.assertEquals((Object)message.toASN1Structure().getContentType(), (Object)reqData.getParsedMessage().toASN1Structure().getContentType());
    }

    private SignedDVCSMessageGenerator getSignedDVCSMessageGenerator() throws OperatorCreationException, CertificateEncodingException {
        CMSSignedDataGenerator sigDataGen = new CMSSignedDataGenerator();
        JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider(BC);
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(signKP.getPrivate());
        sigDataGen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build()).build(contentSigner, signCert));
        return new SignedDVCSMessageGenerator(sigDataGen);
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PrintTestResult.printResult(TestRunner.run((Test)AllTests.suite()));
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("EAC tests");
        suite.addTestSuite(class$org$bouncycastle$dvcs$test$AllTests == null ? (class$org$bouncycastle$dvcs$test$AllTests = AllTests.class$("org.bouncycastle.dvcs.test.AllTests")) : class$org$bouncycastle$dvcs$test$AllTests);
        suite.addTestSuite(class$org$bouncycastle$dvcs$test$DVCSParseTest == null ? (class$org$bouncycastle$dvcs$test$DVCSParseTest = AllTests.class$("org.bouncycastle.dvcs.test.DVCSParseTest")) : class$org$bouncycastle$dvcs$test$DVCSParseTest);
        return new DVCSTestSetup((Test)suite);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

