/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.Zuc128Engine;
import org.bouncycastle.crypto.engines.Zuc256Engine;
import org.bouncycastle.crypto.macs.Zuc128Mac;
import org.bouncycastle.crypto.macs.Zuc256Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ZucTest
extends SimpleTest {
    private static final int INT_SIZE = 32;
    private static final int BYTE_SIZE = 8;
    private static final String KEY128_1 = "00000000000000000000000000000000";
    private static final String KEY128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String KEY256_1 = "0000000000000000000000000000000000000000000000000000000000000000";
    private static final String KEY256_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV128_1 = "00000000000000000000000000000000";
    private static final String IV128_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String IV200_1 = "00000000000000000000000000000000000000000000000000";
    private static final String IV200_2 = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F";
    private static final int ZUC256LIMIT = 20000;
    private static final int ZUC128LIMIT = 65504;

    public String getName() {
        return "Zuc";
    }

    public void performTest() throws Exception {
        new Zuc128Test().testTheCipher();
        new Zuc256Test().testTheCipher();
        new Zuc128MacTest().testTheMac();
        new Zuc256Mac32Test().testTheMac();
        new Zuc256Mac64Test().testTheMac();
        new Zuc256Mac128Test().testTheMac();
    }

    void testCipher(StreamCipher pCipher, TestCase pTestCase) {
        byte[] myExpected = Hex.decode((String)pTestCase.theExpected);
        byte[] myOutput = new byte[myExpected.length];
        byte[] myData = pTestCase.thePlainText != null ? Hex.decode((String)pTestCase.thePlainText) : new byte[myExpected.length];
        KeyParameter myKey = new KeyParameter(Hex.decode((String)pTestCase.theKey));
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        ParametersWithIV myParms = new ParametersWithIV((CipherParameters)myKey, myIV);
        pCipher.init(true, (CipherParameters)myParms);
        pCipher.processBytes(myData, 0, myData.length, myOutput, 0);
        this.isTrue("Encryption mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
    }

    void testMac(Mac pMac, boolean pOnes, TestCase pTestCase) {
        byte[] myExpected = Hex.decode((String)pTestCase.theExpected);
        byte[] myOutput = new byte[pMac.getMacSize()];
        byte[] myData = new byte[(pOnes ? 4000 : 400) / 8];
        Arrays.fill((byte[])myData, (byte)(pOnes ? (byte)17 : 0));
        KeyParameter myKey = new KeyParameter(Hex.decode((String)pTestCase.theKey));
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        ParametersWithIV myParms = new ParametersWithIV((CipherParameters)myKey, myIV);
        pMac.init((CipherParameters)myParms);
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("DoFinal Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
        pMac.update(myData, 0, myData.length);
        pMac.reset();
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        this.isTrue("Reset Mac mismatch", Arrays.areEqual((byte[])myExpected, (byte[])myOutput));
    }

    void testStreamLimit(StreamCipher pCipher, TestCase pTestCase, int pLimit) {
        this.isTrue("Invalid limit", pLimit % 32 == 0);
        int myNumBytes = pLimit / 8;
        byte[] myData = new byte[myNumBytes];
        byte[] myOutput = new byte[myNumBytes];
        KeyParameter myKey = new KeyParameter(Hex.decode((String)pTestCase.theKey));
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        ParametersWithIV myParms = new ParametersWithIV((CipherParameters)myKey, myIV);
        pCipher.init(true, (CipherParameters)myParms);
        pCipher.processBytes(myData, 0, myData.length, myOutput, 0);
        try {
            pCipher.processBytes(myData, 0, 1, myOutput, 0);
            this.fail("Limit Failure");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    void testMacLimit(Mac pMac, TestCase pTestCase, int pLimit) {
        this.isTrue("Invalid limit", pLimit % 32 == 0);
        int myNumBytes = pLimit / 8;
        byte[] myData = new byte[myNumBytes];
        byte[] myOutput = new byte[myNumBytes];
        KeyParameter myKey = new KeyParameter(Hex.decode((String)pTestCase.theKey));
        byte[] myIV = Hex.decode((String)pTestCase.theIV);
        ParametersWithIV myParms = new ParametersWithIV((CipherParameters)myKey, myIV);
        pMac.init((CipherParameters)myParms);
        pMac.update(myData, 0, myData.length);
        pMac.doFinal(myOutput, 0);
        pMac.init((CipherParameters)myParms);
        pMac.update(myData, 0, myData.length);
        try {
            pMac.update(myData, 0, 1);
            pMac.doFinal(myOutput, 0);
            this.fail("Limit Failure");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ZucTest());
    }

    class Zuc256Mac128Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "d85e54bbcb9600967084c952a1654b26");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "df1e8307b31cc62beca1ac6f8190c22f");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "a35bb274b567c48b28319f111af34fbd");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "3a83b554be408ca5494124ed9d473205");

        Zuc256Mac128Test() {
        }

        void testTheMac() {
            Zuc256Mac myMac = new Zuc256Mac(128);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST1);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST2);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST3);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST4);
            ZucTest.this.testMacLimit((Mac)myMac, this.TEST4, 20000 - 2 * myMac.getMacSize() * 8);
        }
    }

    class Zuc256Mac64Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "673e54990034d38c");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "130dc225e72240cc");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "8c71394d39957725");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "ea1dee544bb6223b");

        Zuc256Mac64Test() {
        }

        void testTheMac() {
            Zuc256Mac myMac = new Zuc256Mac(64);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST1);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST2);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST3);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST4);
            ZucTest.this.testMacLimit((Mac)myMac, this.TEST4, 20000 - 2 * myMac.getMacSize() * 8);
        }
    }

    class Zuc256Mac32Test {
        private final TestCase TEST1 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "9b972a74");
        private final TestCase TEST2 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "8754f5cf");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "1f3079b4");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "5c7c8b88");

        Zuc256Mac32Test() {
        }

        void testTheMac() {
            Zuc256Mac myMac = new Zuc256Mac(32);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST1);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST2);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST3);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST4);
            ZucTest.this.testMacLimit((Mac)myMac, this.TEST4, 20000 - 2 * myMac.getMacSize() * 8);
            Zuc256Mac xMac = new Zuc256Mac(32);
            xMac.reset();
        }
    }

    class Zuc128MacTest {
        private final TestCase TEST1 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "508dd5ff");
        private final TestCase TEST2 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "fbed4c12");
        private final TestCase TEST3 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "55e01504");
        private final TestCase TEST4 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "9ce9a0c4");

        Zuc128MacTest() {
        }

        void testTheMac() {
            Zuc128Mac myMac = new Zuc128Mac();
            ZucTest.this.testMac((Mac)myMac, false, this.TEST1);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST2);
            ZucTest.this.testMac((Mac)myMac, false, this.TEST3);
            ZucTest.this.testMac((Mac)myMac, true, this.TEST4);
            ZucTest.this.testMacLimit((Mac)myMac, this.TEST4, 65440);
            Zuc128Mac xMac = new Zuc128Mac();
            xMac.reset();
        }
    }

    class Zuc256Test {
        private final TestCase TEST4 = new TestCase("0000000000000000000000000000000000000000000000000000000000000000", "00000000000000000000000000000000000000000000000000", "58d03ad62e032ce2dafc683a39bdcb0352a2bc67f1b7de74163ce3a101ef55589639d75b95fa681b7f090df756391ccc903b7612744d544c17bc3fad8b163b08");
        private final TestCase TEST5 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3F3F3F3F3F3F3F3F", "3356cbaed1a1c18b6baa4ffe343f777c9e15128f251ab65b949f7b26ef7157f296dd2fa9df95e3ee7a5be02ec32ba585505af316c2f9ded27cdbd935e441ce11");

        Zuc256Test() {
        }

        void testTheCipher() {
            Zuc256Engine myEngine = new Zuc256Engine();
            ZucTest.this.testCipher((StreamCipher)myEngine, this.TEST4);
            ZucTest.this.testCipher((StreamCipher)myEngine, this.TEST5);
            ZucTest.this.testStreamLimit((StreamCipher)myEngine, this.TEST5, 20000);
        }
    }

    class Zuc128Test {
        private final TestCase TEST4 = new TestCase("00000000000000000000000000000000", "00000000000000000000000000000000", "27bede74018082da87d4e5b69f18bf6632070e0f39b7b692b4673edc3184a48e27636f4414510d62cc15cfe194ec4f6d4b8c8fcc630648badf41b6f9d16a36ca");
        private final TestCase TEST5 = new TestCase("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "0657cfa07096398b734b6cb4883eedf4257a76eb97595208d884adcdb1cbffb8e0f9d15846a0eed015328503351138f740d079af17296c232c4f022d6e4acac6");

        Zuc128Test() {
        }

        void testTheCipher() {
            Zuc128Engine myEngine = new Zuc128Engine();
            ZucTest.this.testCipher((StreamCipher)myEngine, this.TEST4);
            ZucTest.this.testCipher((StreamCipher)myEngine, this.TEST5);
            ZucTest.this.testStreamLimit((StreamCipher)myEngine, this.TEST5, 65504);
        }
    }

    private static class TestCase {
        private final String theKey;
        private final String theIV;
        private final String thePlainText;
        private final String theExpected;

        TestCase(String pKey, String pIV, String pExpected) {
            this(pKey, pIV, null, pExpected);
        }

        TestCase(String pKey, String pIV, String pPlain, String pExpected) {
            this.theKey = pKey;
            this.theIV = pIV;
            this.thePlainText = pPlain;
            this.theExpected = pExpected;
        }
    }
}

