/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class X448Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    public String getName() {
        return "X448";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new X448Test());
    }

    public void performTest() {
        int i = 0;
        while (i < 10) {
            this.testAgreement();
            ++i;
        }
    }

    private void testAgreement() {
        X448KeyPairGenerator kpGen = new X448KeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new X448KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair kpA = kpGen.generateKeyPair();
        AsymmetricCipherKeyPair kpB = kpGen.generateKeyPair();
        X448Agreement agreeA = new X448Agreement();
        agreeA.init((CipherParameters)kpA.getPrivate());
        byte[] secretA = new byte[agreeA.getAgreementSize()];
        agreeA.calculateAgreement((CipherParameters)kpB.getPublic(), secretA, 0);
        X448Agreement agreeB = new X448Agreement();
        agreeB.init((CipherParameters)kpB.getPrivate());
        byte[] secretB = new byte[agreeB.getAgreementSize()];
        agreeB.calculateAgreement((CipherParameters)kpA.getPublic(), secretB, 0);
        if (!this.areEqual(secretA, secretB)) {
            this.fail("X448 agreement failed");
        }
    }
}

