/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.util.test.SimpleTest;

public class X25519Test
extends SimpleTest {
    private static final SecureRandom RANDOM = new SecureRandom();

    public String getName() {
        return "X25519";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new X25519Test());
    }

    public void performTest() {
        int i = 0;
        while (i < 10) {
            this.testAgreement();
            ++i;
        }
    }

    private void testAgreement() {
        X25519KeyPairGenerator kpGen = new X25519KeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new X25519KeyGenerationParameters(RANDOM));
        AsymmetricCipherKeyPair kpA = kpGen.generateKeyPair();
        AsymmetricCipherKeyPair kpB = kpGen.generateKeyPair();
        X25519Agreement agreeA = new X25519Agreement();
        agreeA.init((CipherParameters)kpA.getPrivate());
        byte[] secretA = new byte[agreeA.getAgreementSize()];
        agreeA.calculateAgreement((CipherParameters)kpB.getPublic(), secretA, 0);
        X25519Agreement agreeB = new X25519Agreement();
        agreeB.init((CipherParameters)kpB.getPrivate());
        byte[] secretB = new byte[agreeB.getAgreementSize()];
        agreeB.calculateAgreement((CipherParameters)kpA.getPublic(), secretB, 0);
        if (!this.areEqual(secretA, secretB)) {
            this.fail("X25519 agreement failed");
        }
    }
}

