/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.VMPCEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class VMPCTest
extends SimpleTest {
    private static final byte[] input = new byte[1000000];

    public String getName() {
        return "VMPC";
    }

    private void checkByte(byte[] array, int position, byte b) {
        if (array[position] != b) {
            this.fail("Fail on position " + position, new String(Hex.encode((byte[])new byte[]{b})), new String(Hex.encode((byte[])new byte[]{array[position]})));
        }
    }

    public void performTest() {
        byte[] key = Hex.decode((String)"9661410AB797D8A9EB767C21172DF6C7");
        byte[] iv = Hex.decode((String)"4B5C2F003E67F39557A8D26F3DA2B155");
        KeyParameter kp = new KeyParameter(key);
        ParametersWithIV kpwiv = new ParametersWithIV((CipherParameters)kp, iv);
        VMPCEngine engine = new VMPCEngine();
        try {
            engine.init(true, (CipherParameters)kp);
            this.fail("init failed to throw expected exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        engine.init(true, (CipherParameters)kpwiv);
        this.checkEngine(engine);
        engine.reset();
        byte[] output = this.checkEngine(engine);
        engine.init(false, (CipherParameters)kpwiv);
        byte[] recovered = new byte[output.length];
        engine.processBytes(output, 0, output.length, recovered, 0);
        if (!Arrays.areEqual((byte[])input, (byte[])recovered)) {
            this.fail("decrypted bytes differ from original bytes");
        }
    }

    private byte[] checkEngine(VMPCEngine engine) {
        byte[] output = new byte[input.length];
        engine.processBytes(input, 0, output.length, output, 0);
        this.checkByte(output, 0, (byte)-88);
        this.checkByte(output, 1, (byte)36);
        this.checkByte(output, 2, (byte)121);
        this.checkByte(output, 3, (byte)-11);
        this.checkByte(output, 252, (byte)-72);
        this.checkByte(output, 253, (byte)-4);
        this.checkByte(output, 254, (byte)102);
        this.checkByte(output, 255, (byte)-92);
        this.checkByte(output, 1020, (byte)-32);
        this.checkByte(output, 1021, (byte)86);
        this.checkByte(output, 1022, (byte)64);
        this.checkByte(output, 1023, (byte)-91);
        this.checkByte(output, 102396, (byte)-127);
        this.checkByte(output, 102397, (byte)-54);
        this.checkByte(output, 102398, (byte)73);
        this.checkByte(output, 102399, (byte)-102);
        return output;
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new VMPCTest());
    }
}

