/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class StreamCipherVectorTest
extends SimpleTest {
    int id;
    StreamCipher cipher;
    CipherParameters param;
    byte[] input;
    byte[] output;

    public StreamCipherVectorTest(int id, StreamCipher cipher, CipherParameters param, String input, String output) {
        this.id = id;
        this.cipher = cipher;
        this.param = param;
        this.input = Hex.decode((String)input);
        this.output = Hex.decode((String)output);
    }

    public String getName() {
        return this.cipher.getAlgorithmName() + " Vector Test " + this.id;
    }

    public void performTest() {
        this.cipher.init(true, this.param);
        byte[] out = new byte[this.input.length];
        this.cipher.processBytes(this.input, 0, this.input.length, out, 0);
        if (!this.areEqual(out, this.output)) {
            this.fail("failed.", new String(Hex.encode((byte[])this.output)), new String(Hex.encode((byte[])out)));
        }
        this.cipher.init(false, this.param);
        this.cipher.processBytes(this.output, 0, this.output.length, out, 0);
        if (!this.areEqual(this.input, out)) {
            this.fail("failed reversal");
        }
    }
}

