/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.engines.Grain128Engine;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.engines.ISAACEngine;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.engines.XSalsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class StreamCipherResetTest
extends SimpleTest {
    private static final SecureRandom RAND = new SecureRandom();

    public String getName() {
        return "Stream Cipher Reset";
    }

    public void performTest() throws Exception {
        this.testReset((StreamCipher)new Salsa20Engine(), (StreamCipher)new Salsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(32)), this.random(8)));
        this.testReset((StreamCipher)new Salsa20Engine(), (StreamCipher)new Salsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(16)), this.random(8)));
        this.testReset((StreamCipher)new XSalsa20Engine(), (StreamCipher)new XSalsa20Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(32)), this.random(24)));
        this.testReset((StreamCipher)new ChaChaEngine(), (StreamCipher)new ChaChaEngine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(32)), this.random(8)));
        this.testReset((StreamCipher)new ChaChaEngine(), (StreamCipher)new ChaChaEngine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(16)), this.random(8)));
        this.testReset((StreamCipher)new RC4Engine(), (StreamCipher)new RC4Engine(), (CipherParameters)new KeyParameter(this.random(16)));
        this.testReset((StreamCipher)new ISAACEngine(), (StreamCipher)new ISAACEngine(), (CipherParameters)new KeyParameter(this.random(16)));
        this.testReset((StreamCipher)new HC128Engine(), (StreamCipher)new HC128Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(16)), this.random(16)));
        this.testReset((StreamCipher)new HC256Engine(), (StreamCipher)new HC256Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(16)), this.random(16)));
        this.testReset((StreamCipher)new Grainv1Engine(), (StreamCipher)new Grainv1Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(10)), this.random(8)));
        this.testReset((StreamCipher)new Grain128Engine(), (StreamCipher)new Grain128Engine(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.random(16)), this.random(12)));
    }

    private byte[] random(int size) {
        byte[] data = new byte[size];
        RAND.nextBytes(data);
        return data;
    }

    private void testReset(StreamCipher cipher1, StreamCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        cipher1.init(true, params);
        byte[] plaintext = new byte[1023];
        byte[] ciphertext = new byte[plaintext.length];
        cipher1.processBytes(plaintext, 0, plaintext.length, ciphertext, 0);
        this.checkReset(cipher1, params, true, plaintext, ciphertext);
        cipher2.init(false, params);
        this.checkReset(cipher2, params, false, ciphertext, plaintext);
    }

    private void checkReset(StreamCipher cipher, CipherParameters params, boolean encrypt, byte[] pretext, byte[] posttext) throws InvalidCipherTextException {
        byte[] output = new byte[posttext.length];
        cipher.processBytes(pretext, 0, pretext.length, output, 0);
        cipher.init(encrypt, params);
        try {
            cipher.processBytes(pretext, 0, pretext.length, output, 0);
        }
        catch (Exception e) {
            this.fail(cipher.getAlgorithmName() + " init did not reset: " + e.getMessage());
        }
        if (!Arrays.areEqual((byte[])output, (byte[])posttext)) {
            this.fail(cipher.getAlgorithmName() + " init did not reset.", new String(Hex.encode((byte[])posttext)), new String(Hex.encode((byte[])output)));
        }
        cipher.reset();
        try {
            cipher.processBytes(pretext, 0, pretext.length, output, 0);
        }
        catch (Exception e) {
            this.fail(cipher.getAlgorithmName() + " reset did not reset: " + e.getMessage());
        }
        if (!Arrays.areEqual((byte[])output, (byte[])posttext)) {
            this.fail(cipher.getAlgorithmName() + " reset did not reset.");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new StreamCipherResetTest());
    }
}

