/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SipHashTest
extends SimpleTest {
    private static final int UPDATE_BYTES = 0;
    private static final int UPDATE_FULL = 1;
    private static final int UPDATE_MIX = 2;

    public String getName() {
        return "SipHash";
    }

    public void performTest() throws Exception {
        this.performTest_2_4();
        this.performTest_4_8();
    }

    private void performTest_2_4() throws Exception {
        byte[] key = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        byte[] input = Hex.decode((String)"000102030405060708090a0b0c0d0e");
        byte[] expected = Hex.decode((String)"e545be4961ca29a1");
        this.runMAC(2, 4, expected, key, input);
        int[][] vectors_sip64 = new int[][]{{49, 14, 14, 221, 71, 219, 111, 114}, {253, 103, 220, 147, 197, 57, 248, 116}, {90, 79, 169, 217, 9, 128, 108, 13}, {45, 126, 251, 215, 150, 102, 103, 133}, {183, 135, 113, 39, 224, 148, 39, 207}, {141, 166, 153, 205, 100, 85, 118, 24}, {206, 227, 254, 88, 110, 70, 201, 203}, {55, 209, 1, 139, 245, 0, 2, 171}, {98, 36, 147, 154, 121, 245, 245, 147}, {176, 228, 169, 11, 223, 130, 0, 158}, {243, 185, 221, 148, 197, 187, 93, 122}, {167, 173, 107, 34, 70, 47, 179, 244}, {251, 229, 14, 134, 188, 143, 30, 117}, {144, 61, 132, 192, 39, 86, 234, 20}, {238, 242, 122, 142, 144, 202, 35, 247}, {229, 69, 190, 73, 97, 202, 41, 161}, {219, 155, 194, 87, 127, 204, 42, 63}, {148, 71, 190, 44, 245, 233, 154, 105}, {156, 211, 141, 150, 240, 179, 193, 75}, {189, 97, 121, 167, 29, 201, 109, 187}, {152, 238, 162, 26, 242, 92, 214, 190}, {199, 103, 59, 46, 176, 203, 242, 208}, {136, 62, 163, 227, 149, 103, 83, 147}, {200, 206, 92, 205, 140, 3, 12, 168}, {148, 175, 73, 246, 198, 80, 173, 184}, {234, 184, 133, 138, 222, 146, 225, 188}, {243, 21, 187, 91, 184, 53, 216, 23}, {173, 207, 107, 7, 99, 97, 46, 47}, {165, 201, 29, 167, 172, 170, 77, 222}, {113, 101, 149, 135, 102, 80, 162, 166}, {40, 239, 73, 92, 83, 163, 135, 173}, {66, 195, 65, 216, 250, 146, 216, 50}, {206, 124, 242, 114, 47, 81, 39, 113}, {227, 120, 89, 249, 70, 35, 243, 167}, {56, 18, 5, 187, 26, 176, 224, 18}, {174, 151, 161, 15, 212, 52, 224, 21}, {180, 163, 21, 8, 190, 255, 77, 49}, {129, 57, 98, 41, 240, 144, 121, 2}, {77, 12, 244, 158, 229, 212, 220, 202}, {92, 115, 51, 106, 118, 216, 191, 154}, {208, 167, 4, 83, 107, 169, 62, 14}, {146, 89, 88, 252, 214, 66, 12, 173}, {169, 21, 194, 155, 200, 6, 115, 24}, {149, 43, 121, 243, 188, 10, 166, 212}, {242, 29, 242, 228, 29, 69, 53, 249}, {135, 87, 117, 25, 4, 143, 83, 169}, {16, 165, 108, 245, 223, 205, 154, 219}, {235, 117, 9, 92, 205, 152, 108, 208}, {81, 169, 203, 158, 203, 163, 18, 230}, {150, 175, 173, 252, 44, 230, 102, 199}, {114, 254, 82, 151, 90, 67, 100, 238}, {90, 22, 69, 178, 118, 213, 146, 161}, {178, 116, 203, 142, 191, 135, 135, 10}, {111, 155, 180, 32, 61, 231, 179, 129}, {234, 236, 178, 163, 11, 34, 168, 127}, {153, 36, 164, 60, 193, 49, 87, 36}, {189, 131, 141, 58, 175, 191, 141, 183}, {11, 26, 42, 50, 101, 213, 26, 234}, {19, 80, 121, 163, 35, 28, 230, 96}, {147, 43, 40, 70, 228, 215, 6, 102}, {225, 145, 95, 92, 177, 236, 164, 108}, {243, 37, 150, 92, 161, 109, 98, 159}, {87, 95, 242, 142, 96, 56, 27, 229}, {114, 69, 6, 235, 76, 50, 138, 149}};
        this.performTest(2, 4, vectors_sip64);
    }

    private void performTest_4_8() throws Exception {
        int[][] vectors_sip64 = new int[][]{{65, 218, 56, 153, 43, 5, 121, 200}, {81, 184, 149, 82, 249, 20, 89, 200}, {146, 55, 22, 240, 190, 221, 195, 51}, {106, 70, 212, 125, 101, 71, 193, 5}, {194, 56, 89, 43, 74, 193, 250, 72}, {246, 194, 215, 217, 207, 82, 71, 225}, {107, 182, 188, 52, 200, 53, 85, 142}, {71, 215, 63, 113, 90, 190, 253, 78}, {32, 181, 139, 156, 7, 47, 219, 80}, {54, 49, 154, 243, 94, 225, 18, 83}, {72, 169, 208, 219, 10, 141, 132, 143}, {204, 105, 57, 96, 54, 4, 10, 129}, {75, 109, 104, 83, 122, 167, 151, 97}, {41, 55, 150, 233, 242, 201, 80, 105}, {136, 67, 27, 234, 167, 98, 154, 104}, {224, 166, 169, 125, 213, 137, 211, 131}, {85, 156, 245, 83, 128, 178, 172, 112}, {213, 183, 197, 17, 122, 227, 121, 78}, {90, 60, 69, 70, 52, 173, 16, 43}, {192, 164, 128, 175, 163, 90, 61, 188}, {120, 194, 39, 9, 229, 40, 75, 200}, {239, 38, 112, 70, 13, 235, 214, 157}, {217, 118, 239, 134, 169, 208, 132, 216}, {227, 217, 129, 24, 25, 234, 208, 232}, {137, 51, 60, 181, 62, 234, 236, 22}, {49, 21, 108, 95, 100, 115, 73, 198}, {165, 76, 206, 53, 53, 118, 50, 164}, {6, 93, 137, 37, 192, 167, 210, 254}, {43, 187, 170, 130, 34, 26, 58, 139}, {135, 11, 251, 206, 100, 9, 123, 112}, {64, 216, 224, 249, 100, 149, 238, 139}, {121, 252, 167, 244, 11, 250, 223, 18}, {0, 11, 251, 242, 47, 118, 158, 210}, {64, 104, 85, 145, 248, 229, 34, 250}, {43, 230, 254, 116, 216, 20, 157, 13}, {186, 126, 47, 14, 11, 117, 96, 237}, {2, 233, 227, 132, 237, 167, 225, 151}, {196, 232, 10, 98, 149, 39, 99, 182}, {131, 39, 237, 198, 93, 92, 109, 211}, {121, 252, 100, 209, 100, 164, 47, 192}, {21, 74, 117, 17, 203, 252, 97, 78}, {139, 20, 141, 124, 236, 160, 230, 111}, {223, 238, 105, 182, 84, 196, 3, 250}, {197, 143, 54, 166, 105, 123, 183, 201}, {166, 197, 190, 156, 5, 198, 49, 33}, {181, 138, 135, 89, 251, 205, 137, 49}, {215, 104, 58, 103, 4, 204, 196, 37}, {203, 106, 230, 225, 229, 162, 68, 141}, {110, 38, 105, 91, 58, 58, 81, 115}, {120, 113, 7, 207, 159, 51, 172, 74}, {22, 117, 144, 218, 217, 123, 116, 132}, {0, 107, 104, 30, 240, 107, 243, 6}, {28, 155, 48, 2, 102, 239, 207, 166}, {40, 141, 47, 136, 209, 176, 179, 75}, {224, 17, 6, 189, 172, 245, 107, 254}, {192, 16, 31, 14, 91, 110, 3, 40}, {195, 167, 145, 69, 91, 27, 28, 10}, {87, 7, 175, 225, 158, 11, 58, 15}, {230, 90, 114, 41, 254, 83, 89, 79}, {0, 47, 157, 185, 171, 26, 175, 76}, {89, 40, 203, 80, 68, 193, 6, 6}, {213, 56, 1, 150, 123, 133, 115, 33}, {5, 219, 54, 79, 26, 9, 153, 204}, {230, 119, 132, 188, 85, 3, 222, 35}};
        this.performTest(4, 8, vectors_sip64);
    }

    private void performTest(int cRounds, int dRounds, int[][] testvectorsInt) throws Exception {
        int n = testvectorsInt.length;
        int macSize = testvectorsInt[0].length;
        byte[][] testvectors = new byte[n][];
        int i = 0;
        while (i < n) {
            testvectors[i] = new byte[macSize];
            int j = 0;
            while (j < macSize) {
                testvectors[i][j] = (byte)testvectorsInt[i][j];
                ++j;
            }
            ++i;
        }
        byte[] key = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        int i2 = 0;
        while (i2 < n) {
            byte[] input = new byte[i2];
            int j = 0;
            while (j < input.length) {
                input[j] = (byte)j;
                ++j;
            }
            this.runMAC(cRounds, dRounds, testvectors[i2], key, input);
            ++i2;
        }
        SecureRandom random = new SecureRandom();
        int i3 = 0;
        while (i3 < 100) {
            this.randomTest(cRounds, dRounds, random);
            ++i3;
        }
    }

    private void runMAC(int cRounds, int dRounds, byte[] expected, byte[] key, byte[] input) throws Exception {
        this.runMAC(cRounds, dRounds, expected, key, input, 0);
        this.runMAC(cRounds, dRounds, expected, key, input, 1);
        this.runMAC(cRounds, dRounds, expected, key, input, 2);
    }

    private void runMAC(int cRounds, int dRounds, byte[] expected, byte[] key, byte[] input, int updateType) throws Exception {
        long expectedLong = Pack.littleEndianToLong((byte[])expected, (int)0);
        SipHash mac = new SipHash(cRounds, dRounds);
        mac.init((CipherParameters)new KeyParameter(key));
        this.updateMAC(mac, input, updateType);
        long result = mac.doFinal();
        if (expectedLong != result) {
            this.fail("Result does not match expected value for doFinal()");
        }
        this.updateMAC(mac, input, updateType);
        byte[] output = new byte[mac.getMacSize()];
        int len = mac.doFinal(output, 0);
        if (len != output.length) {
            this.fail("Result length does not equal getMacSize() for doFinal(byte[],int)");
        }
        if (!this.areEqual(expected, output)) {
            this.fail("Result does not match expected value for doFinal(byte[],int)");
        }
    }

    private void randomTest(int cRounds, int dRounds, SecureRandom random) {
        byte[] key = new byte[16];
        random.nextBytes(key);
        int length = 1 + RNGUtils.nextInt(random, 1024);
        byte[] input = new byte[length];
        random.nextBytes(input);
        SipHash mac = new SipHash(cRounds, dRounds);
        mac.init((CipherParameters)new KeyParameter(key));
        this.updateMAC(mac, input, 0);
        byte[] result1 = new byte[16];
        mac.doFinal(result1, 0);
        this.updateMAC(mac, input, 1);
        byte[] result2 = new byte[16];
        mac.doFinal(result2, 0);
        this.updateMAC(mac, input, 2);
        byte[] result3 = new byte[16];
        mac.doFinal(result3, 0);
        if (!Arrays.areEqual((byte[])result1, (byte[])result2) || !Arrays.areEqual((byte[])result1, (byte[])result3)) {
            this.fail("Inconsistent results in random test");
        }
    }

    private void updateMAC(SipHash mac, byte[] input, int updateType) {
        switch (updateType) {
            case 0: {
                int i = 0;
                while (i < input.length) {
                    mac.update(input[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                mac.update(input, 0, input.length);
                break;
            }
            case 2: {
                int step = Math.max(1, input.length / 3);
                int pos = 0;
                while (pos < input.length) {
                    mac.update(input[pos++]);
                    int len = Math.min(input.length - pos, step);
                    mac.update(input, pos, len);
                    pos += len;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new SipHashTest());
    }
}

