/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.SipHash128;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SipHash128Test
extends SimpleTest {
    private static final int UPDATE_BYTES = 0;
    private static final int UPDATE_FULL = 1;
    private static final int UPDATE_MIX = 2;

    public String getName() {
        return "SipHash128";
    }

    public void performTest() throws Exception {
        this.performTest_2_4();
        this.performTest_4_8();
    }

    private void performTest_2_4() throws Exception {
        int[][] vectors_sip128 = new int[][]{{163, 129, 127, 4, 186, 37, 168, 230, 109, 246, 114, 20, 199, 85, 2, 147}, {218, 135, 193, 216, 107, 153, 175, 68, 52, 118, 89, 17, 155, 34, 252, 69}, {129, 119, 34, 141, 164, 164, 93, 199, 252, 163, 139, 222, 246, 10, 255, 228}, {156, 112, 182, 12, 82, 103, 169, 78, 95, 51, 182, 176, 41, 133, 237, 81}, {248, 129, 100, 193, 45, 156, 143, 175, 125, 15, 110, 124, 123, 205, 85, 121}, {19, 104, 135, 89, 128, 119, 111, 136, 84, 82, 122, 7, 105, 14, 150, 39}, {20, 238, 202, 51, 139, 32, 134, 19, 72, 94, 160, 48, 143, 215, 161, 94}, {161, 241, 235, 190, 216, 219, 193, 83, 192, 184, 74, 166, 31, 240, 130, 57}, {59, 98, 169, 186, 98, 88, 245, 97, 15, 131, 226, 100, 243, 20, 151, 180}, {38, 68, 153, 6, 10, 217, 186, 171, 196, 127, 139, 2, 187, 109, 113, 237}, {0, 17, 13, 195, 120, 20, 105, 86, 201, 84, 71, 211, 243, 208, 251, 186}, {1, 81, 197, 104, 56, 107, 102, 119, 162, 180, 220, 111, 129, 229, 220, 24}, {214, 38, 178, 102, 144, 94, 243, 88, 130, 99, 77, 246, 133, 50, 193, 37}, {152, 105, 226, 71, 233, 192, 139, 16, 208, 41, 147, 79, 196, 185, 82, 247}, {49, 252, 239, 172, 102, 215, 222, 156, 126, 199, 72, 95, 228, 73, 73, 2}, {84, 147, 233, 153, 51, 176, 168, 17, 126, 8, 236, 15, 151, 207, 195, 217}, {110, 226, 164, 202, 103, 176, 84, 187, 253, 51, 21, 191, 133, 35, 5, 119}, {71, 61, 6, 232, 115, 141, 184, 152, 84, 192, 102, 196, 122, 228, 119, 64}, {164, 38, 229, 228, 35, 191, 72, 133, 41, 77, 164, 129, 254, 174, 247, 35}, {120, 1, 119, 49, 207, 101, 250, 176, 116, 213, 32, 137, 82, 81, 46, 177}, {158, 37, 252, 131, 63, 34, 144, 115, 62, 147, 68, 165, 232, 56, 57, 235}, {86, 142, 73, 90, 190, 82, 90, 33, 138, 34, 20, 205, 62, 7, 29, 18}, {74, 41, 181, 69, 82, 209, 107, 154, 70, 156, 16, 82, 142, 255, 10, 174}, {201, 209, 132, 221, 213, 169, 245, 224, 207, 140, 226, 154, 154, 191, 105, 28}, {45, 180, 121, 174, 120, 189, 80, 216, 136, 42, 138, 23, 138, 97, 50, 173}, {142, 206, 95, 4, 45, 94, 68, 123, 80, 81, 185, 234, 203, 141, 143, 111}, {156, 11, 83, 180, 179, 195, 7, 232, 126, 174, 224, 134, 120, 20, 31, 102}, {171, 242, 72, 175, 105, 166, 234, 228, 191, 211, 235, 47, 18, 158, 235, 148}, {6, 100, 218, 22, 104, 87, 75, 136, 185, 53, 243, 2, 115, 88, 174, 244}, {170, 75, 157, 196, 191, 51, 125, 233, 12, 212, 253, 60, 70, 124, 106, 183}, {234, 92, 127, 71, 31, 175, 107, 222, 43, 26, 215, 212, 104, 109, 34, 135}, {41, 57, 176, 24, 50, 35, 250, 252, 23, 35, 222, 79, 82, 196, 61, 53}, {124, 57, 86, 202, 94, 234, 252, 62, 54, 62, 157, 85, 101, 70, 235, 104}, {119, 198, 7, 113, 70, 240, 28, 50, 182, 182, 157, 95, 78, 169, 255, 207}, {55, 166, 152, 108, 184, 132, 126, 223, 9, 37, 240, 241, 48, 155, 84, 222}, {167, 5, 240, 230, 157, 169, 168, 249, 7, 36, 26, 46, 146, 60, 140, 200}, {61, 196, 125, 31, 41, 196, 72, 70, 30, 158, 118, 237, 144, 79, 103, 17}, {13, 98, 191, 1, 230, 252, 14, 26, 13, 60, 71, 81, 197, 211, 105, 43}, {140, 3, 70, 139, 202, 124, 102, 158, 228, 253, 94, 8, 75, 190, 231, 181}, {82, 138, 91, 185, 59, 175, 44, 156, 68, 115, 204, 229, 208, 210, 43, 217}, {223, 106, 48, 30, 149, 201, 93, 173, 151, 174, 12, 200, 198, 145, 59, 216}, {128, 17, 137, 144, 44, 133, 127, 57, 231, 53, 145, 40, 94, 112, 182, 219}, {230, 23, 52, 106, 201, 194, 49, 187, 54, 80, 174, 52, 204, 202, 12, 91}, {39, 217, 52, 55, 239, 183, 33, 170, 64, 24, 33, 220, 236, 90, 223, 137}, {137, 35, 125, 157, 237, 156, 94, 120, 216, 177, 201, 177, 102, 204, 115, 66}, {74, 109, 128, 145, 191, 94, 125, 101, 17, 137, 250, 148, 162, 80, 177, 76}, {14, 51, 249, 96, 85, 231, 174, 137, 63, 252, 14, 61, 207, 73, 41, 2}, {230, 28, 67, 43, 114, 11, 25, 209, 142, 200, 216, 75, 220, 99, 21, 27}, {247, 229, 174, 245, 73, 247, 130, 207, 55, 144, 85, 166, 8, 38, 155, 22}, {67, 141, 3, 15, 208, 183, 165, 79, 168, 55, 242, 173, 32, 26, 100, 3}, {165, 144, 211, 238, 79, 191, 4, 227, 36, 126, 13, 39, 242, 134, 66, 63}, {95, 226, 193, 161, 114, 254, 147, 196, 177, 92, 211, 124, 174, 249, 245, 56}, {44, 151, 50, 92, 189, 6, 179, 110, 178, 19, 61, 208, 139, 58, 1, 124}, {146, 200, 20, 34, 122, 107, 202, 148, 159, 240, 101, 159, 0, 42, 211, 158}, {220, 232, 80, 17, 11, 216, 50, 140, 251, 213, 8, 65, 214, 145, 29, 135}, {103, 241, 73, 132, 199, 218, 121, 18, 72, 227, 43, 181, 146, 37, 131, 218}, {25, 56, 242, 207, 114, 213, 78, 233, 126, 148, 22, 111, 169, 29, 42, 54}, {116, 72, 30, 150, 70, 237, 73, 254, 15, 98, 36, 48, 22, 4, 105, 142}, {87, 252, 165, 222, 152, 169, 214, 216, 0, 100, 56, 208, 88, 61, 138, 29}, {159, 236, 222, 28, 239, 220, 28, 190, 212, 118, 54, 116, 217, 87, 83, 89}, {227, 4, 12, 0, 235, 40, 241, 83, 102, 202, 115, 203, 216, 114, 231, 64}, {118, 151, 0, 154, 106, 131, 29, 254, 204, 169, 28, 89, 147, 103, 15, 122}, {88, 83, 84, 35, 33, 245, 103, 160, 5, 213, 71, 164, 240, 71, 89, 189}, {81, 80, 209, 119, 47, 80, 131, 74, 80, 62, 6, 154, 151, 63, 189, 124}};
        this.performTest(2, 4, vectors_sip128);
    }

    private void performTest_4_8() throws Exception {
        int[][] vectors_sip128 = new int[][]{{31, 100, 206, 88, 109, 169, 4, 233, 207, 236, 232, 84, 131, 167, 10, 108}, {71, 52, 93, 168, 239, 76, 121, 71, 106, 242, 124, 167, 145, 199, 162, 128}, {225, 73, 95, 163, 150, 202, 45, 198, 34, 115, 129, 95, 24, 130, 33, 164}, {199, 162, 115, 132, 74, 197, 78, 131, 90, 156, 182, 127, 129, 5, 118, 2}, {84, 31, 82, 187, 244, 62, 206, 78, 42, 149, 200, 224, 31, 101, 109, 239}, {23, 151, 59, 212, 13, 243, 72, 21, 36, 79, 153, 12, 191, 18, 190, 93}, {107, 11, 54, 13, 86, 50, 128, 205, 177, 125, 86, 201, 8, 225, 245, 255}, {237, 0, 225, 59, 24, 75, 241, 194, 114, 107, 139, 84, 255, 210, 238, 224}, {167, 217, 70, 19, 143, 249, 237, 245, 54, 74, 90, 35, 175, 202, 224, 99}, {158, 115, 20, 183, 84, 92, 236, 163, 139, 154, 85, 73, 228, 251, 11, 232}, {88, 108, 98, 198, 132, 137, 209, 104, 174, 230, 91, 136, 154, 185, 18, 117}, {230, 113, 82, 166, 76, 163, 209, 71, 196, 171, 132, 30, 47, 46, 122, 153}, {127, 28, 122, 234, 144, 141, 229, 46, 62, 158, 8, 131, 238, 168, 22, 175}, {222, 130, 122, 191, 146, 183, 51, 146, 63, 53, 51, 13, 181, 239, 74, 52}, {89, 117, 99, 100, 15, 55, 154, 197, 55, 103, 142, 226, 53, 76, 125, 249}, {40, 77, 3, 48, 58, 69, 58, 89, 61, 120, 247, 250, 220, 144, 98, 203}, {145, 74, 199, 162, 89, 127, 99, 183, 192, 253, 229, 171, 141, 78, 173, 156}, {13, 81, 21, 164, 75, 164, 85, 238, 58, 69, 59, 149, 206, 135, 195, 203}, {84, 155, 147, 157, 11, 241, 216, 148, 131, 55, 136, 90, 132, 206, 121, 20}, {108, 23, 151, 105, 205, 52, 138, 235, 210, 251, 19, 87, 140, 114, 180, 108}, {170, 208, 54, 193, 56, 201, 87, 224, 104, 42, 0, 238, 47, 134, 64, 139}, {33, 177, 238, 196, 47, 182, 112, 191, 238, 144, 68, 255, 78, 215, 58, 38}, {5, 147, 161, 214, 41, 151, 237, 55, 70, 83, 201, 23, 70, 63, 20, 235}, {17, 61, 49, 98, 119, 25, 249, 30, 160, 241, 255, 198, 134, 87, 226, 78}, {179, 57, 76, 247, 45, 224, 106, 221, 14, 115, 20, 240, 194, 82, 196, 214}, {146, 42, 152, 218, 157, 53, 195, 65, 226, 69, 107, 228, 205, 99, 137, 210}, {89, 107, 98, 48, 247, 87, 179, 74, 162, 220, 234, 80, 203, 178, 141, 77}, {194, 78, 228, 151, 213, 91, 126, 128, 6, 132, 223, 117, 101, 89, 238, 72}, {94, 156, 182, 161, 54, 104, 30, 212, 94, 43, 157, 228, 220, 1, 129, 119}, {191, 250, 57, 202, 134, 86, 211, 4, 121, 51, 237, 254, 157, 129, 120, 178}, {24, 34, 148, 24, 161, 208, 121, 90, 53, 122, 128, 58, 129, 52, 174, 163}, {74, 62, 150, 255, 83, 71, 78, 46, 115, 123, 105, 87, 26, 119, 176, 110}, {254, 213, 240, 249, 208, 55, 114, 132, 46, 47, 87, 47, 99, 241, 148, 80}, {57, 51, 88, 134, 193, 249, 66, 99, 196, 12, 102, 41, 198, 188, 68, 111}, {238, 165, 249, 59, 179, 135, 16, 176, 139, 44, 70, 151, 25, 139, 191, 159}, {128, 110, 199, 182, 112, 79, 114, 14, 55, 67, 18, 6, 97, 102, 212, 58}, {110, 105, 237, 157, 240, 201, 57, 180, 157, 175, 238, 174, 96, 71, 178, 162}, {147, 199, 123, 242, 152, 182, 249, 199, 148, 162, 48, 23, 127, 47, 215, 56}, {255, 173, 156, 217, 140, 42, 168, 117, 218, 255, 58, 42, 76, 230, 12, 230}, {77, 153, 47, 253, 249, 74, 147, 205, 205, 100, 239, 118, 87, 245, 16, 227}, {50, 112, 98, 78, 36, 224, 161, 30, 161, 134, 224, 150, 190, 27, 206, 155}, {49, 232, 187, 224, 203, 78, 255, 81, 31, 255, 199, 196, 9, 52, 49, 119}, {203, 225, 125, 5, 135, 154, 217, 7, 100, 138, 18, 160, 112, 22, 171, 91}, {136, 72, 212, 67, 112, 233, 139, 226, 213, 210, 139, 70, 54, 106, 10, 252}, {183, 255, 209, 178, 66, 16, 118, 169, 12, 181, 207, 101, 84, 9, 94, 12}, {106, 107, 102, 108, 213, 35, 168, 246, 187, 216, 132, 254, 31, 209, 5, 12}, {168, 254, 138, 131, 80, 251, 245, 200, 5, 241, 140, 189, 48, 19, 98, 36}, {204, 231, 17, 122, 238, 130, 54, 242, 235, 58, 150, 148, 213, 126, 98, 181}, {58, 37, 240, 228, 252, 40, 183, 12, 107, 48, 144, 186, 254, 246, 159, 4}, {63, 5, 230, 38, 116, 159, 196, 139, 129, 6, 248, 228, 68, 49, 221, 74}, {118, 104, 121, 249, 118, 114, 22, 92, 10, 255, 213, 250, 220, 119, 52, 91}, {67, 113, 160, 90, 182, 108, 89, 139, 201, 194, 132, 148, 161, 221, 47, 14}, {101, 248, 91, 211, 162, 165, 241, 186, 31, 34, 182, 239, 214, 224, 2, 102}, {118, 207, 97, 218, 229, 75, 34, 239, 202, 106, 159, 34, 138, 175, 102, 17}, {108, 220, 194, 227, 159, 219, 162, 159, 136, 83, 144, 171, 157, 164, 132, 218}, {225, 238, 172, 234, 204, 59, 103, 178, 216, 228, 226, 97, 123, 47, 170, 90}, {11, 210, 159, 111, 76, 225, 15, 23, 120, 214, 176, 46, 213, 171, 90, 109}, {173, 24, 159, 21, 106, 82, 38, 124, 224, 135, 69, 131, 91, 101, 166, 7}, {15, 107, 153, 113, 114, 37, 102, 212, 61, 236, 107, 153, 227, 28, 33, 143}, {161, 164, 200, 250, 79, 61, 244, 102, 211, 243, 156, 111, 61, 158, 26, 116}, {59, 26, 61, 184, 140, 240, 194, 31, 193, 166, 216, 167, 45, 158, 249, 29}, {209, 72, 104, 2, 239, 192, 0, 40, 86, 195, 99, 90, 138, 105, 46, 229}, {238, 161, 95, 143, 124, 174, 25, 153, 253, 86, 73, 49, 194, 44, 28, 60}, {99, 245, 174, 99, 40, 196, 219, 147, 32, 121, 97, 238, 144, 107, 212, 165}};
        this.performTest(4, 8, vectors_sip128);
    }

    private void performTest(int cRounds, int dRounds, int[][] testvectorsInt) throws Exception {
        int n = testvectorsInt.length;
        int macSize = testvectorsInt[0].length;
        byte[][] testvectors = new byte[n][];
        int i = 0;
        while (i < n) {
            testvectors[i] = new byte[macSize];
            int j = 0;
            while (j < macSize) {
                testvectors[i][j] = (byte)testvectorsInt[i][j];
                ++j;
            }
            ++i;
        }
        byte[] key = Hex.decode((String)"000102030405060708090a0b0c0d0e0f");
        int i2 = 0;
        while (i2 < n) {
            byte[] input = new byte[i2];
            int j = 0;
            while (j < input.length) {
                input[j] = (byte)j;
                ++j;
            }
            this.runMAC(cRounds, dRounds, testvectors[i2], key, input);
            ++i2;
        }
        SecureRandom random = new SecureRandom();
        int i3 = 0;
        while (i3 < 100) {
            this.randomTest(cRounds, dRounds, random);
            ++i3;
        }
    }

    private void runMAC(int cRounds, int dRounds, byte[] expected, byte[] key, byte[] input) throws Exception {
        this.runMAC(cRounds, dRounds, expected, key, input, 0);
        this.runMAC(cRounds, dRounds, expected, key, input, 1);
        this.runMAC(cRounds, dRounds, expected, key, input, 2);
    }

    private void runMAC(int cRounds, int dRounds, byte[] expected, byte[] key, byte[] input, int updateType) throws Exception {
        SipHash128 mac = new SipHash128(cRounds, dRounds);
        mac.init((CipherParameters)new KeyParameter(key));
        this.updateMAC(mac, input, updateType);
        byte[] output = new byte[mac.getMacSize()];
        int len = mac.doFinal(output, 0);
        if (len != output.length) {
            this.fail("Result length does not equal getMacSize() for doFinal(byte[],int)");
        }
        if (!this.areEqual(expected, output)) {
            this.fail("Result does not match expected value for doFinal(byte[],int)");
        }
    }

    private void randomTest(int cRounds, int dRounds, SecureRandom random) {
        byte[] key = new byte[16];
        random.nextBytes(key);
        int length = 1 + RNGUtils.nextInt(random, 1024);
        byte[] input = new byte[length];
        random.nextBytes(input);
        SipHash128 mac = new SipHash128(cRounds, dRounds);
        mac.init((CipherParameters)new KeyParameter(key));
        this.updateMAC(mac, input, 0);
        byte[] result1 = new byte[16];
        mac.doFinal(result1, 0);
        this.updateMAC(mac, input, 1);
        byte[] result2 = new byte[16];
        mac.doFinal(result2, 0);
        this.updateMAC(mac, input, 2);
        byte[] result3 = new byte[16];
        mac.doFinal(result3, 0);
        if (!Arrays.areEqual((byte[])result1, (byte[])result2) || !Arrays.areEqual((byte[])result1, (byte[])result3)) {
            this.fail("Inconsistent results in random test");
        }
    }

    private void updateMAC(SipHash128 mac, byte[] input, int updateType) {
        switch (updateType) {
            case 0: {
                int i = 0;
                while (i < input.length) {
                    mac.update(input[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                mac.update(input, 0, input.length);
                break;
            }
            case 2: {
                int step = Math.max(1, input.length / 3);
                int pos = 0;
                while (pos < input.length) {
                    mac.update(input[pos++]);
                    int len = Math.min(input.length - pos, step);
                    mac.update(input, pos, len);
                    pos += len;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new SipHash128Test());
    }
}

