/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Salsa20Test
extends SimpleTest {
    byte[] zeroes = Hex.decode((String)"00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    String set1v0_0 = "4DFA5E481DA23EA09A31022050859936DA52FCEE218005164F267CB65F5CFD7F2B4F97E0FF16924A52DF269515110A07F9E460BC65EF95DA58F740B7D1DBB0AA";
    String set1v0_192 = "DA9C1581F429E0A00F7D67E23B730676783B262E8EB43A25F55FB90B3E753AEF8C6713EC66C51881111593CCB3E8CB8F8DE124080501EEEB389C4BCB6977CF95";
    String set1v0_256 = "7D5789631EB4554400E1E025935DFA7B3E9039D61BDC58A8697D36815BF1985CEFDF7AE112E5BB81E37ECF0616CE7147FC08A93A367E08631F23C03B00A8DA2F";
    String set1v0_448 = "B375703739DACED4DD4059FD71C3C47FC2F9939670FAD4A46066ADCC6A5645783308B90FFB72BE04A6B147CBE38CC0C3B9267C296A92A7C69873F9F263BE9703";
    String set1v9_0 = "0471076057830FB99202291177FBFE5D38C888944DF8917CAB82788B91B53D1CFB06D07A304B18BB763F888A61BB6B755CD58BEC9C4CFB7569CB91862E79C459";
    String set1v9_192 = "D1D7E97556426E6CFC21312AE38114259E5A6FB10DACBD88E4354B04725569352B6DA5ACAFACD5E266F9575C2ED8E6F2EFE4B4D36114C3A623DD49F4794F865B";
    String set1v9_256 = "AF06FAA82C73291231E1BD916A773DE152FD2126C40A10C3A6EB40F22834B8CC68BD5C6DBD7FC1EC8F34165C517C0B639DB0C60506D3606906B8463AA0D0EC2F";
    String set1v9_448 = "AB3216F1216379EFD5EC589510B8FD35014D0AA0B613040BAE63ECAB90A9AF79661F8DA2F853A5204B0F8E72E9D9EB4DBA5A4690E73A4D25F61EE7295215140C";
    String set6v0_0 = "F5FAD53F79F9DF58C4AEA0D0ED9A9601F278112CA7180D565B420A48019670EAF24CE493A86263F677B46ACE1924773D2BB25571E1AA8593758FC382B1280B71";
    String set6v0_65472 = "B70C50139C63332EF6E77AC54338A4079B82BEC9F9A403DFEA821B83F7860791650EF1B2489D0590B1DE772EEDA4E3BCD60FA7CE9CD623D9D2FD5758B8653E70";
    String set6v0_65536 = "81582C65D7562B80AEC2F1A673A9D01C9F892A23D4919F6AB47B9154E08E699B4117D7C666477B60F8391481682F5D95D96623DBC489D88DAA6956B9F0646B6E";
    String set6v1_0 = "3944F6DC9F85B128083879FDF190F7DEE4053A07BC09896D51D0690BD4DA4AC1062F1E47D3D0716F80A9B4D85E6D6085EE06947601C85F1A27A2F76E45A6AA87";
    String set6v1_65472 = "36E03B4B54B0B2E04D069E690082C8C592DF56E633F5D8C7682A02A65ECD13718CA4352AACCB0DA20ED6BBBA62E177F210E3560E63BB822C4158CAA806A88C82";
    String set6v1_65536 = "1B779E7A917C8C26039FFB23CF0EF8E08A1A13B43ACDD9402CF5DF38501098DFC945A6CC69A6A17367BC03431A86B3ED04B0245B56379BF997E25800AD837D7D";
    String salsa12_set1v0_0 = "FC207DBFC76C5E1774961E7A5AAD09069B2225AC1CE0FE7A0CE77003E7E5BDF8B31AF821000813E6C56B8C1771D6EE7039B2FBD0A68E8AD70A3944B677937897";
    String salsa12_set1v0_192 = "4B62A4881FA1AF9560586510D5527ED48A51ECAFA4DECEEBBDDC10E9918D44AB26B10C0A31ED242F146C72940C6E9C3753F641DA84E9F68B4F9E76B6C48CA5AC";
    String salsa12_set1v0_256 = "F52383D9DEFB20810325F7AEC9EADE34D9D883FEE37E05F74BF40875B2D0BE79ED8886E5BFF556CEA8D1D9E86B1F68A964598C34F177F8163E271B8D2FEB5996";
    String salsa12_set1v0_448 = "A52ED8C37014B10EC0AA8E05B5CEEE123A1017557FB3B15C53E6C5EA8300BF74264A73B5315DC821AD2CAB0F3BB2F152BDAEA3AEE97BA04B8E72A7B40DCC6BA4";
    String salsa8_set1v0_0 = "A9C9F888AB552A2D1BBFF9F36BEBEB337A8B4B107C75B63BAE26CB9A235BBA9D784F38BEFC3ADF4CD3E266687EA7B9F09BA650AE81EAC6063AE31FF12218DDC5";
    String salsa8_set1v0_192 = "BB5B6BB2CC8B8A0222DCCC1753ED4AEB23377ACCBD5D4C0B69A8A03BB115EF71871BC10559080ACA7C68F0DEF32A80DDBAF497259BB76A3853A7183B51CC4B9F";
    String salsa8_set1v0_256 = "4436CDC0BE39559F5E5A6B79FBDB2CAE4782910F27FFC2391E05CFC78D601AD8CD7D87B074169361D997D1BED9729C0DEB23418E0646B7997C06AA84E7640CE3";
    String salsa8_set1v0_448 = "BEE85903BEA506B05FC04795836FAAAC7F93F785D473EB762576D96B4A65FFE463B34AAE696777FC6351B67C3753B89BA6B197BD655D1D9CA86E067F4D770220";

    public String getName() {
        return "Salsa20";
    }

    public void performTest() {
        this.salsa20Test1(20, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), Hex.decode((String)"0000000000000000")), this.set1v0_0, this.set1v0_192, this.set1v0_256, this.set1v0_448);
        this.salsa20Test1(20, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"00400000000000000000000000000000")), Hex.decode((String)"0000000000000000")), this.set1v9_0, this.set1v9_192, this.set1v9_256, this.set1v9_448);
        this.salsa20Test1(12, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), Hex.decode((String)"0000000000000000")), this.salsa12_set1v0_0, this.salsa12_set1v0_192, this.salsa12_set1v0_256, this.salsa12_set1v0_448);
        this.salsa20Test1(8, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"80000000000000000000000000000000")), Hex.decode((String)"0000000000000000")), this.salsa8_set1v0_0, this.salsa8_set1v0_192, this.salsa8_set1v0_256, this.salsa8_set1v0_448);
        this.salsa20Test2((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D")), Hex.decode((String)"0D74DB42A91077DE")), this.set6v0_0, this.set6v0_65472, this.set6v0_65536);
        this.salsa20Test2((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"0558ABFE51A4F74A9DF04396E93C8FE23588DB2E81D4277ACD2073C6196CBF12")), Hex.decode((String)"167DE44BB21980E7")), this.set6v1_0, this.set6v1_65472, this.set6v1_65536);
        this.reinitBug();
        this.skipTest();
    }

    private void salsa20Test1(int rounds, CipherParameters params, String v0, String v192, String v256, String v448) {
        Salsa20Engine salsa = new Salsa20Engine(rounds);
        byte[] buf = new byte[64];
        salsa.init(true, params);
        int i = 0;
        while (i != 7) {
            salsa.processBytes(this.zeroes, 0, 64, buf, 0);
            switch (i) {
                case 0: {
                    if (this.areEqual(buf, Hex.decode((String)v0))) break;
                    this.mismatch("v0/" + rounds, v0, buf);
                    break;
                }
                case 3: {
                    if (this.areEqual(buf, Hex.decode((String)v192))) break;
                    this.mismatch("v192/" + rounds, v192, buf);
                    break;
                }
                case 4: {
                    if (this.areEqual(buf, Hex.decode((String)v256))) break;
                    this.mismatch("v256/" + rounds, v256, buf);
                    break;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 != 64) {
            buf[i2] = salsa.returnByte(this.zeroes[i2]);
            ++i2;
        }
        if (!this.areEqual(buf, Hex.decode((String)v448))) {
            this.mismatch("v448", v448, buf);
        }
    }

    private void salsa20Test2(CipherParameters params, String v0, String v65472, String v65536) {
        Salsa20Engine salsa = new Salsa20Engine();
        byte[] buf = new byte[64];
        salsa.init(true, params);
        int i = 0;
        while (i != 1025) {
            salsa.processBytes(this.zeroes, 0, 64, buf, 0);
            switch (i) {
                case 0: {
                    if (this.areEqual(buf, Hex.decode((String)v0))) break;
                    this.mismatch("v0", v0, buf);
                    break;
                }
                case 1023: {
                    if (this.areEqual(buf, Hex.decode((String)v65472))) break;
                    this.mismatch("v65472", v65472, buf);
                    break;
                }
                case 1024: {
                    if (this.areEqual(buf, Hex.decode((String)v65536))) break;
                    this.mismatch("v65536", v65536, buf);
                    break;
                }
            }
            ++i;
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode((byte[])found)));
    }

    private void reinitBug() {
        KeyParameter key = new KeyParameter(Hex.decode((String)"80000000000000000000000000000000"));
        ParametersWithIV parameters = new ParametersWithIV((CipherParameters)key, Hex.decode((String)"0000000000000000"));
        Salsa20Engine salsa = new Salsa20Engine();
        salsa.init(true, (CipherParameters)parameters);
        try {
            salsa.init(true, (CipherParameters)key);
            this.fail("Salsa20 should throw exception if no IV in Init");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private boolean areEqual(byte[] a, int aOff, byte[] b, int bOff) {
        int i = bOff;
        while (i != b.length) {
            if (a[aOff + i - bOff] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void skipTest() {
        long pos;
        SecureRandom rand = new SecureRandom();
        byte[] plain = new byte[50000];
        byte[] cipher = new byte[50000];
        rand.nextBytes(plain);
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)"0053A6F94C9FF24598EB3E91E4378ADD3083D6297CCF2275C81B6EC11467BA0D")), Hex.decode((String)"0D74DB42A91077DE"));
        Salsa20Engine engine = new Salsa20Engine();
        engine.init(true, (CipherParameters)params);
        engine.processBytes(plain, 0, plain.length, cipher, 0);
        byte[] fragment = new byte[20];
        engine.init(true, (CipherParameters)params);
        engine.skip(10L);
        engine.processBytes(plain, 10, fragment.length, fragment, 0);
        if (!this.areEqual(cipher, 10, fragment, 0)) {
            this.fail("skip forward 10 failed");
        }
        engine.skip(1000L);
        engine.processBytes(plain, 1010 + fragment.length, fragment.length, fragment, 0);
        if (!this.areEqual(cipher, 1010 + fragment.length, fragment, 0)) {
            this.fail("skip forward 1000 failed");
        }
        engine.skip(-10L);
        engine.processBytes(plain, 1010 + 2 * fragment.length - 10, fragment.length, fragment, 0);
        if (!this.areEqual(cipher, 1010 + 2 * fragment.length - 10, fragment, 0)) {
            this.fail("skip back 10 failed");
        }
        engine.skip(-1000L);
        if (engine.getPosition() != 60L) {
            this.fail("skip position incorrect - 60 got " + engine.getPosition());
        }
        engine.processBytes(plain, 60, fragment.length, fragment, 0);
        if (!this.areEqual(cipher, 60, fragment, 0)) {
            this.fail("skip back 1000 failed");
        }
        if ((pos = engine.seekTo(1010L)) != 1010L) {
            this.fail("position wrong");
        }
        engine.processBytes(plain, 1010, fragment.length, fragment, 0);
        if (!this.areEqual(cipher, 1010, fragment, 0)) {
            this.fail("seek to 1010 failed");
        }
        engine.reset();
        int i = 0;
        while (i != 5000) {
            engine.skip((long)i);
            if (engine.getPosition() != (long)i) {
                this.fail("skip forward at wrong position");
            }
            engine.processBytes(plain, i, fragment.length, fragment, 0);
            if (!this.areEqual(cipher, i, fragment, 0)) {
                this.fail("skip forward i failed: " + i);
            }
            if (engine.getPosition() != (long)(i + fragment.length)) {
                this.fail("cipher at wrong position: " + engine.getPosition() + " [" + i + "]");
            }
            engine.skip((long)(-fragment.length));
            if (engine.getPosition() != (long)i) {
                this.fail("skip back at wrong position");
            }
            engine.processBytes(plain, i, fragment.length, fragment, 0);
            if (!this.areEqual(cipher, i, fragment, 0)) {
                this.fail("skip back i failed: " + i);
            }
            engine.reset();
            ++i;
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new Salsa20Test());
    }
}

