/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.IOException;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.fpe.FPEEngine;
import org.bouncycastle.crypto.fpe.FPEFF1Engine;
import org.bouncycastle.crypto.fpe.FPEFF3_1Engine;
import org.bouncycastle.crypto.params.FPEParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.util.BasicAlphabetMapper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SP80038GTest
extends SimpleTest {
    private static FFSample[] ff1Samples = new FFSample[]{FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789", "2433477484", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789", "6124200773", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3C", "0123456789abcdefghi", "a9tv40mll9kdu509eum", "3737373770717273373737"), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789", "2830668132", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789", "2496655549", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F", "0123456789abcdefghi", "xbj3kv35jrawxv32ysr", "3737373770717273373737"), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789", "6657667009", ""), FFSample.from(10, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789", "1001623463", "39383736353433323130"), FFSample.from(36, "2B7E151628AED2A6ABF7158809CF4F3CEF4359D8D580AA4F7F036D6F04FC6A94", "0123456789abcdefghi", "xs8a0azh2avyalyzuwd", "3737373770717273373737")};
    private static FFSample[] ff3_1Samples = new FFSample[]{FFSample.from(62, "7793833CE891B496381BD5B882F77EA1", "YbpT3hDo0J9xwCQ5qUWt93iv", "dDEYxViK56lGbV1WdZTPTe4w", "C58797C2580174")};

    private void testFF1() throws Exception {
        int i = 0;
        while (i < ff1Samples.length) {
            this.testFF1Sample(ff1Samples[i]);
            ++i;
        }
        byte[] key = Hex.decode((String)"EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] plainText = Hex.decode((String)"0327035100210215");
        byte[] tweak = Hex.decode((String)"39383736353433323130");
        FPEFF1Engine fpeEngine = new FPEFF1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), 24, tweak));
        try {
            fpeEngine.processBlock(plainText, 0, plainText.length, plainText, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input data outside of radix", e.getMessage());
        }
        try {
            fpeEngine.processBlock(new byte[]{1}, 0, 1, plainText, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input too short", e.getMessage());
        }
    }

    public void testFF1w() throws Exception {
        byte[] key = Hex.decode((String)"EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] plainText = Hex.decode((String)"0327035100210215");
        byte[] cipherText = Hex.decode((String)"022701f80217020a");
        byte[] tweak = Hex.decode((String)"39383736353433323130");
        FPEFF1Engine fpeEngine = new FPEFF1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), 1024, tweak));
        byte[] enc = new byte[plainText.length];
        fpeEngine.processBlock(plainText, 0, plainText.length, enc, 0);
        this.isTrue(this.areEqual(cipherText, enc));
        fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(key), 1024, tweak));
        fpeEngine.processBlock(cipherText, 0, cipherText.length, enc, 0);
        this.isTrue(this.areEqual(plainText, enc));
        byte[] outPt = Hex.decode((String)"03270F5100210215");
        try {
            fpeEngine.processBlock(outPt, 0, outPt.length, enc, 0);
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input data outside of radix", e.getMessage());
        }
    }

    public void testFF3_1() throws Exception {
        int i = 0;
        while (i < ff3_1Samples.length) {
            this.testFF3_1Sample(ff3_1Samples[i]);
            ++i;
        }
        byte[] key = Hex.decode((String)"EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] plainText = Hex.decode((String)"0327035100210215");
        byte[] tweak = Hex.decode((String)"39383736353433");
        FPEFF3_1Engine fpeEngine = new FPEFF3_1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), 24, tweak));
        try {
            fpeEngine.processBlock(plainText, 0, plainText.length, plainText, 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input data outside of radix", e.getMessage());
        }
        try {
            fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), 24, Hex.decode((String)"beef")));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("tweak should be 56 bits", e.getMessage());
        }
    }

    private void testFF3_1w() throws Exception {
        byte[] key = Hex.decode((String)"EF4359D8D580AA4F7F036D6F04FC6A942B7E151628AED2A6");
        byte[] plainText = Hex.decode((String)"0327035100210215");
        byte[] cipherText = Hex.decode((String)"02fb024900310220");
        byte[] tweak = Hex.decode((String)"39383736353433");
        FPEFF3_1Engine fpeEngine = new FPEFF3_1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), 1024, tweak));
        byte[] enc = new byte[plainText.length];
        fpeEngine.processBlock(plainText, 0, plainText.length, enc, 0);
        this.isTrue("enc failed: " + Hex.toHexString((byte[])enc), this.areEqual(cipherText, enc));
        fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(key), 1024, tweak));
        fpeEngine.processBlock(cipherText, 0, cipherText.length, enc, 0);
        this.isTrue(this.areEqual(plainText, enc));
        byte[] outPt = Hex.decode((String)"03270F5100210215");
        try {
            fpeEngine.processBlock(outPt, 0, outPt.length, enc, 0);
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input data outside of radix", e.getMessage());
        }
    }

    private void testDisable() throws Exception {
        System.setProperty("org.bouncycastle.fpe.disable", "true");
        try {
            this.testFF1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException e) {
            this.isEquals("FF1 encryption disabled", e.getMessage());
        }
        try {
            this.testFF3_1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException e) {
            this.isEquals("FPE disabled", e.getMessage());
        }
        System.setProperty("org.bouncycastle.fpe.disable", "false");
        System.setProperty("org.bouncycastle.fpe.disable_ff1", "true");
        try {
            this.testFF1();
            this.fail("no exception");
        }
        catch (UnsupportedOperationException e) {
            this.isEquals("FF1 encryption disabled", e.getMessage());
        }
        this.testFF3_1();
        System.setProperty("org.bouncycastle.fpe.disable_ff1", "false");
    }

    private void testFF3_1_255() {
        byte[] key = Hex.decode((String)"339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] tweak = Hex.decode((String)"3F096DE35BFA31");
        int radix = 256;
        FPEFF3_1Engine fpeEngine = new FPEFF3_1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), radix, tweak));
        long valueToEncrypt = 210462922239L;
        byte[] bytes = Pack.longToBigEndian((long)valueToEncrypt);
        byte[] enc = new byte[bytes.length];
        fpeEngine.processBlock(bytes, 0, bytes.length, enc, 0);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"18fa139dc978a681"), (byte[])enc));
        fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(key), radix, tweak));
        fpeEngine.processBlock(enc, 0, enc.length, enc, 0);
        this.isTrue(Arrays.areEqual((byte[])bytes, (byte[])enc));
    }

    private void testExceptions() {
        byte[] key = Hex.decode((String)"339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] tweak = Hex.decode((String)"3F096DE35BFA31");
        int radix = 256;
        FPEFF3_1Engine fpeEngine = new FPEFF3_1Engine();
        try {
            fpeEngine.processBlock(null, 0, 0, null, 0);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("FPE engine not initialized", e.getMessage());
        }
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), radix, tweak));
        try {
            fpeEngine.processBlock(null, 0, 0, null, 0);
            this.fail("no exception");
        }
        catch (NullPointerException e) {
            this.isEquals("buffer value is null", ((Throwable)e).getMessage());
        }
        try {
            fpeEngine.processBlock(new byte[2], 0, 2, null, 0);
            this.fail("no exception");
        }
        catch (NullPointerException e) {
            this.isEquals("buffer value is null", ((Throwable)e).getMessage());
        }
        try {
            fpeEngine.processBlock(new byte[2], 0, -1, new byte[2], 0);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input length cannot be negative", e.getMessage());
        }
        try {
            fpeEngine.processBlock(new byte[4], 0, 6, new byte[6], 0);
            this.fail("no exception");
        }
        catch (DataLengthException e) {
            this.isEquals("input buffer too short", e.getMessage());
        }
        try {
            fpeEngine.processBlock(new byte[4], 0, 4, new byte[2], 0);
            this.fail("no exception");
        }
        catch (OutputLengthException e) {
            this.isEquals("output buffer too short", e.getMessage());
        }
    }

    private void testFF1Sample(FFSample ff1) {
        FPEFF1Engine fpeEngine = new FPEFF1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(ff1.getKey()), ff1.getRadix(), ff1.getTweak()));
        byte[] plain = ff1.getPlaintext();
        byte[] enc = new byte[plain.length];
        fpeEngine.processBlock(plain, 0, plain.length, enc, 0);
        this.isTrue(this.areEqual(ff1.getCiphertext(), enc));
        fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(ff1.getKey()), ff1.getRadix(), ff1.getTweak()));
        fpeEngine.processBlock(ff1.ciphertext, 0, ff1.ciphertext.length, enc, 0);
        this.isTrue(this.areEqual(ff1.getPlaintext(), enc));
    }

    private void testFF3_1Sample(FFSample ff3_1) throws Exception {
        FPEFF3_1Engine fpeEngine = new FPEFF3_1Engine();
        fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(ff3_1.getKey()), ff3_1.getRadix(), ff3_1.getTweak()));
        byte[] plain = ff3_1.getPlaintext();
        byte[] enc = new byte[plain.length];
        fpeEngine.processBlock(plain, 0, plain.length, enc, 0);
        this.isTrue(Arrays.areEqual((byte[])ff3_1.getCiphertext(), (byte[])enc));
        fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(ff3_1.getKey()), ff3_1.getRadix(), ff3_1.getTweak()));
        fpeEngine.processBlock(ff3_1.getCiphertext(), 0, plain.length, enc, 0);
        this.isTrue(Arrays.areEqual((byte[])ff3_1.getPlaintext(), (byte[])enc));
    }

    public void testFF1Bounds() throws IOException {
        BasicAlphabetMapper alphabetMapper;
        byte[] key = Hex.decode((String)"339BB5B1F2D44BAABF87CA1B7380CDC8");
        byte[] tweak = Hex.decode((String)"3F096DE35BFA31");
        FPEFF1Engine fpeEngine = new FPEFF1Engine();
        try {
            alphabetMapper = new BasicAlphabetMapper("ABCDEFGHI");
            fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), alphabetMapper.getRadix(), tweak));
            this.process((FPEEngine)fpeEngine, new byte[]{1, 2, 3});
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input too short", e.getMessage());
        }
        try {
            alphabetMapper = new BasicAlphabetMapper("ABCD");
            fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), alphabetMapper.getRadix(), tweak));
            this.process((FPEEngine)fpeEngine, new byte[]{1, 2, 3});
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input too short", e.getMessage());
        }
    }

    public void testFF1Rounding() {
        int radix = 256;
        byte[] key = Hex.decodeStrict((String)"000102030405060708090a0b0c0d0e0f");
        byte[] tweak = Hex.decodeStrict((String)"0001020304050607");
        byte[] asciiPT = Hex.decodeStrict((String)"000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738");
        byte[] asciiCT = Hex.decodeStrict((String)"dc18bef8b7d23aa77d1daf7a50c2253c4bacb772129f70805ecd413775bc3bdf7927ce70f455dacf4fdf61b61ac73a5c90fd3d1759dca0bf27");
        byte[] result = new byte[asciiPT.length];
        FPEFF1Engine fpeEngine = new FPEFF1Engine();
        FPEParameters fpeParameters = new FPEParameters(new KeyParameter(key), radix, tweak);
        fpeEngine.init(true, (CipherParameters)fpeParameters);
        fpeEngine.processBlock(asciiPT, 0, asciiPT.length, result, 0);
        this.isTrue("Failed FF1 rounding test (encryption)", this.areEqual(asciiCT, result));
        fpeEngine.init(false, (CipherParameters)fpeParameters);
        fpeEngine.processBlock(asciiCT, 0, asciiCT.length, result, 0);
        this.isTrue("Failed FF1 rounding test (decryption)", this.areEqual(asciiPT, result));
    }

    private void testFF3_1Bounds() throws IOException {
        String bigAlpha = "+-ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz";
        BasicAlphabetMapper alphabetMapper = new BasicAlphabetMapper(bigAlpha);
        this.ff3_1Test((AlphabetMapper)alphabetMapper, "467094C27E47978FE616F475215BF4F1", "ECC8AA7B87B41C", "9RwG+t8cKfa9JweBYgHAA6fHUShNZ5tc", "-DXMBhb3AFPq5Xf4oUva4WbB8eagGK2u");
        this.ff3_1Test((AlphabetMapper)alphabetMapper, "4DB04B58E97819015A08BA7A39A79C303968A34DB0936FAD", "26B3A632FAADFE", "k5Kop6xYpT0skr1zHHPEt5rPWQ4s4O-3", "JyWzuPL6SNsciOXdEgwnKZJxHiKaTu4Z");
        this.ff3_1Test((AlphabetMapper)alphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "ZpztPp90Oo5ekoNRzqArsAqAbnmM--W6", "NPxEDufvnYzVX3jxupv+iJOuPVpWRPjD");
        try {
            this.ff3_1Test((AlphabetMapper)alphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "ZpztPp90Oo5ekoNRzqArsAqAbnmM+-W6ZZ", "L1yx-4YLQG9W1P5yTI7Wp2h0IDcRoBq1kk");
            this.fail("no exception 1");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("maximum input length is 32", e.getMessage());
        }
        try {
            this.ff3_1Test((AlphabetMapper)alphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "Z", "L");
            this.fail("no exception 2");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input too short", e.getMessage());
        }
        try {
            alphabetMapper = new BasicAlphabetMapper("ABCDEFGHI");
            this.ff3_1Test((AlphabetMapper)alphabetMapper, "15567AA6CD8CCA401ADB6A10730655AEEC10E9101FD3969A", "379B9572B687A6", "AB", "ZZ");
            this.fail("no exception 3");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("input too short", e.getMessage());
        }
    }

    private void ff3_1Test(AlphabetMapper alphabetMapper, String skey, String stweak, String input, String output) throws IOException {
        FPEFF3_1Engine fpeEncEngine = new FPEFF3_1Engine();
        FPEFF3_1Engine fpeDecEngine = new FPEFF3_1Engine();
        byte[] key = Hex.decode((String)skey);
        byte[] tweak = Hex.decode((String)stweak);
        int radix = alphabetMapper.getRadix();
        fpeEncEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), radix, tweak));
        fpeDecEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(key), radix, tweak));
        byte[] bytes = alphabetMapper.convertToIndexes(input.toCharArray());
        byte[] encryptedBytes = this.process((FPEEngine)fpeEncEngine, bytes);
        this.isEquals(output, new String(alphabetMapper.convertToChars(encryptedBytes)));
        byte[] decryptedBytes = this.process((FPEEngine)fpeDecEngine, encryptedBytes);
        this.isTrue(Arrays.areEqual((byte[])bytes, (byte[])decryptedBytes));
        char[] chars = alphabetMapper.convertToChars(decryptedBytes);
        this.isEquals(input, String.valueOf(chars));
    }

    private byte[] process(FPEEngine fpeEngine, byte[] bytes) throws IOException {
        byte[] rv = new byte[bytes.length];
        fpeEngine.processBlock(bytes, 0, bytes.length, rv, 0);
        return rv;
    }

    public void testUtility() throws Exception {
        FPECharEncryptor fpeEnc = new FPECharEncryptor((FPEEngine)new FPEFF1Engine(), Hex.decode((String)"2B7E151628AED2A6ABF7158809CF4F3C"), "0123456789".toCharArray());
        char[] input = "01234567890123456".toCharArray();
        char[] encrypted = fpeEnc.process(input);
        FPECharDecryptor fpeDec = new FPECharDecryptor((FPEEngine)new FPEFF1Engine(), Hex.decode((String)"2B7E151628AED2A6ABF7158809CF4F3C"), "0123456789".toCharArray());
        char[] decrypted = fpeDec.process(encrypted);
        this.isTrue("no match", Arrays.areEqual((char[])input, (char[])decrypted));
    }

    public String getName() {
        return "SP80038GTest";
    }

    public void performTest() throws Exception {
        this.testFF1();
        this.testFF1w();
        this.testFF1Bounds();
        this.testFF1Rounding();
        this.testFF3_1();
        this.testFF3_1w();
        this.testFF3_1_255();
        this.testFF3_1Bounds();
        this.testDisable();
        this.testUtility();
        this.testExceptions();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new SP80038GTest());
    }

    public static class FPECharDecryptor {
        private final FPEEngine fpeEngine;
        private AlphabetMapper alphabetMapper;

        public FPECharDecryptor(FPEEngine fpeEngine, byte[] key, char[] alphabet) {
            this(fpeEngine, key, new byte[0], alphabet);
        }

        public FPECharDecryptor(FPEEngine fpeEngine, byte[] key, byte[] tweak, char[] alphabet) {
            this.fpeEngine = fpeEngine;
            this.alphabetMapper = new BasicAlphabetMapper(alphabet);
            fpeEngine.init(false, (CipherParameters)new FPEParameters(new KeyParameter(key), this.alphabetMapper.getRadix(), tweak));
        }

        public char[] process(char[] input) throws IOException {
            byte[] bytes = this.alphabetMapper.convertToIndexes(input);
            this.fpeEngine.processBlock(bytes, 0, bytes.length, bytes, 0);
            return this.alphabetMapper.convertToChars(bytes);
        }
    }

    public static class FPECharEncryptor {
        private final FPEEngine fpeEngine;
        private AlphabetMapper alphabetMapper;

        public FPECharEncryptor(FPEEngine fpeEngine, byte[] key, char[] alphabet) {
            this(fpeEngine, key, new byte[0], alphabet);
        }

        public FPECharEncryptor(FPEEngine fpeEngine, byte[] key, byte[] tweak, char[] alphabet) {
            this.fpeEngine = fpeEngine;
            this.alphabetMapper = new BasicAlphabetMapper(alphabet);
            fpeEngine.init(true, (CipherParameters)new FPEParameters(new KeyParameter(key), this.alphabetMapper.getRadix(), tweak));
        }

        public char[] process(char[] input) throws IOException {
            byte[] bytes = this.alphabetMapper.convertToIndexes(input);
            this.fpeEngine.processBlock(bytes, 0, bytes.length, bytes, 0);
            return this.alphabetMapper.convertToChars(bytes);
        }
    }

    private static class FFSample {
        private final int radix;
        private final byte[] key;
        private final byte[] plaintext;
        private final byte[] ciphertext;
        private final byte[] tweak;

        public static FFSample from(int radix, String hexKey, String asciiPT, String asciiCT, String hexTweak) {
            return new FFSample(radix, FFSample.fromHex(hexKey), FFSample.fromAscii(radix, asciiPT), FFSample.fromAscii(radix, asciiCT), FFSample.fromHex(hexTweak));
        }

        private static byte fromAlphaNumeric(char c) {
            if (c >= '0' && c <= '9') {
                return (byte)(c - 48);
            }
            if (c >= 'a' && c <= 'z') {
                return (byte)(10 + (c - 97));
            }
            if (c >= 'A' && c <= 'Z') {
                return (byte)(36 + (c - 65));
            }
            throw new IllegalArgumentException();
        }

        private static byte[] fromAscii(int radix, String ascii) {
            byte[] result = new byte[ascii.length()];
            int i = 0;
            while (i < result.length) {
                result[i] = FFSample.fromAlphaNumeric(ascii.charAt(i));
                if (result[i] < 0 || result[i] >= radix) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            return result;
        }

        private static byte[] fromHex(String hex) {
            return Hex.decode((String)hex);
        }

        private FFSample(int radix, byte[] key, byte[] plaintext, byte[] ciphertext, byte[] tweak) {
            this.radix = radix;
            this.key = key;
            this.plaintext = plaintext;
            this.ciphertext = ciphertext;
            this.tweak = tweak;
        }

        public byte[] getCiphertext() {
            return this.ciphertext;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getPlaintext() {
            return this.plaintext;
        }

        public int getRadix() {
            return this.radix;
        }

        public byte[] getTweak() {
            return this.tweak;
        }
    }
}

