/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.generators.SCrypt;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SCryptTest
extends SimpleTest {
    public String getName() {
        return "SCrypt";
    }

    public void performTest() throws Exception {
        this.testPermutations();
        this.testParameters();
        this.testVectors();
    }

    public void testParameters() {
        this.checkOK("Minimal values", new byte[0], new byte[0], 2, 1, 1, 1);
        this.checkIllegal("Cost parameter must be > 1", new byte[0], new byte[0], 1, 1, 1, 1);
        this.checkOK("Cost parameter 32768 OK for r == 1", new byte[0], new byte[0], 32768, 1, 1, 1);
        this.checkIllegal("Cost parameter must < 65536 for r == 1", new byte[0], new byte[0], 65536, 1, 1, 1);
        this.checkIllegal("Block size must be >= 1", new byte[0], new byte[0], 2, 0, 2, 1);
        this.checkIllegal("Parallelisation parameter must be >= 1", new byte[0], new byte[0], 2, 1, 0, 1);
        this.checkIllegal("Parallelisation parameter must be < 65535 for r = 4", new byte[0], new byte[0], 2, 32, 65536, 1);
        this.checkIllegal("Len parameter must be > 1", new byte[0], new byte[0], 2, 1, 1, 0);
    }

    public void testPermutations() throws Exception {
        byte[] rootPassword = Strings.toByteArray((String)"aabcdd");
        byte[] buf = null;
        byte[][] salts = new byte[][]{new byte[16], new byte[16], new byte[16]};
        int t = 0;
        while (t < 16) {
            salts[1][t] = (byte)t;
            salts[2][t] = (byte)(16 - t);
            ++t;
        }
        int j = rootPassword.length - 1;
        while (j < rootPassword.length + 2) {
            buf = new byte[j];
            int a = 0;
            while (a < rootPassword.length) {
                int b = 0;
                while (b < buf.length) {
                    buf[b] = rootPassword[(a + b) % rootPassword.length];
                    ++b;
                }
                ArrayList permutations = new ArrayList();
                this.permute(permutations, buf, 0, buf.length - 1);
                int i = 0;
                while (i != permutations.size()) {
                    byte[] candidate = (byte[])permutations.get(i);
                    int k = 0;
                    while (k != salts.length) {
                        byte[] salt = salts[k];
                        byte[] expected = SCrypt.generate((byte[])rootPassword, (byte[])salt, (int)2, (int)1, (int)1, (int)32);
                        byte[] testValue = SCrypt.generate((byte[])candidate, (byte[])salt, (int)2, (int)1, (int)1, (int)32);
                        boolean sameAsRoot = Arrays.areEqual((byte[])rootPassword, (byte[])candidate);
                        this.isTrue("expected same result", sameAsRoot == Arrays.areEqual((byte[])expected, (byte[])testValue));
                        ++k;
                    }
                    ++i;
                }
                ++a;
            }
            ++j;
        }
    }

    private void swap(byte[] buf, int i, int j) {
        byte b = buf[i];
        buf[i] = buf[j];
        buf[j] = b;
    }

    private void permute(List permutation, byte[] a, int l, int r) {
        if (l == r) {
            permutation.add(Arrays.clone((byte[])a));
        } else {
            int i = l;
            while (i <= r) {
                this.swap(a, l, i);
                this.permute(permutation, a, l + 1, r);
                this.swap(a, l, i);
                ++i;
            }
        }
    }

    private void checkOK(String msg, byte[] pass, byte[] salt, int N, int r, int p, int len) {
        try {
            SCrypt.generate((byte[])pass, (byte[])salt, (int)N, (int)r, (int)p, (int)len);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.fail(msg);
        }
    }

    private void checkIllegal(String msg, byte[] pass, byte[] salt, int N, int r, int p, int len) {
        try {
            SCrypt.generate((byte[])pass, (byte[])salt, (int)N, (int)r, (int)p, (int)len);
            this.fail(msg);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testVectors() throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(TestResourceFinder.findTestResource("crypto", "SCryptTestVectors.txt")));
        int count = 0;
        String line = br.readLine();
        while (line != null) {
            byte[] result;
            ++count;
            String header = line;
            StringBuffer data = new StringBuffer();
            while (!SCryptTest.isEndData(line = br.readLine())) {
                int i = 0;
                while (i != line.length()) {
                    if (line.charAt(i) != ' ') {
                        data.append(line.charAt(i));
                    }
                    ++i;
                }
            }
            int start = header.indexOf(40) + 1;
            int limit = header.lastIndexOf(41);
            String argStr = header.substring(start, limit);
            String[] args = Strings.split((String)argStr, (char)',');
            byte[] P = SCryptTest.extractQuotedString(args[0]);
            byte[] S = SCryptTest.extractQuotedString(args[1]);
            int N = SCryptTest.extractInteger(args[2]);
            int r = SCryptTest.extractInteger(args[3]);
            int p = SCryptTest.extractInteger(args[4]);
            int dkLen = SCryptTest.extractInteger(args[5]);
            byte[] expected = Hex.decode((String)data.toString());
            if (N > 16384 || this.areEqual(expected, result = SCrypt.generate((byte[])P, (byte[])S, (int)N, (int)r, (int)p, (int)dkLen))) continue;
            this.fail("Result does not match expected value in test case " + count);
        }
        br.close();
    }

    private static boolean isEndData(String line) {
        return line == null || line.startsWith("scrypt");
    }

    private static byte[] extractQuotedString(String arg) {
        arg = arg.trim();
        arg = arg.substring(1, arg.length() - 1);
        return Strings.toByteArray((String)arg);
    }

    private static int extractInteger(String arg) {
        return Integer.parseInt(arg.trim());
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new SCryptTest());
    }
}

