/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ResetTest
extends SimpleTest {
    private static final byte[] input = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
    private static final byte[] output = Hex.decode((String)"3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53");

    public String getName() {
        return "Reset";
    }

    public void performTest() throws Exception {
        BufferedBlockCipher cipher = new BufferedBlockCipher((BlockCipher)new DESEngine());
        KeyParameter param = new KeyParameter(Hex.decode((String)"0123456789abcdef"));
        this.basicTrial(cipher, param);
        cipher.init(false, (CipherParameters)param);
        byte[] out = new byte[input.length];
        int len2 = cipher.processBytes(output, 0, output.length - 1, out, 0);
        try {
            cipher.doFinal(out, len2);
            this.fail("no DataLengthException - short input");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        len2 = cipher.processBytes(output, 0, output.length, out, 0);
        cipher.doFinal(out, len2);
        if (!this.areEqual(input, out)) {
            this.fail("failed reversal one got " + new String(Hex.encode((byte[])out)));
        }
        len2 = cipher.processBytes(output, 0, output.length - 1, out, 0);
        try {
            cipher.doFinal(out, len2);
            this.fail("no DataLengthException - short output");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        len2 = cipher.processBytes(output, 0, output.length, out, 0);
        cipher.doFinal(out, len2);
        if (!this.areEqual(input, out)) {
            this.fail("failed reversal two got " + new String(Hex.encode((byte[])out)));
        }
    }

    private void basicTrial(BufferedBlockCipher cipher, KeyParameter param) throws InvalidCipherTextException {
        cipher.init(true, (CipherParameters)param);
        byte[] out = new byte[input.length];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        cipher.doFinal(out, len1);
        if (!this.areEqual(out, output)) {
            this.fail("failed - expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ResetTest());
    }
}

