/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.kems.RSAKEMExtractor;
import org.bouncycastle.crypto.kems.RSAKEMGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.util.test.SimpleTest;

public class RSAKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "RSAKeyEncapsulation";
    }

    public void performTest() throws Exception {
        RSAKeyPairGenerator rsaGen = new RSAKeyPairGenerator();
        rsaGen.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 1024, 5));
        AsymmetricCipherKeyPair keys = rsaGen.generateKeyPair();
        KDF2BytesGenerator kdf = new KDF2BytesGenerator((Digest)new SHA1Digest());
        SecureRandom rnd = new SecureRandom();
        byte[] out = new byte[128];
        RSAKEMGenerator kemGen = new RSAKEMGenerator(16, (DerivationFunction)kdf, rnd);
        SecretWithEncapsulation secEnc = kemGen.generateEncapsulated(keys.getPublic());
        KeyParameter key1 = new KeyParameter(secEnc.getSecret());
        RSAKEMExtractor kemExt = new RSAKEMExtractor((RSAKeyParameters)keys.getPrivate(), 16, (DerivationFunction)kdf);
        KeyParameter key2 = new KeyParameter(kemExt.extractSecret(secEnc.getEncapsulation()));
        if (!this.areEqual(key1.getKey(), key2.getKey())) {
            this.fail("failed test");
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new RSAKeyEncapsulationTest());
    }
}

