/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.prng.FixedSecureRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class RFC3211WrapTest
extends SimpleTest {
    SecureRandom r1 = new FixedSecureRandom(Hex.decode((String)"C436F541"));
    SecureRandom r2 = new FixedSecureRandom(Hex.decode((String)"FA060A45"));

    public String getName() {
        return "RFC3211Wrap";
    }

    private void wrapTest(int id, BlockCipher engine, byte[] kek, byte[] iv, SecureRandom rand, byte[] in, byte[] out) throws Exception {
        RFC3211WrapEngine wrapper = new RFC3211WrapEngine(engine);
        wrapper.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(kek), iv), rand));
        byte[] cText = wrapper.wrap(in, 0, in.length);
        if (!Arrays.areEqual((byte[])cText, (byte[])out)) {
            this.fail("failed wrap test " + id + " expected " + new String(Hex.encode((byte[])out)) + " got " + new String(Hex.encode((byte[])cText)));
        }
        wrapper.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(kek), iv));
        byte[] pText = wrapper.unwrap(out, 0, out.length);
        if (!Arrays.areEqual((byte[])pText, (byte[])in)) {
            this.fail("rfailed unwrap test " + id + " expected " + new String(Hex.encode((byte[])in)) + " got " + new String(Hex.encode((byte[])pText)));
        }
    }

    private void testCorruption() throws InvalidCipherTextException {
        byte[] block;
        RFC3211WrapEngine wrapper;
        byte[] iv;
        byte[] kek;
        block2: {
            kek = Hex.decode((String)"D1DAA78615F287E6");
            iv = Hex.decode((String)"EFE598EF21B33D6D");
            wrapper = new RFC3211WrapEngine((BlockCipher)new DESEngine());
            wrapper.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(kek), iv));
            block = Hex.decode((String)"ff739D838C627C897323A2F8C436F541");
            this.encryptBlock(kek, iv, block);
            try {
                wrapper.unwrap(block, 0, block.length);
                this.fail("bad length not detected");
            }
            catch (InvalidCipherTextException e) {
                if (e.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception on length");
            }
        }
        block = Hex.decode((String)"08639D838C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, (Wrapper)wrapper);
        block = Hex.decode((String)"08736D838C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, (Wrapper)wrapper);
        block = Hex.decode((String)"08739D638C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, (Wrapper)wrapper);
    }

    private void testChecksum(byte[] kek, byte[] iv, byte[] block, Wrapper wrapper) {
        block2: {
            this.encryptBlock(kek, iv, block);
            try {
                wrapper.unwrap(block, 0, block.length);
                this.fail("bad checksum not detected");
            }
            catch (InvalidCipherTextException e) {
                if (e.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception");
            }
        }
    }

    private void encryptBlock(byte[] key, byte[] iv, byte[] cekBlock) {
        CBCBlockCipher engine = new CBCBlockCipher((BlockCipher)new DESEngine());
        engine.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        int i = 0;
        while (i < cekBlock.length) {
            engine.processBlock(cekBlock, i, cekBlock, i);
            i += 8;
        }
        int i2 = 0;
        while (i2 < cekBlock.length) {
            engine.processBlock(cekBlock, i2, cekBlock, i2);
            i2 += 8;
        }
    }

    public void performTest() throws Exception {
        this.wrapTest(1, (BlockCipher)new DESEngine(), Hex.decode((String)"D1DAA78615F287E6"), Hex.decode((String)"EFE598EF21B33D6D"), this.r1, Hex.decode((String)"8C627C897323A2F8"), Hex.decode((String)"B81B2565EE373CA6DEDCA26A178B0C10"));
        this.wrapTest(2, (BlockCipher)new DESedeEngine(), Hex.decode((String)"6A8970BF68C92CAEA84A8DF28510858607126380CC47AB2D"), Hex.decode((String)"BAF1CA7931213C4E"), this.r2, Hex.decode((String)"8C637D887223A2F965B566EB014B0FA5D52300A3F7EA40FFFC577203C71BAF3B"), Hex.decode((String)"C03C514ABDB9E2C5AAC038572B5E24553876B377AAFB82ECA5A9D73F8AB143D9EC74E6CAD7DB260C"));
        this.testCorruption();
        RFC3211WrapEngine wrapper = new RFC3211WrapEngine((BlockCipher)new DESEngine());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(new byte[16]), new byte[16]);
        byte[] buf = new byte[16];
        try {
            wrapper.init(true, (CipherParameters)params);
            wrapper.unwrap(buf, 0, buf.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException e) {
        }
        catch (InvalidCipherTextException e) {
            this.fail("unexpected exception: " + (Object)((Object)e), e);
        }
        try {
            wrapper.init(false, (CipherParameters)params);
            wrapper.wrap(buf, 0, buf.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            wrapper.init(false, (CipherParameters)params);
            wrapper.unwrap(buf, 0, buf.length / 2);
            this.fail("failed unwrap short test.");
        }
        catch (InvalidCipherTextException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new RFC3211WrapTest());
    }
}

