/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC2WrapEngine;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RC2Parameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class RC2WrapTest
implements Test {
    private TestResult wrapTest(int id, CipherParameters paramsWrap, CipherParameters paramsUnwrap, byte[] in, byte[] out) {
        RC2WrapEngine wrapper = new RC2WrapEngine();
        wrapper.init(true, paramsWrap);
        try {
            byte[] cText = wrapper.wrap(in, 0, in.length);
            if (!Arrays.areEqual((byte[])cText, (byte[])out)) {
                return new SimpleTestResult(false, this.getName() + ": failed wrap test " + id + " expected " + new String(Hex.encode((byte[])out)) + " got " + new String(Hex.encode((byte[])cText)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed wrap test exception " + e.toString(), e);
        }
        wrapper.init(false, paramsUnwrap);
        try {
            byte[] pText = wrapper.unwrap(out, 0, out.length);
            if (!Arrays.areEqual((byte[])pText, (byte[])in)) {
                return new SimpleTestResult(false, this.getName() + ": failed unwrap test " + id + " expected " + new String(Hex.encode((byte[])in)) + " got " + new String(Hex.encode((byte[])pText)));
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed unwrap test exception " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        byte[] out1;
        byte[] in1;
        RC2Parameters paramUnwrap;
        byte[] iv1;
        byte[] kek1 = Hex.decode((String)"fd04fd08060707fb0003fefffd02fe05");
        ParametersWithRandom paramWrap = new ParametersWithRandom((CipherParameters)new ParametersWithIV((CipherParameters)new RC2Parameters(kek1, 40), iv1 = Hex.decode((String)"c7d90059b29e97f7")), (SecureRandom)new RFCRandom());
        TestResult result = this.wrapTest(1, (CipherParameters)paramWrap, (CipherParameters)(paramUnwrap = new RC2Parameters(kek1, 40)), in1 = Hex.decode((String)"b70a25fbc9d86a86050ce0d711ead4d9"), out1 = Hex.decode((String)"70e699fb5701f7833330fb71e87c85a420bdc99af05d22af5a0e48d35f3138986cbaafb4b28d4f35"));
        if (!result.isSuccessful()) {
            return result;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "RC2Wrap";
    }

    public static void main(String[] args) {
        RC2WrapTest test = new RC2WrapTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    private static class RFCRandom
    extends SecureRandom {
        private RFCRandom() {
        }

        public void nextBytes(byte[] nextBytes) {
            System.arraycopy(Hex.decode((String)"4845cce7fd1250"), 0, nextBytes, 0, nextBytes.length);
        }
    }
}

