/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.FixedSecureRandom;
import org.bouncycastle.util.test.SimpleTest;

public class OAEPTest
extends SimpleTest {
    static byte[] pubKeyEnc1 = new byte[]{48, 90, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 73, 0, 48, 70, 2, 65, 0, -86, 54, -85, -50, -120, -84, -3, -1, 85, 82, 60, 127, -60, 82, 63, -112, -17, -96, 13, -13, 119, 74, 37, -97, 46, 98, -76, -59, -39, -100, -75, -83, -77, 0, -96, 40, 94, 83, 1, -109, 14, 12, 112, -5, 104, 118, -109, -100, -26, 22, -50, 98, 74, 17, -32, 8, 109, 52, 30, -68, -84, -96, -95, -11, 2, 1, 17};
    static byte[] privKeyEnc1 = new byte[]{48, -126, 1, 82, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 1, 60, 48, -126, 1, 56, 2, 1, 0, 2, 65, 0, -86, 54, -85, -50, -120, -84, -3, -1, 85, 82, 60, 127, -60, 82, 63, -112, -17, -96, 13, -13, 119, 74, 37, -97, 46, 98, -76, -59, -39, -100, -75, -83, -77, 0, -96, 40, 94, 83, 1, -109, 14, 12, 112, -5, 104, 118, -109, -100, -26, 22, -50, 98, 74, 17, -32, 8, 109, 52, 30, -68, -84, -96, -95, -11, 2, 1, 17, 2, 64, 10, 3, 55, 72, 98, 100, -121, 105, 95, 95, 48, -68, 56, -71, -117, 68, -62, -51, 45, -1, 67, 64, -104, -51, 32, -40, -95, 56, -48, -112, -65, 100, 121, 124, 63, -89, -94, -51, -53, 60, -47, -32, -67, -70, 38, 84, -76, -7, -33, -114, -118, -27, -99, 115, 61, -97, 51, -77, 1, 98, 74, -3, 29, 81, 2, 33, 0, -40, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, 51, 82, 82, 77, 4, 22, -91, -92, 65, -25, 0, -81, 70, 18, 13, 2, 33, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 90, 15, 32, 53, 2, -117, -99, -119, 2, 32, 89, 11, -107, 114, -94, -62, -87, -60, 6, 5, -99, -62, -85, 47, 29, -81, -21, 126, -117, 79, 16, -89, 84, -98, -114, -19, -11, -76, -4, -32, -98, 5, 2, 33, 0, -114, 60, 5, 33, -2, 21, -32, -22, 6, -93, 111, -16, -15, 12, -103, 82, -61, 91, 122, 117, 20, -3, 50, 56, -72, 10, -83, 82, -104, 98, -115, 81, 2, 32, 54, 63, -9, 24, -99, -88, -23, 11, 29, 52, 31, 113, -48, -101, 118, -88, -87, 67, -31, 29, 16, -78, 77, 36, -97, 45, -22, -2, -8, 12, 24, 38};
    static byte[] output1 = new byte[]{27, -113, 5, -7, -54, 26, 121, 82, 110, 83, -13, -52, 81, 79, -37, -119, 43, -5, -111, -109, 35, 30, 120, -71, -110, -26, -115, 80, -92, -128, -53, 82, 51, -119, 92, 116, -107, -115, 93, 2, -85, -116, 15, -48, 64, -21, 88, 68, -80, 5, -61, -98, -40, 39, 74, -99, -65, -88, 6, 113, 64, -108, 57, -46};
    static byte[] pubKeyEnc2 = new byte[]{48, 76, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 59, 0, 48, 56, 2, 51, 0, -93, 7, -102, -112, -33, 13, -3, 114, -84, 9, 12, -52, 42, 120, -72, 116, 19, 19, 62, 64, 117, -100, -104, -6, -8, 32, 79, 53, -118, 11, 38, 60, 103, 112, -25, -125, -87, 59, 105, 113, -73, 55, 121, -46, 113, 123, -24, 52, 119, -49, 2, 1, 3};
    static byte[] privKeyEnc2 = new byte[]{48, -126, 1, 19, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -127, -2, 48, -127, -5, 2, 1, 0, 2, 51, 0, -93, 7, -102, -112, -33, 13, -3, 114, -84, 9, 12, -52, 42, 120, -72, 116, 19, 19, 62, 64, 117, -100, -104, -6, -8, 32, 79, 53, -118, 11, 38, 60, 103, 112, -25, -125, -87, 59, 105, 113, -73, 55, 121, -46, 113, 123, -24, 52, 119, -49, 2, 1, 3, 2, 50, 108, -81, -68, 96, -108, -77, -2, 76, 114, -80, -77, 50, -58, -5, 37, -94, -73, 98, 41, -128, 78, 104, 101, -4, -92, 90, 116, -33, 15, -113, -72, 65, 59, 82, -64, -48, -27, 61, -101, 89, 15, -15, -101, -25, -97, 73, -35, 33, -27, -21, 2, 26, 0, -49, 32, 53, 2, -117, -99, -122, -104, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, -111, 2, 26, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 95, 2, 26, 0, -118, 21, 120, -84, 93, 19, -81, 16, 43, 34, -71, -103, -51, 116, 97, -15, 94, 109, 34, -52, 3, 35, -33, -33, 11, 2, 26, 0, -122, 85, 33, 74, -59, 77, -115, 78, -51, 97, 119, -15, -57, 54, -112, -50, 42, 72, 44, -117, 5, -103, -53, -32, 63, 2, 26, 0, -125, -17, -17, -72, -87, -92, 13, 29, -74, -19, -104, -83, -124, -19, 19, 53, -36, -63, 8, -13, 34, -48, 87, -49, -115};
    static byte[] output2 = new byte[]{20, -67, -35, 40, -55, -125, 53, 25, 35, -128, -24, -27, 73, -79, 88, 42, -117, 64, -76, 72, 109, 3, -90, -91, 49, 31, 31, -43, -16, -95, -128, -28, 23, 83, 3, 41, -87, 52, -112, 116, -79, 82, 19, 84, 41, 8, 36, 82, 98, 81};
    static byte[] pubKeyEnc3 = new byte[]{48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -69, -8, 47, 9, 6, -126, -50, -100, 35, 56, -84, 43, -99, -88, 113, -9, 54, -115, 7, -18, -44, 16, 67, -92, 64, -42, -74, -16, 116, 84, -11, 31, -72, -33, -70, -81, 3, 92, 2, -85, 97, -22, 72, -50, -21, 111, -51, 72, 118, -19, 82, 13, 96, -31, -20, 70, 25, 113, -99, -118, 91, -117, -128, 127, -81, -72, -32, -93, -33, -57, 55, 114, 62, -26, -76, -73, -39, 58, 37, -124, -18, 106, 100, -99, 6, 9, 83, 116, -120, 52, -78, 69, 69, -104, 57, 78, -32, -86, -79, 45, 123, 97, -91, 31, 82, 122, -102, 65, -10, -63, 104, 127, -30, 83, 114, -104, -54, 42, -113, 89, 70, -8, -27, -3, 9, 29, -67, -53, 2, 1, 17};
    static byte[] privKeyEnc3 = new byte[]{48, -126, 2, 117, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 95, 48, -126, 2, 91, 2, 1, 0, 2, -127, -127, 0, -69, -8, 47, 9, 6, -126, -50, -100, 35, 56, -84, 43, -99, -88, 113, -9, 54, -115, 7, -18, -44, 16, 67, -92, 64, -42, -74, -16, 116, 84, -11, 31, -72, -33, -70, -81, 3, 92, 2, -85, 97, -22, 72, -50, -21, 111, -51, 72, 118, -19, 82, 13, 96, -31, -20, 70, 25, 113, -99, -118, 91, -117, -128, 127, -81, -72, -32, -93, -33, -57, 55, 114, 62, -26, -76, -73, -39, 58, 37, -124, -18, 106, 100, -99, 6, 9, 83, 116, -120, 52, -78, 69, 69, -104, 57, 78, -32, -86, -79, 45, 123, 97, -91, 31, 82, 122, -102, 65, -10, -63, 104, 127, -30, 83, 114, -104, -54, 42, -113, 89, 70, -8, -27, -3, 9, 29, -67, -53, 2, 1, 17, 2, -127, -127, 0, -91, -38, -4, 83, 65, -6, -14, -119, -60, -71, -120, -37, 48, -63, -51, -8, 63, 49, 37, 30, 6, 104, -76, 39, -124, -127, 56, 1, 87, -106, 65, -78, -108, 16, -77, -57, -103, -115, 107, -60, 101, 116, 94, 92, 57, 38, 105, -42, -121, 13, -94, -64, -126, -87, 57, -29, 127, -36, -72, 46, -55, 62, -38, -55, 127, -13, -83, 89, 80, -84, -49, -68, 17, 28, 118, -15, -87, 82, -108, 68, -27, 106, -81, 104, -59, 108, 9, 44, -45, -115, -61, -66, -11, -46, 10, -109, -103, 38, -19, 79, 116, -95, 62, -35, -5, -31, -95, -50, -52, 72, -108, -81, -108, 40, -62, -73, -72, -120, 63, -28, 70, 58, 75, -56, 91, 28, -77, -63, 2, 65, 0, -18, -49, -82, -127, -79, -71, -77, -55, 8, -127, 11, 16, -95, -75, 96, 1, -103, -21, -97, 68, -82, -12, -3, -92, -109, -72, 26, -98, 61, -124, -10, 50, 18, 78, -16, 35, 110, 93, 30, 59, 126, 40, -6, -25, -86, 4, 10, 45, 91, 37, 33, 118, 69, -99, 31, 57, 117, 65, -70, 42, 88, -5, 101, -103, 2, 65, 0, -55, 127, -79, -16, 39, -12, 83, -10, 52, 18, 51, -22, -86, -47, -39, 53, 63, 108, 66, -48, -120, 102, -79, -48, 90, 15, 32, 53, 2, -117, -99, -122, -104, 64, -76, 22, 102, -76, 46, -110, -22, 13, -93, -76, 50, 4, -75, -49, -50, 51, 82, 82, 77, 4, 22, -91, -92, 65, -25, 0, -81, 70, 21, 3, 2, 64, 84, 73, 76, -90, 62, -70, 3, 55, -28, -30, 64, 35, -4, -42, -102, 90, -21, 7, -35, -36, 1, -125, -92, -48, -84, -101, 84, -80, 81, -14, -79, 62, -39, 73, 9, 117, -22, -73, 116, 20, -1, 89, -63, -9, 105, 46, -102, 46, 32, 43, 56, -4, -111, 10, 71, 65, 116, -83, -55, 60, 31, 103, -55, -127, 2, 64, 71, 30, 2, -112, -1, 10, -16, 117, 3, 81, -73, -8, 120, -122, 76, -87, 97, -83, -67, 58, -118, 126, -103, 28, 92, 5, 86, -87, 76, 49, 70, -89, -7, -128, 63, -113, 111, -118, -29, 66, -23, 49, -3, -118, -28, 122, 34, 13, 27, -103, -92, -107, -124, -104, 7, -2, 57, -7, 36, 90, -104, 54, -38, 61, 2, 65, 0, -80, 108, 79, -38, -69, 99, 1, 25, -115, 38, 91, -37, -82, -108, 35, -77, -128, -14, 113, -9, 52, 83, -120, 80, -109, 7, 127, -51, 57, -30, 17, -97, -55, -122, 50, 21, 79, 88, -125, -79, 103, -87, 103, -65, 64, 43, 78, -98, 46, 15, -106, 86, -26, -104, -22, 54, 102, -19, -5, 37, 121, -128, 57, -9};
    static byte[] output3 = Hex.decode((String)"b8246b56a6ed5881aeb585d9a25b2ad790c417e080681bf1ac2bc3deb69d8bcef0c4366fec400af052a72e9b0effb5b3f2f192dbeaca03c12740057113bf1f0669ac22e9f3a7852e3c15d913cab0b8863a95c99294ce8674214954610346f4d474b26f7c48b42ee68e1f572a1fc4026ac456b4f59f7b621ea1b9d88f64202fb1");
    byte[] seed = new byte[]{-86, -3, 18, -10, 89, -54, -26, 52, -119, -76, 121, -27, 7, 109, -34, -62, -16, 108, -75, -113};
    byte[] modulus_1024 = Hex.decode((String)"a8b3b284af8eb50b387034a860f146c4919f318763cd6c5598c8ae4811a1e0abc4c7e0b082d693a5e7fced675cf4668512772c0cbc64a742c6c630f533c8cc72f62ae833c40bf25842e984bb78bdbf97c0107d55bdb662f5c4e0fab9845cb5148ef7392dd3aaff93ae1e6b667bb3d4247616d4f5ba10d4cfd226de88d39f16fb");
    byte[] pubExp_1024 = Hex.decode((String)"010001");
    byte[] privExp_1024 = Hex.decode((String)"53339cfdb79fc8466a655c7316aca85c55fd8f6dd898fdaf119517ef4f52e8fd8e258df93fee180fa0e4ab29693cd83b152a553d4ac4d1812b8b9fa5af0e7f55fe7304df41570926f3311f15c4d65a732c483116ee3d3d2d0af3549ad9bf7cbfb78ad884f84d5beb04724dc7369b31def37d0cf539e9cfcdd3de653729ead5d1");
    byte[] prime1_1024 = Hex.decode((String)"d32737e7267ffe1341b2d5c0d150a81b586fb3132bed2f8d5262864a9cb9f30af38be448598d413a172efb802c21acf1c11c520c2f26a471dcad212eac7ca39d");
    byte[] prime2_1024 = Hex.decode((String)"cc8853d1d54da630fac004f471f281c7b8982d8224a490edbeb33d3e3d5cc93c4765703d1dd791642f1f116a0dd852be2419b2af72bfe9a030e860b0288b5d77");
    byte[] primeExp1_1024 = Hex.decode((String)"0e12bf1718e9cef5599ba1c3882fe8046a90874eefce8f2ccc20e4f2741fb0a33a3848aec9c9305fbecbd2d76819967d4671acc6431e4037968db37878e695c1");
    byte[] primeExp2_1024 = Hex.decode((String)"95297b0f95a2fa67d00707d609dfd4fc05c89dafc2ef6d6ea55bec771ea333734d9251e79082ecda866efef13c459e1a631386b7e354c899f5f112ca85d71583");
    byte[] crtCoef_1024 = Hex.decode((String)"4f456c502493bdc0ed2ab756a3a6ed4d67352a697d4216e93212b127a63d5411ce6fa98d5dbefd73263e3728142743818166ed7dd63687dd2a8ca1d2f4fbd8e1");
    byte[] input_1024_1 = Hex.decode((String)"6628194e12073db03ba94cda9ef9532397d50dba79b987004afefe34");
    byte[] seed_1024_1 = Hex.decode((String)"18b776ea21069d69776a33e96bad48e1dda0a5ef");
    byte[] output_1024_1 = Hex.decode((String)"354fe67b4a126d5d35fe36c777791a3f7ba13def484e2d3908aff722fad468fb21696de95d0be911c2d3174f8afcc201035f7b6d8e69402de5451618c21a535fa9d7bfc5b8dd9fc243f8cf927db31322d6e881eaa91a996170e657a05a266426d98c88003f8477c1227094a0d9fa1e8c4024309ce1ecccb5210035d47ac72e8a");
    byte[] input_1024_2 = Hex.decode((String)"750c4047f547e8e41411856523298ac9bae245efaf1397fbe56f9dd5");
    byte[] seed_1024_2 = Hex.decode((String)"0cc742ce4a9b7f32f951bcb251efd925fe4fe35f");
    byte[] output_1024_2 = Hex.decode((String)"640db1acc58e0568fe5407e5f9b701dff8c3c91e716c536fc7fcec6cb5b71c1165988d4a279e1577d730fc7a29932e3f00c81515236d8d8e31017a7a09df4352d904cdeb79aa583adcc31ea698a4c05283daba9089be5491f67c1a4ee48dc74bbbe6643aef846679b4cb395a352d5ed115912df696ffe0702932946d71492b44");
    byte[] input_1024_3 = Hex.decode((String)"d94ae0832e6445ce42331cb06d531a82b1db4baad30f746dc916df24d4e3c2451fff59a6423eb0e1d02d4fe646cf699dfd818c6e97b051");
    byte[] seed_1024_3 = Hex.decode((String)"2514df4695755a67b288eaf4905c36eec66fd2fd");
    byte[] output_1024_3 = Hex.decode((String)"423736ed035f6026af276c35c0b3741b365e5f76ca091b4e8c29e2f0befee603595aa8322d602d2e625e95eb81b2f1c9724e822eca76db8618cf09c5343503a4360835b5903bc637e3879fb05e0ef32685d5aec5067cd7cc96fe4b2670b6eac3066b1fcf5686b68589aafb7d629b02d8f8625ca3833624d4800fb081b1cf94eb");
    byte[] input_1024_4 = Hex.decode((String)"52e650d98e7f2a048b4f86852153b97e01dd316f346a19f67a85");
    byte[] seed_1024_4 = Hex.decode((String)"c4435a3e1a18a68b6820436290a37cefb85db3fb");
    byte[] output_1024_4 = Hex.decode((String)"45ead4ca551e662c9800f1aca8283b0525e6abae30be4b4aba762fa40fd3d38e22abefc69794f6ebbbc05ddbb11216247d2f412fd0fba87c6e3acd888813646fd0e48e785204f9c3f73d6d8239562722dddd8771fec48b83a31ee6f592c4cfd4bc88174f3b13a112aae3b9f7b80e0fc6f7255ba880dc7d8021e22ad6a85f0755");
    byte[] input_1024_5 = Hex.decode((String)"8da89fd9e5f974a29feffb462b49180f6cf9e802");
    byte[] seed_1024_5 = Hex.decode((String)"b318c42df3be0f83fea823f5a7b47ed5e425a3b5");
    byte[] output_1024_5 = Hex.decode((String)"36f6e34d94a8d34daacba33a2139d00ad85a9345a86051e73071620056b920e219005855a213a0f23897cdcd731b45257c777fe908202befdd0b58386b1244ea0cf539a05d5d10329da44e13030fd760dcd644cfef2094d1910d3f433e1c7c6dd18bc1f2df7f643d662fb9dd37ead9059190f4fa66ca39e869c4eb449cbdc439");
    byte[] input_1024_6 = Hex.decode((String)"26521050844271");
    byte[] seed_1024_6 = Hex.decode((String)"e4ec0982c2336f3a677f6a356174eb0ce887abc2");
    byte[] output_1024_6 = Hex.decode((String)"42cee2617b1ecea4db3f4829386fbd61dafbf038e180d837c96366df24c097b4ab0fac6bdf590d821c9f10642e681ad05b8d78b378c0f46ce2fad63f74e0ad3df06b075d7eb5f5636f8d403b9059ca761b5c62bb52aa45002ea70baace08ded243b9d8cbd62a68ade265832b56564e43a6fa42ed199a099769742df1539e8255");
    byte[] modulus_1027 = Hex.decode((String)"051240b6cc0004fa48d0134671c078c7c8dec3b3e2f25bc2564467339db38853d06b85eea5b2de353bff42ac2e46bc97fae6ac9618da9537a5c8f553c1e357625991d6108dcd7885fb3a25413f53efcad948cb35cd9b9ae9c1c67626d113d57dde4c5bea76bb5bb7de96c00d07372e9685a6d75cf9d239fa148d70931b5f3fb039");
    byte[] pubExp_1027 = Hex.decode((String)"010001");
    byte[] privExp_1027 = Hex.decode((String)"0411ffca3b7ca5e9e9be7fe38a85105e353896db05c5796aecd2a725161eb3651c8629a9b862b904d7b0c7b37f8cb5a1c2b54001018a00a1eb2cafe4ee4e9492c348bc2bedab4b9ebbf064e8eff322b9009f8eec653905f40df88a3cdc49d4567f75627d41aca624129b46a0b7c698e5e65f2b7ba102c749a10135b6540d0401");
    byte[] prime1_1027 = Hex.decode((String)"027458c19ec1636919e736c9af25d609a51b8f561d19c6bf6943dd1ee1ab8a4a3f232100bd40b88decc6ba235548b6ef792a11c9de823d0a7922c7095b6eba5701");
    byte[] prime2_1027 = Hex.decode((String)"0210ee9b33ab61716e27d251bd465f4b35a1a232e2da00901c294bf22350ce490d099f642b5375612db63ba1f20386492bf04d34b3c22bceb909d13441b53b5139");
    byte[] primeExp1_1027 = Hex.decode((String)"39fa028b826e88c1121b750a8b242fa9a35c5b66bdfd1fa637d3cc48a84a4f457a194e7727e49f7bcc6e5a5a412657fc470c7322ebc37416ef458c307a8c0901");
    byte[] primeExp2_1027 = Hex.decode((String)"015d99a84195943979fa9e1be2c3c1b69f432f46fd03e47d5befbbbfd6b1d1371d83efb330a3e020942b2fed115e5d02be24fd92c9019d1cecd6dd4cf1e54cc899");
    byte[] crtCoef_1027 = Hex.decode((String)"01f0b7015170b3f5e42223ba30301c41a6d87cbb70e30cb7d3c67d25473db1f6cbf03e3f9126e3e97968279a865b2c2b426524cfc52a683d31ed30eb984be412ba");
    byte[] input_1027_1 = Hex.decode((String)"4a86609534ee434a6cbca3f7e962e76d455e3264c19f605f6e5ff6137c65c56d7fb344cd52bc93374f3d166c9f0c6f9c506bad19330972d2");
    byte[] seed_1027_1 = Hex.decode((String)"1cac19ce993def55f98203f6852896c95ccca1f3");
    byte[] output_1027_1 = Hex.decode((String)"04cce19614845e094152a3fe18e54e3330c44e5efbc64ae16886cb1869014cc5781b1f8f9e045384d0112a135ca0d12e9c88a8e4063416deaae3844f60d6e96fe155145f4525b9a34431ca3766180f70e15a5e5d8e8b1a516ff870609f13f896935ced188279a58ed13d07114277d75c6568607e0ab092fd803a223e4a8ee0b1a8");
    byte[] input_1027_2 = Hex.decode((String)"b0adc4f3fe11da59ce992773d9059943c03046497ee9d9f9a06df1166db46d98f58d27ec074c02eee6cbe2449c8b9fc5080c5c3f4433092512ec46aa793743c8");
    byte[] seed_1027_2 = Hex.decode((String)"f545d5897585e3db71aa0cb8da76c51d032ae963");
    byte[] output_1027_2 = Hex.decode((String)"0097b698c6165645b303486fbf5a2a4479c0ee85889b541a6f0b858d6b6597b13b854eb4f839af03399a80d79bda6578c841f90d645715b280d37143992dd186c80b949b775cae97370e4ec97443136c6da484e970ffdb1323a20847821d3b18381de13bb49aaea66530c4a4b8271f3eae172cd366e07e6636f1019d2a28aed15e");
    byte[] input_1027_3 = Hex.decode((String)"bf6d42e701707b1d0206b0c8b45a1c72641ff12889219a82bdea965b5e79a96b0d0163ed9d578ec9ada20f2fbcf1ea3c4089d83419ba81b0c60f3606da99");
    byte[] seed_1027_3 = Hex.decode((String)"ad997feef730d6ea7be60d0dc52e72eacbfdd275");
    byte[] output_1027_3 = Hex.decode((String)"0301f935e9c47abcb48acbbe09895d9f5971af14839da4ff95417ee453d1fd77319072bb7297e1b55d7561cd9d1bb24c1a9a37c619864308242804879d86ebd001dce5183975e1506989b70e5a83434154d5cbfd6a24787e60eb0c658d2ac193302d1192c6e622d4a12ad4b53923bca246df31c6395e37702c6a78ae081fb9d065");
    byte[] input_1027_4 = Hex.decode((String)"fb2ef112f5e766eb94019297934794f7be2f6fc1c58e");
    byte[] seed_1027_4 = Hex.decode((String)"136454df5730f73c807a7e40d8c1a312ac5b9dd3");
    byte[] output_1027_4 = Hex.decode((String)"02d110ad30afb727beb691dd0cf17d0af1a1e7fa0cc040ec1a4ba26a42c59d0a796a2e22c8f357ccc98b6519aceb682e945e62cb734614a529407cd452bee3e44fece8423cc19e55548b8b994b849c7ecde4933e76037e1d0ce44275b08710c68e430130b929730ed77e09b015642c5593f04e4ffb9410798102a8e96ffdfe11e4");
    byte[] input_1027_5 = Hex.decode((String)"28ccd447bb9e85166dabb9e5b7d1adadc4b9d39f204e96d5e440ce9ad928bc1c2284");
    byte[] seed_1027_5 = Hex.decode((String)"bca8057f824b2ea257f2861407eef63d33208681");
    byte[] output_1027_5 = Hex.decode((String)"00dbb8a7439d90efd919a377c54fae8fe11ec58c3b858362e23ad1b8a44310799066b99347aa525691d2adc58d9b06e34f288c170390c5f0e11c0aa3645959f18ee79e8f2be8d7ac5c23d061f18dd74b8c5f2a58fcb5eb0c54f99f01a83247568292536583340948d7a8c97c4acd1e98d1e29dc320e97a260532a8aa7a758a1ec2");
    byte[] input_1027_6 = Hex.decode((String)"f22242751ec6b1");
    byte[] seed_1027_6 = Hex.decode((String)"2e7e1e17f647b5ddd033e15472f90f6812f3ac4e");
    byte[] output_1027_6 = Hex.decode((String)"00a5ffa4768c8bbecaee2db77e8f2eec99595933545520835e5ba7db9493d3e17cddefe6a5f567624471908db4e2d83a0fbee60608fc84049503b2234a07dc83b27b22847ad8920ff42f674ef79b76280b00233d2b51b8cb2703a9d42bfbc8250c96ec32c051e57f1b4ba528db89c37e4c54e27e6e64ac69635ae887d9541619a9");

    private void baseOaepTest(int id, byte[] pubKeyEnc, byte[] privKeyEnc, byte[] output) throws Exception {
        ByteArrayInputStream bIn = new ByteArrayInputStream(pubKeyEnc);
        ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
        RSAPublicKey pubStruct = RSAPublicKey.getInstance((Object)SubjectPublicKeyInfo.getInstance((Object)dIn.readObject()).parsePublicKey());
        bIn = new ByteArrayInputStream(privKeyEnc);
        dIn = new ASN1InputStream((InputStream)bIn);
        RSAPrivateKey privStruct = RSAPrivateKey.getInstance((Object)PrivateKeyInfo.getInstance((Object)dIn.readObject()).parsePrivateKey());
        RSAKeyParameters pubParameters = new RSAKeyParameters(false, pubStruct.getModulus(), pubStruct.getPublicExponent());
        RSAPrivateCrtKeyParameters privParameters = new RSAPrivateCrtKeyParameters(privStruct.getModulus(), privStruct.getPublicExponent(), privStruct.getPrivateExponent(), privStruct.getPrime1(), privStruct.getPrime2(), privStruct.getExponent1(), privStruct.getExponent2(), privStruct.getCoefficient());
        byte[] input = new byte[]{84, -123, -101, 52, 44, 73, -22, 42};
        this.encDec("id(" + id + ")", pubParameters, (RSAKeyParameters)privParameters, this.seed, input, output);
    }

    private void encDec(String label, RSAKeyParameters pubParameters, RSAKeyParameters privParameters, byte[] seed, byte[] input, byte[] output) throws InvalidCipherTextException {
        OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
        cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubParameters, (SecureRandom)new VecRand(seed)));
        byte[] out = cipher.processBlock(input, 0, input.length);
        int i = 0;
        while (i != output.length) {
            if (out[i] != output[i]) {
                this.fail(label + " failed encryption");
            }
            ++i;
        }
        cipher.init(false, (CipherParameters)privParameters);
        out = cipher.processBlock(output, 0, output.length);
        int i2 = 0;
        while (i2 != input.length) {
            if (out[i2] != input[i2]) {
                this.fail(label + " failed decoding");
            }
            ++i2;
        }
    }

    private void oaepVecTest(int keySize, int no, RSAKeyParameters pubParam, RSAKeyParameters privParam, byte[] seed, byte[] input, byte[] output) throws Exception {
        this.encDec(keySize + " " + no, pubParam, privParam, seed, input, output);
    }

    public String getName() {
        return "OAEP";
    }

    public void performTest() throws Exception {
        this.baseOaepTest(1, pubKeyEnc1, privKeyEnc1, output1);
        this.baseOaepTest(2, pubKeyEnc2, privKeyEnc2, output2);
        this.baseOaepTest(3, pubKeyEnc3, privKeyEnc3, output3);
        RSAKeyParameters pubParam = new RSAKeyParameters(false, new BigInteger(1, this.modulus_1024), new BigInteger(1, this.pubExp_1024));
        RSAPrivateCrtKeyParameters privParam = new RSAPrivateCrtKeyParameters(pubParam.getModulus(), pubParam.getExponent(), new BigInteger(1, this.privExp_1024), new BigInteger(1, this.prime1_1024), new BigInteger(1, this.prime2_1024), new BigInteger(1, this.primeExp1_1024), new BigInteger(1, this.primeExp2_1024), new BigInteger(1, this.crtCoef_1024));
        this.oaepVecTest(1024, 1, pubParam, (RSAKeyParameters)privParam, this.seed_1024_1, this.input_1024_1, this.output_1024_1);
        this.oaepVecTest(1024, 2, pubParam, (RSAKeyParameters)privParam, this.seed_1024_2, this.input_1024_2, this.output_1024_2);
        this.oaepVecTest(1024, 3, pubParam, (RSAKeyParameters)privParam, this.seed_1024_3, this.input_1024_3, this.output_1024_3);
        this.oaepVecTest(1024, 4, pubParam, (RSAKeyParameters)privParam, this.seed_1024_4, this.input_1024_4, this.output_1024_4);
        this.oaepVecTest(1024, 5, pubParam, (RSAKeyParameters)privParam, this.seed_1024_5, this.input_1024_5, this.output_1024_5);
        this.oaepVecTest(1024, 6, pubParam, (RSAKeyParameters)privParam, this.seed_1024_6, this.input_1024_6, this.output_1024_6);
        pubParam = new RSAKeyParameters(false, new BigInteger(1, this.modulus_1027), new BigInteger(1, this.pubExp_1027));
        privParam = new RSAPrivateCrtKeyParameters(pubParam.getModulus(), pubParam.getExponent(), new BigInteger(1, this.privExp_1027), new BigInteger(1, this.prime1_1027), new BigInteger(1, this.prime2_1027), new BigInteger(1, this.primeExp1_1027), new BigInteger(1, this.primeExp2_1027), new BigInteger(1, this.crtCoef_1027));
        this.oaepVecTest(1027, 1, pubParam, (RSAKeyParameters)privParam, this.seed_1027_1, this.input_1027_1, this.output_1027_1);
        this.oaepVecTest(1027, 2, pubParam, (RSAKeyParameters)privParam, this.seed_1027_2, this.input_1027_2, this.output_1027_2);
        this.oaepVecTest(1027, 3, pubParam, (RSAKeyParameters)privParam, this.seed_1027_3, this.input_1027_3, this.output_1027_3);
        this.oaepVecTest(1027, 4, pubParam, (RSAKeyParameters)privParam, this.seed_1027_4, this.input_1027_4, this.output_1027_4);
        this.oaepVecTest(1027, 5, pubParam, (RSAKeyParameters)privParam, this.seed_1027_5, this.input_1027_5, this.output_1027_5);
        this.oaepVecTest(1027, 6, pubParam, (RSAKeyParameters)privParam, this.seed_1027_6, this.input_1027_6, this.output_1027_6);
        this.testForHighByteError("invalidCiphertextOaepTest 1024", 1024);
        OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance(), (Digest)new SHA1Digest(), new byte[10]);
        cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubParam, new SecureRandom()));
        byte[] input = new byte[10];
        byte[] out = cipher.processBlock(input, 0, input.length);
        cipher.init(false, (CipherParameters)privParam);
        out = cipher.processBlock(out, 0, out.length);
        int i = 0;
        while (i != input.length) {
            if (out[i] != input[i]) {
                this.fail("mixed digest failed decoding");
            }
            ++i;
        }
        cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)new SHA1Digest(), (Digest)SHA256Digest.newInstance(), new byte[10]);
        cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pubParam, new SecureRandom()));
        out = cipher.processBlock(input, 0, input.length);
        cipher.init(false, (CipherParameters)privParam);
        out = cipher.processBlock(out, 0, out.length);
        int i2 = 0;
        while (i2 != input.length) {
            if (out[i2] != input[i2]) {
                this.fail("mixed digest failed decoding");
            }
            ++i2;
        }
        byte[] encPub2048 = Base64.decode((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvF6kzNRPSUM3klXHq6R7O6TfI9XOe6oK5Mm/wYLMY5tqnVXItOG2fQagKhULQSi7ihUTYBbiffG72LCQVUd4/m+FSJmFdbfQgIjtEanBCC4oE4G5/uKuGh1SGQSsppMQiaJ4g1q12RAruOYp6L94JMnSy5pq3czVtbMfiEskO/FfD+nVAnpQNlrRShn268FB4+6FUiR68nwEdQXTEs20/i9V2BwoHuMmIQyjPoHo3ArEyBEDxACH02nsezb8Kes/rLwW0unjHEyWpw9EnxqaXxDg9z8CNO2IDUYtesNXBdFB/ggz+IdbsEJf0MbsjGz9R2xl2+lSOALsf6FZQOphgQIDAQAB");
        byte[] encPri2048 = Base64.decode((String)"MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC8XqTM1E9JQzeSVcerpHs7pN8j1c57qgrkyb/Bgsxjm2qdVci04bZ9BqAqFQtBKLuKFRNgFuJ98bvYsJBVR3j+b4VImYV1t9CAiO0RqcEILigTgbn+4q4aHVIZBKymkxCJoniDWrXZECu45inov3gkydLLmmrdzNW1sx+ISyQ78V8P6dUCelA2WtFKGfbrwUHj7oVSJHryfAR1BdMSzbT+L1XYHCge4yYhDKM+gejcCsTIEQPEAIfTaex7Nvwp6z+svBbS6eMcTJanD0SfGppfEOD3PwI07YgNRi16w1cF0UH+CDP4h1uwQl/QxuyMbP1HbGXb6VI4Aux/oVlA6mGBAgMBAAECggEAAdjBr9pi/ppgmJgrsXSW2rJWl7DYaeD0Y2LQ9PI108IpzOoS4icWVWpztoXnSte94vAq9PW0ebyddVXhzFw7hO8N9PTAWLOZITF2dYZfBJgDP5G1g5iwUUQ5UlJ36NgnQNotaUhB4SNl8lWbUpNR97Zc0S8t3gfMjo/3fqwR6l6CkLEkzqdmrMb3+LOcdIs+kJCfC1Yb+czXkeUpbQaPogiiJDHxPlpEUMLTPqIwqWnAwJOxPLj34oevI7o7SWTQZQkwBUxj4cZYjEK/jXfQ2GM6XZJIW/7iCc1fZMzcX3PdECiri27iGFNyTdQHTqSfIhb5bctvFj5EE+DHT6ykCwKBgQD93ZbqHnslXuxXaekhSRN2sI+sXWhinVGEVptzu5secFwuUHT8xCPsAwUMMOKsyHGhh20ZYpUS/PadJPneA7oeWRZqeOPeWEli5J71dDBCDrn1UBBOFseEb/gicSbUR/ZaUa9FyJnnPVrFhUpLsXKftMxBJlGkxCNtYC6cBnyFLwKBgQC99BVbuxLCYNZe6bhxKnf16PyWbsvojjdNbAUKMr7G7VhdMFxJUcchARYhh19dtDR2/lJPBX8i9U1j5FXQzRmBz1TEQ4wF5TEYBnReOOnSWxF9kDaANY9jkMoUiAQJfWmKoLMYx5BoNoYhp/4Ri+pRVgTxM/Qp5UnzzzgXsZU4TwKBgQCgfuw/PWALg1SV+x5pbcLBYeSjSzaISf9UVFDZPT1XZB/TJAiiGPrA5jPVvj5AkETOo0jFKL8ojwb22H6j7uVG9HmofJ9LXbOfsvwQIBG2YYsNXT3BsMMYppVQaQrsYEaOWWAfFTC/sdlmUNtkuV3HPE15ztkE+v+O0aUF/U/R/wKBgHCkIFJAMhSgNh8ce6pn47EokzhlxXdHdlXr+2UbyHPQZTkFp4Q3AV159nS1gQDhDseNcqO3f7fsPRNCYP0r0rdeikbEQ3FvgthbY4BIQafjJxENhrQqjrgdMShRrAswmniBaRMFrIWP56RnqUsgbDgFSXL7OwvpExyIQhwSy4kTAoGBAN3x9T7UkwdHSAtpETC+9bGmdcbytHr6JElQKH8jM5sS3FKHR7NSGCGIBmYtbwU3GqU/4JUkDH+ASvsgT2KBLW9kj/zQRV6kW9g0O/2LY3RZ6bOvCs8p4LfPRBm6Zy1bm6h51Em62oXHoViYrI3TSmOfCK9nSeErsxt20sUfsLVW");
        AsymmetricKeyParameter pub2048 = PublicKeyFactory.createKey((byte[])encPub2048);
        AsymmetricKeyParameter pri2048 = PrivateKeyFactory.createKey((byte[])encPri2048);
        input = Strings.toByteArray((String)"OAEP SHA-256 Test");
        cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine(), (Digest)SHA256Digest.newInstance());
        cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)pub2048, (SecureRandom)new FixedSecureRandom(encPub2048)));
        out = cipher.processBlock(input, 0, input.length);
        this.isTrue(Arrays.areEqual((byte[])Hex.decode((String)"8314e8dc39bfe75dcf1ecf770233593fd2f564c8bd2d4a4a66da238f8b3b476cbe4ccf40b2f3efdc74fd1fd015da1b7dd41802d9e61199b59d95714ac54b5479dd639d284038865d5a68790901093a6dac7afc086d26d4855b967eb262394eab9f15c3658ba62f90921d6354ce8d59095df761877b3e5e3278be84bae813f632a95042530eac0e28fa84f2a0202dd76529783ee3826c394476f381978dbabe7c08e76de5944b59aec0145ac6b2b75e1d153411ff8dceb18c14263eec5d9c6fc6cdbbd47006bcc0c905aaaf62d3f6b760dce5eb178635bb3fe02eb5772baa30eaa2cc00282830a9adc813611914e96ac1e3fc5c6319233ac65ff2a3c4468bac99"), (byte[])out));
        cipher.init(false, (CipherParameters)pri2048);
        out = cipher.processBlock(out, 0, out.length);
        this.isTrue(Arrays.areEqual((byte[])input, (byte[])out));
    }

    private void testForHighByteError(String label, int keySizeBits) throws Exception {
        BigInteger e = BigIntegers.ONE.shiftLeft(16).add(BigIntegers.ONE);
        RSAKeyPairGenerator kpGen = new RSAKeyPairGenerator();
        kpGen.init((KeyGenerationParameters)new RSAKeyGenerationParameters(e, new SecureRandom(), keySizeBits, 100));
        AsymmetricCipherKeyPair kp = kpGen.generateKeyPair();
        OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
        cipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)kp.getPublic(), (SecureRandom)new VecRand(this.seed)));
        byte[] m = new byte[]{42};
        byte[] c = cipher.processBlock(m, 0, m.length);
        int keySizeBytes = keySizeBits + 7 >>> 3;
        if (c.length != keySizeBytes) {
            this.fail(label + " failed ciphertext size");
        }
        BigInteger n = ((RSAPrivateCrtKeyParameters)kp.getPrivate()).getModulus();
        cipher.init(false, (CipherParameters)kp.getPrivate());
        byte[] r = cipher.processBlock(c, 0, keySizeBytes);
        if (r.length != 1 || r[0] != 42) {
            this.fail(label + " failed first decryption of test message");
        }
        if ((r = cipher.processBlock(c, 0, keySizeBytes)).length != 1 || r[0] != 42) {
            this.fail(label + " failed second decryption of test message");
        }
        int i = keySizeBytes * 8;
        while (--i >= 0) {
            int n2 = i >>> 3;
            c[n2] = (byte)(c[n2] ^ 1 << (i & 7));
            boolean ko = true;
            try {
                BigInteger cV = new BigInteger(1, c);
                if (cV.compareTo(n) < 0) {
                    r = cipher.processBlock(c, 0, keySizeBytes);
                } else {
                    ko = false;
                }
            }
            catch (InvalidCipherTextException exception) {
                ko = false;
            }
            if (ko) {
                this.fail(label + " invalid ciphertext caused no exception");
            }
            int n3 = i >>> 3;
            c[n3] = (byte)(c[n3] ^ 1 << (i & 7));
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new OAEPTest());
    }

    private static class VecRand
    extends SecureRandom {
        byte[] seed;

        VecRand(byte[] seed) {
            this.seed = seed;
        }

        public void nextBytes(byte[] bytes) {
            System.arraycopy(this.seed, 0, bytes, 0, bytes.length);
        }
    }
}

