/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.engines.NullEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.BlockCipherVectorTest;
import org.bouncycastle.crypto.test.CipherTest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NullTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, (BlockCipher)new NullEngine(), (CipherParameters)new KeyParameter(Hex.decode((String)"00")), "00", "00")};

    NullTest() {
        super(tests, (BlockCipher)new NullEngine(), new KeyParameter(new byte[2]));
    }

    public String getName() {
        return "Null";
    }

    public void performTest() throws Exception {
        super.performTest();
        NullEngine engine = new NullEngine();
        engine.init(true, null);
        byte[] buf = new byte[1];
        engine.processBlock(buf, 0, buf, 0);
        if (buf[0] != 0) {
            this.fail("NullCipher changed data!");
        }
        byte[] shortBuf = new byte[]{};
        try {
            engine.processBlock(shortBuf, 0, buf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        try {
            engine.processBlock(buf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new NullTest());
    }
}

