/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.NaccacheSternEngine;
import org.bouncycastle.crypto.generators.NaccacheSternKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NaccacheSternTest
extends SimpleTest {
    static final boolean debug = false;
    static final NaccacheSternEngine cryptEng = new NaccacheSternEngine();
    static final NaccacheSternEngine decryptEng = new NaccacheSternEngine();
    static final BigInteger a = BigInteger.valueOf(101L);
    static final BigInteger u1 = BigInteger.valueOf(3L);
    static final BigInteger u2 = BigInteger.valueOf(5L);
    static final BigInteger u3 = BigInteger.valueOf(7L);
    static final BigInteger b = BigInteger.valueOf(191L);
    static final BigInteger v1 = BigInteger.valueOf(11L);
    static final BigInteger v2 = BigInteger.valueOf(13L);
    static final BigInteger v3 = BigInteger.valueOf(17L);
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger TWO = BigInteger.valueOf(2L);
    static final BigInteger sigma = u1.multiply(u2).multiply(u3).multiply(v1).multiply(v2).multiply(v3);
    static final BigInteger p = TWO.multiply(a).multiply(u1).multiply(u2).multiply(u3).add(ONE);
    static final BigInteger q = TWO.multiply(b).multiply(v1).multiply(v2).multiply(v3).add(ONE);
    static final BigInteger n = p.multiply(q);
    static final BigInteger phi_n = p.subtract(ONE).multiply(q.subtract(ONE));
    static final BigInteger g = BigInteger.valueOf(131L);
    static final Vector smallPrimes = new Vector();
    static final String input = "4e6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";
    static final BigInteger paperTest = BigInteger.valueOf(202L);
    static final String edgeInput = "ff6f77206973207468652074696d6520666f7220616c6c20676f6f64206d656e";

    public String getName() {
        return "NaccacheStern";
    }

    public void performTest() {
        NaccacheSternKeyParameters pubParameters = new NaccacheSternKeyParameters(false, g, n, sigma.bitLength());
        NaccacheSternPrivateKeyParameters privParameters = new NaccacheSternPrivateKeyParameters(g, n, sigma.bitLength(), smallPrimes, phi_n);
        AsymmetricCipherKeyPair pair = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)pubParameters, (AsymmetricKeyParameter)privParameters);
        cryptEng.init(true, (CipherParameters)pair.getPublic());
        decryptEng.init(false, (CipherParameters)pair.getPrivate());
        byte[] data = paperTest.toByteArray();
        if (!new BigInteger(data).equals(new BigInteger(this.enDeCrypt(data)))) {
            this.fail("failed NaccacheStern paper test");
        }
        NaccacheSternKeyGenerationParameters genParam = new NaccacheSternKeyGenerationParameters(new SecureRandom(), 768, 8, 30, false);
        NaccacheSternKeyPairGenerator pGen = new NaccacheSternKeyPairGenerator();
        pGen.init((KeyGenerationParameters)genParam);
        pair = pGen.generateKeyPair();
        if (((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() < 768) {
            System.out.println("FAILED: key size is <786 bit, exactly " + ((NaccacheSternKeyParameters)pair.getPublic()).getModulus().bitLength() + " bit");
            this.fail("failed key generation (768) length test");
        }
        cryptEng.init(true, (CipherParameters)pair.getPublic());
        decryptEng.init(false, (CipherParameters)pair.getPrivate());
        data = Hex.decode((String)input);
        if (!new BigInteger(1, data).equals(new BigInteger(1, this.enDeCrypt(data)))) {
            this.fail("failed encryption decryption (" + genParam.getStrength() + ") basic test");
        }
        if (!new BigInteger(1, data = Hex.decode((String)edgeInput)).equals(new BigInteger(1, this.enDeCrypt(data)))) {
            this.fail("failed encryption decryption (" + genParam.getStrength() + ") edgeInput test");
        }
        try {
            new NaccacheSternEngine().processBlock(new byte[]{1}, 0, 1);
            this.fail("failed initialisation check");
        }
        catch (IllegalStateException e) {
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed initialisation check");
        }
    }

    private byte[] enDeCrypt(byte[] input) {
        byte[] data = new byte[input.length];
        System.arraycopy(input, 0, data, 0, data.length);
        try {
            data = cryptEng.processData(data);
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed - exception " + e.toString() + "\n" + e.getMessage());
        }
        try {
            data = decryptEng.processData(data);
        }
        catch (InvalidCipherTextException e) {
            this.fail("failed - exception " + e.toString() + "\n" + e.getMessage());
        }
        return data;
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new NaccacheSternTest());
    }

    static {
        cryptEng.setDebug(false);
        decryptEng.setDebug(false);
        smallPrimes.addElement(u1);
        smallPrimes.addElement(u2);
        smallPrimes.addElement(u3);
        smallPrimes.addElement(v1);
        smallPrimes.addElement(v2);
        smallPrimes.addElement(v3);
    }
}

