/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NISTCTSTest
extends SimpleTest {
    private static KeyParameter key = new KeyParameter(Hex.decode((String)"000102030405060708090a0b0c0d0e0f"));
    private static byte[] iv = Hex.decode((String)"101112131415161718191a1b1c1d1e1f");
    private static byte[] singleBlock = Hex.decode((String)"4920616d206f6e6520626c6f636b2e2e");
    private static byte[] singleOut = Hex.decode((String)"8aad2098847a2d74ac87de22745d2537");
    private static byte[] twoBlock = Hex.decode((String)"4920616d206174206c656173742074776f20626c6f636b73206c6f6e672e2e2e");
    private static byte[] cs1TwoBlockOut = Hex.decode((String)"3f07fd5816c3b96349eb9f6a074909d67237eb8aa9a7467b8a388c61d0e8f35a");
    private static byte[] cs2TwoBlockOut = Hex.decode((String)"3f07fd5816c3b96349eb9f6a074909d67237eb8aa9a7467b8a388c61d0e8f35a");
    private static byte[] cs3TwoBlockOut = Hex.decode((String)"7237eb8aa9a7467b8a388c61d0e8f35a3f07fd5816c3b96349eb9f6a074909d6");
    private static byte[] notQuiteTwo = Hex.decode((String)"4920616d206e6f742071756974652074776f2e2e2e");
    private static byte[] cs1NotQuiteTwoBlockOut = Hex.decode((String)"22ecf2ac77f098097ca69b72e3a46e9ca21bb5ebbc");
    private static byte[] cs2NotQuiteTwoBlockOut = Hex.decode((String)"f098097ca69b72e3a46e9ca21bb5ebbc22ecf2ac77");
    private static byte[] cs3NotQuiteTwoBlockOut = Hex.decode((String)"f098097ca69b72e3a46e9ca21bb5ebbc22ecf2ac77");
    static byte[] in1 = Hex.decode((String)"4e6f7720697320746865207420");
    static byte[] in2 = Hex.decode((String)"000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f0aaa");
    static byte[] out1 = Hex.decode((String)"9952f131588465033fa40e8a98");
    static byte[] out2 = Hex.decode((String)"358f84d01eb42988dc34efb994");
    static byte[] out3 = Hex.decode((String)"170171cfad3f04530c509b0c1f0be0aefbd45a8e3755a873bff5ea198504b71683c6");

    private void testCTS(int id, int type, BlockCipher cipher, CipherParameters params, byte[] input, byte[] output) throws Exception {
        byte[] out = new byte[input.length];
        NISTCTSBlockCipher engine = new NISTCTSBlockCipher(type, cipher);
        engine.init(true, params);
        int len = engine.processBytes(input, 0, input.length, out, 0);
        engine.doFinal(out, len);
        if (!this.areEqual(output, out)) {
            this.fail(id + " failed encryption expected " + new String(Hex.encode((byte[])output)) + " got " + new String(Hex.encode((byte[])out)));
        }
        engine.init(false, params);
        len = engine.processBytes(output, 0, output.length, out, 0);
        engine.doFinal(out, len);
        if (!this.areEqual(input, out)) {
            this.fail(id + " failed decryption expected " + new String(Hex.encode((byte[])input)) + " got " + new String(Hex.encode((byte[])out)));
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        NISTCTSBlockCipher engine = new NISTCTSBlockCipher(1, (BlockCipher)AESEngine.newInstance());
        KeyParameter params = new KeyParameter(new byte[engine.getBlockSize()]);
        engine.init(true, (CipherParameters)params);
        byte[] out = new byte[engine.getOutputSize(engine.getBlockSize())];
        engine.processBytes(new byte[engine.getBlockSize() - 1], 0, engine.getBlockSize() - 1, out, 0);
        try {
            engine.doFinal(out, 0);
            this.fail("Expected CTS encrypt error on < 1 block input");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        engine.init(true, (CipherParameters)params);
        engine.processBytes(new byte[engine.getBlockSize()], 0, engine.getBlockSize(), out, 0);
        try {
            engine.doFinal(out, 0);
        }
        catch (DataLengthException e) {
            this.fail("Unexpected CTS encrypt error on == 1 block input");
        }
        engine.init(false, (CipherParameters)params);
        engine.processBytes(new byte[engine.getBlockSize() - 1], 0, engine.getBlockSize() - 1, out, 0);
        try {
            engine.doFinal(out, 0);
            this.fail("Expected CTS decrypt error on < 1 block input");
        }
        catch (DataLengthException e) {
            // empty catch block
        }
        engine.init(false, (CipherParameters)params);
        engine.processBytes(new byte[engine.getBlockSize()], 0, engine.getBlockSize(), out, 0);
        try {
            engine.doFinal(out, 0);
        }
        catch (DataLengthException e) {
            this.fail("Unexpected CTS decrypt error on == 1 block input");
        }
    }

    public String getName() {
        return "NISTCTS";
    }

    public void performTest() throws Exception {
        this.testCTS(1, 1, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), singleBlock, singleOut);
        this.testCTS(2, 2, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), singleBlock, singleOut);
        this.testCTS(3, 3, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), singleBlock, singleOut);
        this.testCTS(4, 1, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), twoBlock, cs1TwoBlockOut);
        this.testCTS(5, 2, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), twoBlock, cs2TwoBlockOut);
        this.testCTS(6, 3, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), twoBlock, cs3TwoBlockOut);
        this.testCTS(7, 1, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), notQuiteTwo, cs1NotQuiteTwoBlockOut);
        this.testCTS(8, 2, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), notQuiteTwo, cs2NotQuiteTwoBlockOut);
        this.testCTS(9, 3, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)key, iv), notQuiteTwo, cs3NotQuiteTwoBlockOut);
        byte[] aes128b = Hex.decode((String)"aafd12f659cae63489b479e5076ddec2f06cb58faafd12f6");
        byte[] aesIn1b = Hex.decode((String)"000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        byte[] aesOut1b = Hex.decode((String)"6db2f802d99e1ef0a5940f306079e083cf87f4d8bb9d1abb36cdd9f44ead7d04");
        this.testCTS(10, 3, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(aes128b), Hex.decode((String)"aafd12f659cae63489b479e5076ddec2")), aesIn1b, aesOut1b);
        byte[] aes128c = Hex.decode((String)"aafd12f659cae63489b479e5076ddec2");
        byte[] aesOut1c = Hex.decode((String)"0af33c005a337af55a5149effc5108eaa1ea87de8a8556e8786b8f230da64e56");
        this.testCTS(11, 3, (BlockCipher)AESEngine.newInstance(), (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(aes128c), Hex.decode((String)"aafd12f659cae63489b479e5076ddec2")), aesIn1b, aesOut1c);
        this.testExceptions();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new NISTCTSTest());
    }
}

