/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import org.bouncycastle.crypto.macs.CFBBlockCipherMac;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode((String)"0123456789abcdef");
    static byte[] ivBytes = Hex.decode((String)"1234567890abcdef");
    static byte[] input1 = Hex.decode((String)"37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode((String)"f1d30f68");
    static byte[] output2 = Hex.decode((String)"58d2e77e");
    static byte[] output3 = Hex.decode((String)"cd647403");
    static byte[] input2 = Hex.decode((String)"3736353433323120");
    static byte[] output4 = Hex.decode((String)"3af549c9");
    static byte[] output5 = Hex.decode((String)"188fbdd5");
    static byte[] output6 = Hex.decode((String)"7045eecd");

    public void performTest() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        CBCBlockCipherMac mac = new CBCBlockCipherMac((BlockCipher)cipher);
        mac.init((CipherParameters)key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])out)));
        }
        ParametersWithIV param = new ParametersWithIV((CipherParameters)key, ivBytes);
        mac.init((CipherParameters)param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output2)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output2)) + " got " + new String(Hex.encode((byte[])out)));
        }
        param = new ParametersWithIV((CipherParameters)key, ivBytes);
        mac = new CFBBlockCipherMac((BlockCipher)cipher);
        mac.init((CipherParameters)param);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output3)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output3)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac.init((CipherParameters)key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output4)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output4)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac = new CBCBlockCipherMac((BlockCipher)cipher, (BlockCipherPadding)new PKCS7Padding());
        mac.init((CipherParameters)key);
        mac.update(input2, 0, input2.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output5)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output5)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac.reset();
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output6)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac.init((CipherParameters)key);
        mac.update(input1, 0, input1.length);
        out = new byte[4];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output6)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output6)) + " got " + new String(Hex.encode((byte[])out)));
        }
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new MacTest());
    }
}

