/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.macs.ISO9797Alg3Mac;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ISO9797Alg3MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode((String)"7CA110454A1A6E570131D9619DC1376E");
    static byte[] input1 = "Hello World !!!!".getBytes();
    static byte[] output1 = Hex.decode((String)"F09B856213BAB83B");

    public void performTest() {
        KeyParameter key = new KeyParameter(keyBytes);
        DESEngine cipher = new DESEngine();
        ISO9797Alg3Mac mac = new ISO9797Alg3Mac((BlockCipher)cipher);
        mac.init((CipherParameters)key);
        mac.update(input1, 0, input1.length);
        byte[] out = new byte[8];
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])out)));
        }
        mac.reset();
        mac.init((CipherParameters)key);
        int i = 0;
        while (i != input1.length / 2) {
            mac.update(input1[i]);
            ++i;
        }
        mac.update(input1, input1.length / 2, input1.length - input1.length / 2);
        mac.doFinal(out, 0);
        if (!this.areEqual(out, output1)) {
            this.fail("Reset failed - expected " + new String(Hex.encode((byte[])output1)) + " got " + new String(Hex.encode((byte[])out)));
        }
        this.testMacWithIv();
    }

    private void testMacWithIv() {
        byte[] inputData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        byte[] key = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
        byte[] zeroIv = new byte[8];
        byte[] nonZeroIv = new byte[]{5, 6, 7, 8, 1, 2, 3, 4};
        KeyParameter simpleParameter = new KeyParameter(key);
        ParametersWithIV zeroIvParameter = new ParametersWithIV((CipherParameters)new KeyParameter(key), zeroIv);
        ISO9797Alg3Mac mac1 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), (BlockCipherPadding)new ISO7816d4Padding());
        mac1.init((CipherParameters)simpleParameter);
        mac1.update(inputData, 0, inputData.length);
        byte[] output1 = new byte[mac1.getMacSize()];
        mac1.doFinal(output1, 0);
        ISO9797Alg3Mac mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), (BlockCipherPadding)new ISO7816d4Padding());
        mac2.init((CipherParameters)zeroIvParameter);
        mac2.update(inputData, 0, inputData.length);
        byte[] output2 = new byte[mac2.getMacSize()];
        mac2.doFinal(output2, 0);
        if (!Arrays.areEqual((byte[])output1, (byte[])output2)) {
            this.fail("zero IV test failed");
        }
        ParametersWithIV nonZeroIvParameter = new ParametersWithIV((CipherParameters)new KeyParameter(key), nonZeroIv);
        mac2 = new ISO9797Alg3Mac((BlockCipher)new DESEngine(), (BlockCipherPadding)new ISO7816d4Padding());
        mac2.init((CipherParameters)nonZeroIvParameter);
        mac2.update(inputData, 0, inputData.length);
        output2 = new byte[mac2.getMacSize()];
        mac2.doFinal(output2, 0);
        if (Arrays.areEqual((byte[])output1, (byte[])output2)) {
            this.fail("non-zero IV test failed");
        }
    }

    public String getName() {
        return "ISO9797Alg3Mac";
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new ISO9797Alg3MacTest());
    }
}

