/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Commitment;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.commitments.GeneralHashCommitter;
import org.bouncycastle.crypto.commitments.HashCommitter;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HashCommitmentTest
extends SimpleTest {
    public String getName() {
        return "HashCommitmentTest";
    }

    public void performBasicTest() throws Exception {
        block7: {
            Commitment c;
            HashCommitter committer;
            block6: {
                byte[] data = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
                committer = new HashCommitter((ExtendedDigest)SHA256Digest.newInstance(), new SecureRandom());
                c = committer.commit(data);
                committer = new HashCommitter((ExtendedDigest)SHA256Digest.newInstance(), new SecureRandom());
                if (!committer.isRevealed(c, data)) {
                    this.fail("commitment failed to validate");
                }
                if ((committer = new HashCommitter((ExtendedDigest)new SHA1Digest(), new SecureRandom())).isRevealed(c, data)) {
                    this.fail("commitment validated!!");
                }
                try {
                    committer.isRevealed(c, new byte[data.length + 1]);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("Message and witness secret lengths do not match.")) break block6;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                c = committer.commit(new byte[33]);
            }
            catch (DataLengthException e) {
                if (e.getMessage().equals("Message to be committed to too large for digest.")) break block7;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performGeneralTest() throws Exception {
        block8: {
            Commitment c;
            GeneralHashCommitter committer;
            block7: {
                byte[] data = Hex.decode((String)"4e6f77206973207468652074696d6520666f7220616c6c20");
                committer = new GeneralHashCommitter((ExtendedDigest)SHA256Digest.newInstance(), new SecureRandom());
                c = committer.commit(data);
                committer = new GeneralHashCommitter((ExtendedDigest)SHA256Digest.newInstance(), new SecureRandom());
                if (!committer.isRevealed(c, data)) {
                    this.fail("general commitment failed to validate");
                }
                if ((committer = new GeneralHashCommitter((ExtendedDigest)new SHA1Digest(), new SecureRandom())).isRevealed(c, data)) {
                    this.fail("general commitment validated!!");
                }
                c = committer.commit(data);
                byte[] s = c.getSecret();
                byte[] newS = Arrays.copyOfRange((byte[])s, (int)0, (int)(s.length - 1));
                byte[] newData = new byte[data.length + 1];
                newData[0] = s[s.length - 1];
                System.arraycopy(data, 0, newData, 1, data.length);
                c = new Commitment(newS, c.getCommitment());
                if (committer.isRevealed(c, newData)) {
                    this.fail("general commitment validated!!");
                }
                try {
                    committer.isRevealed(c, new byte[data.length + 1]);
                }
                catch (Exception e) {
                    if (e.getMessage().equals("Message and witness secret lengths do not match.")) break block7;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                c = committer.commit(new byte[33]);
            }
            catch (DataLengthException e) {
                if (e.getMessage().equals("Message to be committed to too large for digest.")) break block8;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performTest() throws Exception {
        this.performBasicTest();
        this.performGeneralTest();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new HashCommitmentTest());
    }
}

