/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.Haraka512Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Haraka512DigestTest
extends SimpleTest {
    public String getName() {
        return "Haraka 512";
    }

    public void testKnownVector() {
        byte[] in = new byte[64];
        int t = 0;
        while (t < in.length) {
            in[t] = (byte)t;
            ++t;
        }
        byte[] expected512 = Hex.decode((String)"be7f723b4e80a99813b292287f306f625a6d57331cae5f34dd9277b0945be2aa");
        Haraka512Digest haraka = new Haraka512Digest();
        haraka.update(in, 0, in.length);
        byte[] out = new byte[haraka.getDigestSize()];
        haraka.doFinal(out, 0);
        this.isTrue("Did not match vector", this.areEqual(expected512, out));
    }

    public void testInputTooShort() {
        try {
            Haraka512Digest haraka = new Haraka512Digest();
            byte[] in = new byte[63];
            haraka.update(in, 0, in.length);
            haraka.doFinal(null, 0);
            this.fail("fail on input not 64 bytes.");
        }
        catch (IllegalStateException ilarex) {
            this.isTrue("message", this.contains(ilarex.getMessage(), "input must be exactly 64 bytes"));
        }
    }

    public void testInputTooLong() {
        try {
            Haraka512Digest haraka = new Haraka512Digest();
            byte[] in = new byte[65];
            haraka.update(in, 0, in.length);
            haraka.doFinal(null, 0);
            this.fail("fail on input not 64 bytes.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("message", this.contains(ilarex.getMessage(), "total input cannot be more than 64 bytes"));
        }
    }

    public void testOutput() {
        byte[] out;
        byte[] in;
        Haraka512Digest haraka;
        try {
            haraka = new Haraka512Digest();
            in = new byte[64];
            haraka.update(in, 0, in.length);
            out = new byte[31];
            haraka.doFinal(out, 0);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("message", this.contains(ilarex.getMessage(), "output too short to receive digest"));
        }
        try {
            haraka = new Haraka512Digest();
            in = new byte[64];
            haraka.update(in, 0, in.length);
            out = new byte[48];
            haraka.doFinal(out, 17);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("message", this.contains(ilarex.getMessage(), "output too short to receive digest"));
        }
        byte[] in2 = new byte[64];
        int t = 0;
        while (t < in2.length) {
            in2[t] = (byte)t;
            ++t;
        }
        byte[] expected512 = Hex.decode((String)"00000000be7f723b4e80a99813b292287f306f625a6d57331cae5f34dd9277b0945be2aa");
        Haraka512Digest haraka2 = new Haraka512Digest();
        haraka2.update(in2, 0, in2.length);
        byte[] out2 = new byte[haraka2.getDigestSize() + 4];
        haraka2.doFinal(out2, 4);
        this.isTrue(this.areEqual(expected512, out2));
    }

    void testMonty() {
        int c = 0;
        String[][] vectors = new String[][]{{"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F", "ABE210FE673F3B28E70E5100C476D82F61A7E2BDB3D8423FB0A15E5DE3D3A4DE"}, {"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "5F5ECB52C61F5036C96BE555D2E18C520AB3ED093954700C283A322D14DBFE02"}};
        int i = 0;
        while (i != vectors.length) {
            String[] vector = vectors[i];
            byte[] expected = Hex.decode((String)vector[1]);
            byte[] in = Hex.decode((String)vector[0]);
            Haraka512Digest haraka = new Haraka512Digest();
            byte[] result = new byte[haraka.getDigestSize()];
            int t = 0;
            while (t < 1000) {
                haraka.update(in, 0, in.length);
                haraka.doFinal(result, 0);
                if ((t & 1) == 1) {
                    System.arraycopy(result, 0, in, 0, result.length);
                } else {
                    System.arraycopy(result, 0, in, result.length, result.length);
                }
                ++t;
            }
            this.isTrue("Monte Carlo test: " + c, this.areEqual(expected, result));
            result[0] = (byte)(result[0] ^ 1);
            this.isTrue("Monte Carlo test: " + c, !this.areEqual(expected, result));
            ++c;
            ++i;
        }
    }

    private boolean contains(String message, String sub) {
        return message.indexOf(sub) >= 0;
    }

    public void performTest() throws Exception {
        this.testKnownVector();
        this.testInputTooLong();
        this.testInputTooShort();
        this.testOutput();
        this.testMonty();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new Haraka512DigestTest());
    }
}

