/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.Haraka256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Haraka256DigestTest
extends SimpleTest {
    public String getName() {
        return "Haraka 256";
    }

    public void testKnownVector() {
        byte[] in = new byte[32];
        int t = 0;
        while (t < in.length) {
            in[t] = (byte)t;
            ++t;
        }
        byte[] expected256 = Hex.decode((String)"8027ccb87949774b78d0545fb72bf70c695c2a0923cbd47bba1159efbf2b2c1c");
        Haraka256Digest haraka = new Haraka256Digest();
        haraka.update(in, 0, in.length);
        byte[] out = new byte[haraka.getDigestSize()];
        haraka.doFinal(out, 0);
        this.isTrue("Did not match vector", this.areEqual(expected256, out));
    }

    public void testInputTooShort() {
        try {
            Haraka256Digest haraka = new Haraka256Digest();
            byte[] in = new byte[31];
            haraka.update(in, 0, in.length);
            haraka.doFinal(null, 0);
            this.fail("fail on input not 32 bytes.");
        }
        catch (IllegalStateException ilarex) {
            this.isTrue("message", this.contains(ilarex.getMessage(), "input must be exactly 32 bytes"));
        }
    }

    public void testInputTooLong() {
        try {
            Haraka256Digest haraka = new Haraka256Digest();
            byte[] in = new byte[33];
            haraka.update(in, 0, in.length);
            haraka.doFinal(null, 0);
            this.fail("fail on input not 32 bytes.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("long message", this.contains(ilarex.getMessage(), "total input cannot be more than 32 bytes"));
        }
    }

    public void testOutput() {
        byte[] out;
        byte[] in;
        Haraka256Digest haraka;
        try {
            haraka = new Haraka256Digest();
            in = new byte[32];
            haraka.update(in, 0, in.length);
            out = new byte[31];
            haraka.doFinal(out, 0);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("message 1", this.contains(ilarex.getMessage(), "output too short to receive digest"));
        }
        try {
            haraka = new Haraka256Digest();
            in = new byte[32];
            haraka.update(in, 0, in.length);
            out = new byte[48];
            haraka.doFinal(out, 17);
            this.fail("Output too short for digest result.");
        }
        catch (IllegalArgumentException ilarex) {
            this.isTrue("message 2", this.contains(ilarex.getMessage(), "output too short to receive digest"));
        }
        byte[] in2 = new byte[32];
        int t = 0;
        while (t < in2.length) {
            in2[t] = (byte)t;
            ++t;
        }
        byte[] expected256 = Hex.decode((String)"000000008027ccb87949774b78d0545fb72bf70c695c2a0923cbd47bba1159efbf2b2c1c");
        Haraka256Digest haraka2 = new Haraka256Digest();
        haraka2.update(in2, 0, in2.length);
        byte[] out2 = new byte[haraka2.getDigestSize() + 4];
        haraka2.doFinal(out2, 4);
        this.isTrue(this.areEqual(expected256, out2));
    }

    void testMonty() {
        int c = 0;
        String[][] vectors = new String[][]{{"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "e78599d7163ab58f1c90f0171c6fc4e852eb4b8cc29a4af63194fd9977c1de84"}, {"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "c4cebda63c00c4cd312f36ea92afd4b0f6048507c5b367326ef9d8fdd2d5c09a"}};
        int i = 0;
        while (i != vectors.length) {
            String[] vector = vectors[i];
            byte[] expected = Hex.decode((String)vector[1]);
            Haraka256Digest haraka = new Haraka256Digest();
            byte[] result = Hex.decode((String)vector[0]);
            int t = 0;
            while (t < 1000) {
                haraka.update(result, 0, result.length);
                haraka.doFinal(result, 0);
                ++t;
            }
            this.isTrue("Monte Carlo test: " + c, this.areEqual(expected, result));
            result[0] = (byte)(result[0] ^ 1);
            this.isTrue("Monte Carlo test: " + c, !this.areEqual(expected, result));
            ++c;
            ++i;
        }
    }

    private boolean contains(String message, String sub) {
        return message.indexOf(sub) >= 0;
    }

    public void performTest() throws Exception {
        this.testKnownVector();
        this.testInputTooLong();
        this.testInputTooShort();
        this.testOutput();
        this.testMonty();
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new Haraka256DigestTest());
    }
}

