/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.Grain128AEADEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.test.TestResourceFinder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Grain128AEADTest
extends SimpleTest {
    public String getName() {
        return "Grain-128AEAD";
    }

    public void performTest() throws Exception {
        this.testVectors();
        this.testSplitUpdate();
        this.testExceptions();
        this.testLongAEAD();
    }

    /*
     * WARNING - void declaration
     */
    private void testVectors() throws Exception {
        String line;
        Grain128AEADEngine grain = new Grain128AEADEngine();
        InputStream src = TestResourceFinder.findTestResource("crypto", "LWC_AEAD_KAT_128_96.txt");
        BufferedReader bin = new BufferedReader(new InputStreamReader(src));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = bin.readLine()) != null) {
            void var5_6;
            int a = var5_6.indexOf(61);
            if (a < 0) {
                ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(Hex.decode((String)((String)map.get("Key")))), Hex.decode((String)((String)map.get("Nonce"))));
                grain.init(true, (CipherParameters)params);
                byte[] adByte = Hex.decode((String)((String)map.get("AD")));
                grain.processAADBytes(adByte, 0, adByte.length);
                byte[] ptByte = Hex.decode((String)((String)map.get("PT")));
                byte[] rv = new byte[ptByte.length];
                grain.processBytes(ptByte, 0, ptByte.length, rv, 0);
                byte[] mac = new byte[8];
                grain.doFinal(mac, 0);
                if (!this.areEqual(Arrays.concatenate((byte[])rv, (byte[])mac), Hex.decode((String)((String)map.get("CT"))))) {
                    this.mismatch("Keystream " + map.get("Count"), (String)map.get("CT"), rv);
                }
                map.clear();
                continue;
            }
            map.put(var5_6.substring(0, a).trim(), var5_6.substring(a + 1).trim());
        }
    }

    private void testSplitUpdate() throws InvalidCipherTextException {
        byte[] Key2 = Hex.decode((String)"000102030405060708090A0B0C0D0E0F");
        byte[] Nonce = Hex.decode((String)"000102030405060708090A0B");
        byte[] PT = Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
        byte[] AD = Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E");
        byte[] CT = Hex.decode((String)"EAD60EF559493ACEF6A3C238C018835DE3ABB6AA621A9AA65EFAF7B9D05BBE6C0913DFC8674BACC9");
        Grain128AEADEngine grain = new Grain128AEADEngine();
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(Key2), Nonce);
        grain.init(true, (CipherParameters)params);
        grain.processAADBytes(AD, 0, 10);
        grain.processAADByte(AD[10]);
        grain.processAADBytes(AD, 11, AD.length - 11);
        byte[] rv = new byte[CT.length];
        int len = grain.processBytes(PT, 0, 10, rv, 0);
        len += grain.processByte(PT[10], rv, len);
        len += grain.processBytes(PT, 11, PT.length - 11, rv, len);
        grain.doFinal(rv, len);
        this.isTrue(Arrays.areEqual((byte[])rv, (byte[])CT));
        grain.processBytes(PT, 0, 10, rv, 0);
        try {
            grain.processAADByte((byte)1);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("associated data must be added before plaintext/ciphertext", e.getMessage());
        }
        try {
            grain.processAADBytes(AD, 0, AD.length);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("associated data must be added before plaintext/ciphertext", e.getMessage());
        }
    }

    private void testLongAEAD() throws InvalidCipherTextException {
        byte[] Key2 = Hex.decode((String)"000102030405060708090A0B0C0D0E0F");
        byte[] Nonce = Hex.decode((String)"000102030405060708090A0B");
        byte[] PT = Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
        byte[] AD = Hex.decode((String)"000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9");
        byte[] CT = Hex.decode((String)"731DAA8B1D15317A1CCB4E3DD320095FB27E5BB2A10F2C669F870538637D4F162298C70430A2B560");
        Grain128AEADEngine grain = new Grain128AEADEngine();
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(Key2), Nonce);
        grain.init(true, (CipherParameters)params);
        grain.processAADBytes(AD, 0, AD.length);
        byte[] rv = new byte[CT.length];
        int len = grain.processBytes(PT, 0, 10, rv, 0);
        len += grain.processByte(PT[10], rv, len);
        len += grain.processBytes(PT, 11, PT.length - 11, rv, len);
        grain.doFinal(rv, len);
        this.isTrue(Arrays.areEqual((byte[])rv, (byte[])CT));
        grain.processBytes(PT, 0, 10, rv, 0);
        try {
            grain.processAADByte((byte)1);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("associated data must be added before plaintext/ciphertext", e.getMessage());
        }
        try {
            grain.processAADBytes(AD, 0, AD.length);
            this.fail("no exception");
        }
        catch (IllegalStateException e) {
            this.isEquals("associated data must be added before plaintext/ciphertext", e.getMessage());
        }
    }

    private void testExceptions() throws InvalidCipherTextException {
        Grain128AEADEngine grain128;
        try {
            grain128 = new Grain128AEADEngine();
            grain128.init(true, (CipherParameters)new KeyParameter(new byte[10]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("Grain-128AEAD init parameters must include an IV", e.getMessage());
        }
        try {
            grain128 = new Grain128AEADEngine();
            grain128.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[10]), new byte[8]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("Grain-128AEAD requires exactly 12 bytes of IV", e.getMessage());
        }
        try {
            grain128 = new Grain128AEADEngine();
            grain128.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(new byte[10]), new byte[12]));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("Grain-128AEAD key must be 128 bits long", e.getMessage());
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode((byte[])found)));
    }

    public static void main(String[] args) {
        SimpleTest.runTest(new Grain128AEADTest());
    }
}

